/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.file;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    private ZipUtil() {
    }

    public static Map<String, byte[]> unZipByGbk(byte[] bytes) throws Exception {
        HashMap<String, byte[]> fileNameByteMap = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)new ByteArrayInputStream(bytes), Charset.forName("GBK"));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null && !zipEntry.isDirectory()) {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            String fileName = zipEntry.getName();
            byte[] bufferBytes = new byte[1024];
            while ((len = zipInputStream.read(bufferBytes, 0, bufferBytes.length)) != -1) {
                bos.write(bufferBytes, 0, len);
            }
            bos.flush();
            bos.close();
            zipInputStream.closeEntry();
            fileNameByteMap.put(fileName, bos.toByteArray());
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return fileNameByteMap;
    }

    public static void unZipByGbk(byte[] bytes, String filePath) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)new ByteArrayInputStream(bytes), Charset.forName("GBK"));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.isDirectory()) continue;
            String unZipFilePath = filePath + File.separator + zipEntry.getName();
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(unZipFilePath));){
                int len;
                byte[] bufferBytes = new byte[1024];
                while ((len = zipInputStream.read(bufferBytes, 0, bufferBytes.length)) != -1) {
                    bufferedOutputStream.write(bufferBytes, 0, len);
                }
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
    }
}

