/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.draft.DocFinalizeReq;
import com.fasc.open.api.v5_1.req.draft.DraftAddMembersReq;
import com.fasc.open.api.v5_1.req.draft.DraftCreateReq;
import com.fasc.open.api.v5_1.req.draft.GetEditUrlReq;
import com.fasc.open.api.v5_1.req.draft.GetFinishedFileReq;
import com.fasc.open.api.v5_1.req.draft.GetInviteUrlReq;
import com.fasc.open.api.v5_1.req.draft.GetManageUrlReq;
import com.fasc.open.api.v5_1.req.draft.SearchInitiatedDraftListReq;
import com.fasc.open.api.v5_1.req.draft.SearchJoinedDraftListReq;
import com.fasc.open.api.v5_1.res.draft.DraftCreateRes;
import com.fasc.open.api.v5_1.res.draft.GetEditUrlRes;
import com.fasc.open.api.v5_1.res.draft.GetFinishedFileRes;
import com.fasc.open.api.v5_1.res.draft.GetInviteUrlRes;
import com.fasc.open.api.v5_1.res.draft.GetManageUrlRes;
import com.fasc.open.api.v5_1.res.draft.SearchInitiatedDraftListRes;
import com.fasc.open.api.v5_1.res.draft.SearchJoinedDraftListRes;

public class DraftClient {
    private OpenApiClient openApiClient;

    public DraftClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<DraftCreateRes> draftCreate(DraftCreateReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/create", DraftCreateRes.class);
    }

    public BaseRes<GetInviteUrlRes> getDraftInviteUrl(GetInviteUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/get-invite-url", GetInviteUrlRes.class);
    }

    public BaseRes<GetEditUrlRes> getDraftEditUrl(GetEditUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/get-edit-url", GetEditUrlRes.class);
    }

    public BaseRes<GetManageUrlRes> getDraftManageUrl(GetManageUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/get-manage-url", GetManageUrlRes.class);
    }

    public BaseRes<Void> draftDocFinalize(DocFinalizeReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/doc-finalize", Void.class);
    }

    public BaseRes<GetFinishedFileRes> getDraftFinishedFile(GetFinishedFileReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/get-finished-file", GetFinishedFileRes.class);
    }

    public BaseRes<Void> addDraftMembers(DraftAddMembersReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/members/add", Void.class);
    }

    public BaseRes<SearchInitiatedDraftListRes> searchInitiatedDraftList(SearchInitiatedDraftListReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/owner/get-initiated-list", SearchInitiatedDraftListRes.class);
    }

    public BaseRes<SearchJoinedDraftListRes> searchJoinedDraftList(SearchJoinedDraftListReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /draft/owner/get-joined-list", SearchJoinedDraftListRes.class);
    }
}

