/*
 * Decompiled with CFR 0.152.
 */
package com.faforever.commons.api.dto;

import com.faforever.commons.api.dto.AbstractEntity;
import com.faforever.commons.api.dto.BanDurationType;
import com.faforever.commons.api.dto.BanLevel;
import com.faforever.commons.api.dto.BanStatus;
import com.faforever.commons.api.dto.ModerationReport;
import com.faforever.commons.api.dto.Player;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.jasminb.jsonapi.annotations.Relationship;
import com.github.jasminb.jsonapi.annotations.Type;
import java.time.OffsetDateTime;
import lombok.Generated;

@Type(value="banInfo")
public class BanInfo
extends AbstractEntity<BanInfo> {
    @Relationship(value="player")
    @JsonIgnore
    private Player player;
    @Relationship(value="author")
    @JsonIgnore
    private Player author;
    private String reason;
    private OffsetDateTime expiresAt;
    private BanLevel level;
    @Relationship(value="moderationReport")
    @JsonIgnore
    private ModerationReport moderationReport;
    private String revokeReason;
    @Relationship(value="revokeAuthor")
    @JsonIgnore
    private Player revokeAuthor;
    private OffsetDateTime revokeTime;
    @JsonIgnore
    private BanDurationType duration;
    @JsonIgnore
    private BanStatus banStatus;

    @JsonIgnore
    public BanDurationType getDuration() {
        return this.expiresAt == null ? BanDurationType.PERMANENT : BanDurationType.TEMPORARY;
    }

    @JsonIgnore
    public BanStatus getBanStatus() {
        if (this.revokeTime != null && this.revokeTime.isBefore(OffsetDateTime.now())) {
            return BanStatus.DISABLED;
        }
        if (this.getDuration() == BanDurationType.PERMANENT) {
            return BanStatus.BANNED;
        }
        return this.expiresAt.isAfter(OffsetDateTime.now()) ? BanStatus.BANNED : BanStatus.EXPIRED;
    }

    @Generated
    public BanInfo() {
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Player getAuthor() {
        return this.author;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public BanLevel getLevel() {
        return this.level;
    }

    @Generated
    public ModerationReport getModerationReport() {
        return this.moderationReport;
    }

    @Generated
    public String getRevokeReason() {
        return this.revokeReason;
    }

    @Generated
    public Player getRevokeAuthor() {
        return this.revokeAuthor;
    }

    @Generated
    public OffsetDateTime getRevokeTime() {
        return this.revokeTime;
    }

    @JsonIgnore
    @Generated
    public BanInfo setPlayer(Player player) {
        this.player = player;
        return this;
    }

    @JsonIgnore
    @Generated
    public BanInfo setAuthor(Player author) {
        this.author = author;
        return this;
    }

    @Generated
    public BanInfo setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Generated
    public BanInfo setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Generated
    public BanInfo setLevel(BanLevel level) {
        this.level = level;
        return this;
    }

    @JsonIgnore
    @Generated
    public BanInfo setModerationReport(ModerationReport moderationReport) {
        this.moderationReport = moderationReport;
        return this;
    }

    @Generated
    public BanInfo setRevokeReason(String revokeReason) {
        this.revokeReason = revokeReason;
        return this;
    }

    @JsonIgnore
    @Generated
    public BanInfo setRevokeAuthor(Player revokeAuthor) {
        this.revokeAuthor = revokeAuthor;
        return this;
    }

    @Generated
    public BanInfo setRevokeTime(OffsetDateTime revokeTime) {
        this.revokeTime = revokeTime;
        return this;
    }

    @JsonIgnore
    @Generated
    public BanInfo setDuration(BanDurationType duration) {
        this.duration = duration;
        return this;
    }

    @JsonIgnore
    @Generated
    public BanInfo setBanStatus(BanStatus banStatus) {
        this.banStatus = banStatus;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "BanInfo(super=" + super.toString() + ", level=" + String.valueOf((Object)this.getLevel()) + ", duration=" + String.valueOf((Object)this.getDuration()) + ", banStatus=" + String.valueOf((Object)this.getBanStatus()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanInfo)) {
            return false;
        }
        BanInfo other = (BanInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BanInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

