/*
 * Decompiled with CFR 0.152.
 */
package com.faforever.commons.api.elide;

import com.faforever.commons.api.elide.ElideEntity;
import com.faforever.commons.api.elide.ElideNavigatorOnCollection;
import com.faforever.commons.api.elide.ElideNavigatorOnId;
import com.faforever.commons.api.elide.ElideNavigatorSelector;
import com.faforever.commons.api.update.UpdateDto;
import com.github.jasminb.jsonapi.annotations.Type;
import com.github.rutledgepaulv.qbuilders.builders.QBuilder;
import com.github.rutledgepaulv.qbuilders.conditions.Condition;
import com.github.rutledgepaulv.qbuilders.visitors.ContextualNodeVisitor;
import com.github.rutledgepaulv.qbuilders.visitors.RSQLVisitor;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElideNavigator<T extends ElideEntity>
implements ElideNavigatorSelector<T>,
ElideNavigatorOnId<T>,
ElideNavigatorOnCollection<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElideNavigator.class);
    private final Class<T> dtoClass;
    private final Set<String> includes = new LinkedHashSet<String>();
    private final Set<String> sorts = new LinkedHashSet<String>();
    private final Optional<ElideNavigator<?>> parentNavigator;
    private Optional<String> id = Optional.empty();
    private Optional<String> relationship = Optional.empty();
    private Optional<Condition<?>> filterCondition = Optional.empty();
    private Optional<Integer> pageSize = Optional.empty();
    private Optional<Integer> pageNumber = Optional.empty();
    private Optional<Boolean> pageTotals = Optional.empty();

    private ElideNavigator(@NotNull Class<T> dtoClass) {
        this.dtoClass = dtoClass;
        this.parentNavigator = Optional.empty();
    }

    private ElideNavigator(@NotNull Class<T> dtoClass, @NotNull ElideNavigator<?> parentNavigator) {
        this.dtoClass = dtoClass;
        this.parentNavigator = Optional.of(parentNavigator);
    }

    public static <T extends QBuilder<T>> QBuilder<T> qBuilder() {
        return new QBuilder();
    }

    public static <T extends ElideEntity> ElideNavigatorSelector<T> of(@NotNull Class<T> dtoClass) {
        return new ElideNavigator<T>(dtoClass);
    }

    public static <T extends ElideEntity> ElideNavigatorOnId<T> of(@NotNull T entity) {
        return new ElideNavigator(entity.getClass()).id(entity.getId());
    }

    public static <T extends ElideEntity> ElideNavigatorOnId<T> of(@NotNull UpdateDto<T> entity) {
        return new ElideNavigator(entity.getClass()).id(entity.getId());
    }

    @Override
    public boolean isRoot() {
        return this.parentNavigator.isEmpty();
    }

    @Override
    public ElideNavigatorOnId<T> id(@NotNull String id) {
        this.id = Optional.of(id);
        return this;
    }

    @Override
    public ElideNavigatorOnCollection<T> collection() {
        return this;
    }

    @Override
    public ElideNavigator<T> addInclude(@NotNull String include) {
        log.trace("include added: {}", (Object)include);
        this.includes.add(include);
        return this;
    }

    @Override
    public <R extends ElideEntity> ElideNavigatorSelector<R> navigateRelationship(@NotNull Class<R> dtoClass, @NotNull String name) {
        if (!this.includes.isEmpty()) {
            throw new IllegalStateException("Cannot navigate relationship with includes on parent");
        }
        log.trace("relationship added: {}", (Object)name);
        this.relationship = Optional.of(name);
        return new ElideNavigator<R>(dtoClass, this);
    }

    @Override
    public ElideNavigatorOnCollection<T> addSortingRule(@NotNull String field, boolean ascending) {
        log.trace("{} sort added: {}", (Object)(ascending ? "ascending" : "descending"), (Object)field);
        this.sorts.add((ascending ? "" : "-") + field);
        return this;
    }

    @Override
    public ElideNavigatorOnCollection<T> setFilter(@NotNull Condition<?> eq) {
        log.trace("filter set: {}", eq.query((ContextualNodeVisitor)new RSQLVisitor()));
        this.filterCondition = Optional.of(eq);
        return this;
    }

    @Override
    public Optional<Condition<?>> getFilter() {
        return this.filterCondition;
    }

    @Override
    public ElideNavigatorOnCollection<T> pageSize(int size) {
        log.trace("page size set: {}", (Object)size);
        this.pageSize = Optional.of(size);
        return this;
    }

    @Override
    public ElideNavigatorOnCollection<T> pageNumber(int number) {
        log.trace("page number set: {}", (Object)number);
        this.pageNumber = Optional.of(number);
        return this;
    }

    @Override
    public ElideNavigatorOnCollection<T> pageTotals(boolean showTotals) {
        log.trace("page totals set: {}", (Object)showTotals);
        this.pageTotals = Optional.of(showTotals);
        return this;
    }

    @Override
    public String build() {
        String dtoPath = this.dtoClass.getDeclaredAnnotation(Type.class).value();
        StringJoiner queryArgs = new StringJoiner("&", "?", "").setEmptyValue("");
        if (this.includes.size() > 0) {
            queryArgs.add(String.format("include=%s", String.join((CharSequence)",", this.includes)));
        }
        this.filterCondition.ifPresent(cond -> queryArgs.add(String.format("filter=%s", cond.query((ContextualNodeVisitor)new RSQLVisitor()))));
        if (this.sorts.size() > 0) {
            queryArgs.add(String.format("sort=%s", String.join((CharSequence)",", this.sorts)));
        }
        this.pageSize.ifPresent(i -> queryArgs.add(String.format("page[size]=%s", i)));
        this.pageNumber.ifPresent(i -> queryArgs.add(String.format("page[number]=%s", i)));
        this.pageTotals.ifPresent(show -> {
            if (show.booleanValue()) {
                queryArgs.add("page[totals]");
            }
        });
        String route = this.parentNavigator.map(ElideNavigator::build).orElse("/data/" + dtoPath) + this.id.map(i -> "/" + i).orElse("") + this.relationship.map(r -> "/" + r).orElse("") + String.valueOf(queryArgs);
        log.trace("Route built: {}", (Object)route);
        return route;
    }

    @Override
    @Generated
    public Class<T> getDtoClass() {
        return this.dtoClass;
    }
}

