/*
 * Decompiled with CFR 0.152.
 */
package com.faforever.commons.lobby;

import com.faforever.commons.lobby.AcceptInviteToPartyRequest;
import com.faforever.commons.lobby.AddFoeRequest;
import com.faforever.commons.lobby.AddFriendRequest;
import com.faforever.commons.lobby.AuthenticateRequest;
import com.faforever.commons.lobby.AvatarListInfo;
import com.faforever.commons.lobby.AvatarListRequest;
import com.faforever.commons.lobby.BroadcastRequest;
import com.faforever.commons.lobby.ClientMessage;
import com.faforever.commons.lobby.ClientPingMessage;
import com.faforever.commons.lobby.ClientPongMessage;
import com.faforever.commons.lobby.ClosePlayerGameRequest;
import com.faforever.commons.lobby.ClosePlayerLobbyRequest;
import com.faforever.commons.lobby.ConnectionStatus;
import com.faforever.commons.lobby.Faction;
import com.faforever.commons.lobby.FafLobbyApi;
import com.faforever.commons.lobby.FafLobbyClient;
import com.faforever.commons.lobby.FafLobbyClientKt;
import com.faforever.commons.lobby.GameAccess;
import com.faforever.commons.lobby.GameJoinFailed;
import com.faforever.commons.lobby.GameJoinFailedException;
import com.faforever.commons.lobby.GameLaunchResponse;
import com.faforever.commons.lobby.GameMatchmakingRequest;
import com.faforever.commons.lobby.GameVisibility;
import com.faforever.commons.lobby.GpgGameOutboundMessage;
import com.faforever.commons.lobby.HostGameRequest;
import com.faforever.commons.lobby.IceServer;
import com.faforever.commons.lobby.IceServerListRequest;
import com.faforever.commons.lobby.IceServerListResponse;
import com.faforever.commons.lobby.InviteToPartyRequest;
import com.faforever.commons.lobby.IsReadyResponse;
import com.faforever.commons.lobby.JoinGameRequest;
import com.faforever.commons.lobby.KickPlayerFromPartyRequest;
import com.faforever.commons.lobby.LeavePartyRequest;
import com.faforever.commons.lobby.LoginException;
import com.faforever.commons.lobby.LoginFailedResponse;
import com.faforever.commons.lobby.LoginResponse;
import com.faforever.commons.lobby.LoginSuccessResponse;
import com.faforever.commons.lobby.MatchmakerInfoRequest;
import com.faforever.commons.lobby.MatchmakerState;
import com.faforever.commons.lobby.Player;
import com.faforever.commons.lobby.RemoveFoeRequest;
import com.faforever.commons.lobby.RemoveFriendRequest;
import com.faforever.commons.lobby.RestoreGameSessionRequest;
import com.faforever.commons.lobby.SelectAvatarRequest;
import com.faforever.commons.lobby.SelectPartyFactionsRequest;
import com.faforever.commons.lobby.ServerMessage;
import com.faforever.commons.lobby.ServerPingMessage;
import com.faforever.commons.lobby.ServerPongMessage;
import com.faforever.commons.lobby.SessionRequest;
import com.faforever.commons.lobby.SessionResponse;
import com.faforever.commons.lobby.SetPlayerVetoesRequest;
import com.faforever.commons.lobby.UnreadyPartyRequest;
import com.faforever.commons.lobby.VetoData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.LineEncoder;
import io.netty.handler.codec.string.LineSeparator;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.transport.ClientTransport;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001kB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0%H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020/H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020/0%H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020/0%H\u0002J\u0010\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\u0016H\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020/0%2\u0006\u00104\u001a\u00020\u001aH\u0002J\u0010\u00106\u001a\u00020/2\u0006\u00104\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016JY\u0010<\u001a\b\u0012\u0004\u0012\u00020=0%2\u0006\u0010>\u001a\u0002072\u0006\u0010?\u001a\u0002072\u0006\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u0001072\b\u0010D\u001a\u0004\u0018\u00010:2\b\u0010E\u001a\u0004\u0018\u00010:2\u0006\u0010F\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010GJ \u0010H\u001a\b\u0012\u0004\u0012\u00020=0%2\u0006\u0010I\u001a\u00020:2\b\u0010C\u001a\u0004\u0018\u000107H\u0016J\u0010\u0010J\u001a\u00020/2\u0006\u0010I\u001a\u00020:H\u0016J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020L0\u0018H\u0017J\u0010\u0010M\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010N\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010O\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010P\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0012\u0010Q\u001a\u00020/2\b\u0010R\u001a\u0004\u0018\u000107H\u0016J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u0018H\u0016J\u0010\u0010U\u001a\u00020/2\u0006\u0010V\u001a\u000207H\u0016J\b\u0010W\u001a\u00020/H\u0016J\u0018\u0010X\u001a\u00020/2\u0006\u0010Y\u001a\u0002072\u0006\u0010Z\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010]\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010^\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010_\u001a\u00020/H\u0016J\b\u0010`\u001a\u00020/H\u0016J\u0016\u0010a\u001a\u00020/2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0016J\u0016\u0010e\u001a\u00020/2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0gH\u0016J\u0010\u0010i\u001a\u00020/2\u0006\u00104\u001a\u00020jH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001a0\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u001c\u0010$\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010&0&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010&0&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/faforever/commons/lobby/FafLobbyClient;", "Lcom/faforever/commons/lobby/FafLobbyApi;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "config", "Lcom/faforever/commons/lobby/FafLobbyClient$Config;", "connection", "Lreactor/netty/Connection;", "pingDisposable", "Lreactor/core/Disposable;", "connecting", "", "minPingIntervalSeconds", "", "getMinPingIntervalSeconds", "()J", "setMinPingIntervalSeconds", "(J)V", "outboundSink", "Lreactor/core/publisher/Sinks$Many;", "Lcom/faforever/commons/lobby/ClientMessage;", "outboundMessages", "Lreactor/core/publisher/Flux;", "eventSink", "Lcom/faforever/commons/lobby/ServerMessage;", "rawEvents", "kotlin.jvm.PlatformType", "connectionStatusSink", "Lcom/faforever/commons/lobby/ConnectionStatus;", "connectionStatus", "getConnectionStatus", "()Lreactor/core/publisher/Flux;", "events", "getEvents", "loginResponseMono", "Lreactor/core/publisher/Mono;", "Lcom/faforever/commons/lobby/Player;", "loginMono", "retrySerialFailure", "Lreactor/core/publisher/Sinks$EmitFailureHandler;", "httpClient", "Lreactor/netty/http/client/HttpClient;", "openConnection", "connectAndLogin", "prepareAuthenticateOnNextSession", "", "disconnect", "pingWithDelay", "ping", "send", "message", "handle", "broadcastMessage", "", "closePlayerGame", "playerId", "", "closePlayerLobby", "requestHostGame", "Lcom/faforever/commons/lobby/GameLaunchResponse;", "title", "mapName", "mod", "visibility", "Lcom/faforever/commons/lobby/GameVisibility;", "password", "ratingMin", "ratingMax", "enforceRatingRange", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/faforever/commons/lobby/GameVisibility;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Z)Lreactor/core/publisher/Mono;", "requestJoinGame", "gameId", "restoreGameSession", "getIceServers", "Lcom/faforever/commons/lobby/IceServer;", "addFriend", "addFoe", "removeFriend", "removeFoe", "selectAvatar", "url", "getAvailableAvatars", "Lcom/faforever/commons/lobby/Player$Avatar;", "sendReady", "requestId", "requestMatchmakerInfo", "gameMatchmaking", "queueName", "state", "Lcom/faforever/commons/lobby/MatchmakerState;", "inviteToParty", "acceptPartyInvite", "kickPlayerFromParty", "unreadyParty", "leaveParty", "setPartyFactions", "factions", "", "Lcom/faforever/commons/lobby/Faction;", "setPlayerVetoes", "vetoes", "", "Lcom/faforever/commons/lobby/VetoData;", "sendGpgGameMessage", "Lcom/faforever/commons/lobby/GpgGameOutboundMessage;", "Config", "lobby"})
public final class FafLobbyClient
implements FafLobbyApi {
    @NotNull
    private final ObjectMapper mapper;
    private Config config;
    @Nullable
    private Connection connection;
    @Nullable
    private Disposable pingDisposable;
    private boolean connecting;
    private long minPingIntervalSeconds;
    @NotNull
    private final Sinks.Many<ClientMessage> outboundSink;
    @NotNull
    private final Flux<ClientMessage> outboundMessages;
    @NotNull
    private final Sinks.Many<ServerMessage> eventSink;
    @NotNull
    private final Flux<ServerMessage> rawEvents;
    @NotNull
    private final Sinks.Many<ConnectionStatus> connectionStatusSink;
    @NotNull
    private final Flux<ConnectionStatus> connectionStatus;
    @NotNull
    private final Flux<ServerMessage> events;
    @NotNull
    private final Mono<Player> loginResponseMono;
    @NotNull
    private final Mono<Player> loginMono;
    @NotNull
    private final Sinks.EmitFailureHandler retrySerialFailure;
    @NotNull
    private final HttpClient httpClient;

    public FafLobbyClient(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
        this.minPingIntervalSeconds = 60L;
        Sinks.Many many = Sinks.many().unicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many, (String)"onBackpressureBuffer(...)");
        this.outboundSink = many;
        Flux flux = this.outboundSink.asFlux().publish().autoConnect();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"autoConnect(...)");
        this.outboundMessages = flux;
        Sinks.Many many2 = Sinks.many().unicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many2, (String)"onBackpressureBuffer(...)");
        this.eventSink = many2;
        Flux flux2 = this.eventSink.asFlux().publish().autoConnect();
        Intrinsics.checkNotNullExpressionValue((Object)flux2, (String)"autoConnect(...)");
        this.rawEvents = flux2;
        Sinks.Many many3 = Sinks.many().unicast().onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)many3, (String)"onBackpressureBuffer(...)");
        this.connectionStatusSink = many3;
        Flux flux3 = this.connectionStatusSink.asFlux().publish().autoConnect();
        Intrinsics.checkNotNullExpressionValue((Object)flux3, (String)"autoConnect(...)");
        this.connectionStatus = flux3;
        Flux flux4 = this.rawEvents.filter(arg_0 -> FafLobbyClient.events$lambda$1(FafLobbyClient::events$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux4, (String)"filter(...)");
        this.events = flux4;
        Mono mono = this.rawEvents.ofType(LoginResponse.class).next().flatMap(arg_0 -> FafLobbyClient.loginResponseMono$lambda$3(FafLobbyClient::loginResponseMono$lambda$2, arg_0)).doFirst(() -> FafLobbyClient.loginResponseMono$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doFirst(...)");
        this.loginResponseMono = mono;
        mono = Mono.defer(() -> FafLobbyClient.loginMono$lambda$5(this)).doOnError(arg_0 -> FafLobbyClient.loginMono$lambda$7(arg_0 -> FafLobbyClient.loginMono$lambda$6(this, arg_0), arg_0)).doOnCancel(() -> FafLobbyClient.loginMono$lambda$8(this)).doOnSuccess(arg_0 -> FafLobbyClient.loginMono$lambda$10(arg_0 -> FafLobbyClient.loginMono$lambda$9(this, arg_0), arg_0)).doOnSubscribe(arg_0 -> FafLobbyClient.loginMono$lambda$12(FafLobbyClient::loginMono$lambda$11, arg_0)).materialize().cacheInvalidateIf(arg_0 -> FafLobbyClient.loginMono$lambda$14(arg_0 -> FafLobbyClient.loginMono$lambda$13(this, arg_0), arg_0)).dematerialize();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"dematerialize(...)");
        this.loginMono = mono;
        this.retrySerialFailure = FafLobbyClient::retrySerialFailure$lambda$15;
        ClientTransport clientTransport = ((HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.newConnection().resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE)).doOnResolveError((arg_0, arg_1) -> FafLobbyClient.httpClient$lambda$17(FafLobbyClient::httpClient$lambda$16, arg_0, arg_1))).doOnConnect(arg_0 -> FafLobbyClient.httpClient$lambda$19(arg_0 -> FafLobbyClient.httpClient$lambda$18(this, arg_0), arg_0))).doOnConnected(arg_0 -> FafLobbyClient.httpClient$lambda$21(arg_0 -> FafLobbyClient.httpClient$lambda$20(this, arg_0), arg_0))).doOnDisconnected(arg_0 -> FafLobbyClient.httpClient$lambda$23(arg_0 -> FafLobbyClient.httpClient$lambda$22(this, arg_0), arg_0))).doOnResolveError((arg_0, arg_1) -> FafLobbyClient.httpClient$lambda$25(FafLobbyClient::httpClient$lambda$24, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"doOnResolveError(...)");
        this.httpClient = (HttpClient)clientTransport;
        this.rawEvents.filter(arg_0 -> FafLobbyClient._init_$lambda$27(FafLobbyClient::_init_$lambda$26, arg_0)).doOnNext(arg_0 -> FafLobbyClient._init_$lambda$29(arg_0 -> FafLobbyClient._init_$lambda$28(this, arg_0), arg_0)).subscribe();
        this.getConnectionStatus().doOnNext(arg_0 -> FafLobbyClient._init_$lambda$31(arg_0 -> FafLobbyClient._init_$lambda$30(this, arg_0), arg_0)).subscribe();
    }

    public final long getMinPingIntervalSeconds() {
        return this.minPingIntervalSeconds;
    }

    public final void setMinPingIntervalSeconds(long l) {
        this.minPingIntervalSeconds = l;
    }

    @Override
    @NotNull
    public Flux<ConnectionStatus> getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    @NotNull
    public Flux<ServerMessage> getEvents() {
        return this.events;
    }

    private final Mono<? extends Connection> openConnection() {
        FafLobbyClientKt.access$getLOG$p().debug("Beginning connection process");
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        HttpClient httpClient = this.httpClient.wiretap(config.getWiretap());
        WebsocketClientSpec.Builder builder = WebsocketClientSpec.builder();
        Config config2 = this.config;
        if (config2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config2 = null;
        }
        HttpClient.WebsocketSender websocketSender = httpClient.websocket(((WebsocketClientSpec.Builder)builder.maxFramePayloadLength(config2.getBufferSize())).build());
        Config config3 = this.config;
        if (config3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config3 = null;
        }
        Mono mono = ((HttpClient.WebsocketSender)websocketSender.uri(config3.getUrl())).connect().doOnNext(arg_0 -> FafLobbyClient.openConnection$lambda$32(new Function1(this){
            final /* synthetic */ FafLobbyClient this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(Connection connection) {
                Mono mono = connection.inbound().receive().asString(Charsets.UTF_8).flatMapIterable(arg_0 -> openConnection.1.invoke$lambda$1(openConnection.1::invoke$lambda$0, arg_0)).windowUntil(openConnection.1::invoke$lambda$2).flatMap(arg_0 -> openConnection.1.invoke$lambda$10(openConnection.1::invoke$lambda$9, arg_0)).doOnError(arg_0 -> openConnection.1.invoke$lambda$12(openConnection.1::invoke$lambda$11, arg_0)).doOnComplete(openConnection.1::invoke$lambda$13).doOnCancel(openConnection.1::invoke$lambda$14).flatMap(arg_0 -> openConnection.1.invoke$lambda$19(arg_0 -> openConnection.1.invoke$lambda$18(this.this$0, arg_0), arg_0)).flatMap(arg_0 -> openConnection.1.invoke$lambda$23(arg_0 -> openConnection.1.invoke$lambda$22(this.this$0, arg_0), arg_0)).doOnNext(arg_0 -> openConnection.1.invoke$lambda$25(arg_0 -> openConnection.1.invoke$lambda$24(this.this$0, arg_0), arg_0)).then();
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
                Mono inboundMono = mono;
                Mono[] monoArray = connection.outbound().sendString((Publisher)FafLobbyClient.access$getOutboundMessages$p(this.this$0).doOnError(arg_0 -> openConnection.1.invoke$lambda$27(openConnection.1::invoke$lambda$26, arg_0)).doOnComplete(openConnection.1::invoke$lambda$28).doOnCancel(openConnection.1::invoke$lambda$29).doOnNext(arg_0 -> openConnection.1.invoke$lambda$31(arg_0 -> openConnection.1.invoke$lambda$30(this.this$0, arg_0), arg_0)).flatMap(arg_0 -> openConnection.1.invoke$lambda$36(arg_0 -> openConnection.1.invoke$lambda$35(this.this$0, arg_0), arg_0))).neverComplete();
                Intrinsics.checkNotNullExpressionValue((Object)monoArray, (String)"neverComplete(...)");
                Mono[] outboundMono = monoArray;
                monoArray = new Mono[]{inboundMono, outboundMono};
                Mono.firstWithSignal((Mono[])monoArray).subscribeOn(Schedulers.single()).subscribe();
            }

            private static final Iterable invoke$lambda$0(String it) {
                Intrinsics.checkNotNull((Object)it);
                char[] cArray = it.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                return ArraysKt.asIterable((char[])cArray);
            }

            private static final Iterable invoke$lambda$1(Function1 $tmp0, Object p0) {
                return (Iterable)$tmp0.invoke(p0);
            }

            private static final boolean invoke$lambda$2(Character it) {
                Character c = it;
                return c != null && '\n' == c.charValue();
            }

            private static final boolean invoke$lambda$9$lambda$3(Character c) {
                Character c2 = c;
                return c2 == null || '\n' != c2.charValue();
            }

            private static final boolean invoke$lambda$9$lambda$4(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final char[] invoke$lambda$9$lambda$5(List chars) {
                Intrinsics.checkNotNull((Object)chars);
                return CollectionsKt.toCharArray((Collection)chars);
            }

            private static final char[] invoke$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
                return (char[])$tmp0.invoke(p0);
            }

            private static final String invoke$lambda$9$lambda$7(char[] charArray) {
                Intrinsics.checkNotNull((Object)charArray);
                return new String(charArray);
            }

            private static final String invoke$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }

            private static final Publisher invoke$lambda$9(Flux it) {
                return (Publisher)it.takeWhile(arg_0 -> openConnection.1.invoke$lambda$9$lambda$4(openConnection.1::invoke$lambda$9$lambda$3, arg_0)).collectList().map(arg_0 -> openConnection.1.invoke$lambda$9$lambda$6(openConnection.1::invoke$lambda$9$lambda$5, arg_0)).map(arg_0 -> openConnection.1.invoke$lambda$9$lambda$8(openConnection.1::invoke$lambda$9$lambda$7, arg_0));
            }

            private static final Publisher invoke$lambda$10(Function1 $tmp0, Object p0) {
                return (Publisher)$tmp0.invoke(p0);
            }

            private static final Unit invoke$lambda$11(Throwable it) {
                FafLobbyClientKt.access$getLOG$p().error("Inbound channel closed with error", it);
                return Unit.INSTANCE;
            }

            private static final void invoke$lambda$12(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$13() {
                FafLobbyClientKt.access$getLOG$p().info("Inbound channel closed");
            }

            private static final void invoke$lambda$14() {
                FafLobbyClientKt.access$getLOG$p().info("Inbound channel cancelled");
            }

            private static final ServerMessage invoke$lambda$18$lambda$15(FafLobbyClient this$0, String $it) {
                ServerMessage serverMessage = (ServerMessage)FafLobbyClient.access$getMapper$p(this$0).readValue($it, ServerMessage.class);
                String logMessage = $it;
                for (String string : serverMessage.stringsToMask()) {
                    String string2 = logMessage;
                    Intrinsics.checkNotNull((Object)string2);
                    logMessage = StringsKt.replace$default((String)string2, (String)string, (String)"**********", (boolean)false, (int)4, null);
                }
                FafLobbyClientKt.access$getLOG$p().trace("Inbound message: {}", (Object)logMessage);
                return serverMessage;
            }

            private static final Mono invoke$lambda$18$lambda$16(String $it, Throwable throwable) {
                FafLobbyClientKt.access$getLOG$p().error("Error during deserialization of message {}", (Object)$it, (Object)throwable);
                return Mono.empty();
            }

            private static final Mono invoke$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
                return (Mono)$tmp0.invoke(p0);
            }

            private static final Publisher invoke$lambda$18(FafLobbyClient this$0, String it) {
                return (Publisher)Mono.fromCallable(() -> openConnection.1.invoke$lambda$18$lambda$15(this$0, it)).onErrorResume(arg_0 -> openConnection.1.invoke$lambda$18$lambda$17(arg_0 -> openConnection.1.invoke$lambda$18$lambda$16(it, arg_0), arg_0));
            }

            private static final Publisher invoke$lambda$19(Function1 $tmp0, Object p0) {
                return (Publisher)$tmp0.invoke(p0);
            }

            private static final Mono invoke$lambda$22$lambda$20(ServerMessage $message, Throwable it) {
                FafLobbyClientKt.access$getLOG$p().error("Error during handling of message {}", (Object)$message, (Object)it);
                return Mono.empty();
            }

            private static final Mono invoke$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
                return (Mono)$tmp0.invoke(p0);
            }

            private static final Publisher invoke$lambda$22(FafLobbyClient this$0, ServerMessage message) {
                Intrinsics.checkNotNull((Object)message);
                return (Publisher)FafLobbyClient.access$handle(this$0, message).onErrorResume(arg_0 -> openConnection.1.invoke$lambda$22$lambda$21(arg_0 -> openConnection.1.invoke$lambda$22$lambda$20(message, arg_0), arg_0));
            }

            private static final Publisher invoke$lambda$23(Function1 $tmp0, Object p0) {
                return (Publisher)$tmp0.invoke(p0);
            }

            private static final Unit invoke$lambda$24(FafLobbyClient this$0, Unit it) {
                Disposable disposable = FafLobbyClient.access$getPingDisposable$p(this$0);
                if (disposable != null) {
                    disposable.dispose();
                }
                FafLobbyClient.access$setPingDisposable$p(this$0, FafLobbyClient.access$pingWithDelay(this$0).subscribeOn(Schedulers.single()).subscribe());
                return Unit.INSTANCE;
            }

            private static final void invoke$lambda$25(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final Unit invoke$lambda$26(Throwable it) {
                FafLobbyClientKt.access$getLOG$p().error("Outbound channel closed with error", it);
                return Unit.INSTANCE;
            }

            private static final void invoke$lambda$27(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$28() {
                FafLobbyClientKt.access$getLOG$p().info("Outbound channel closed");
            }

            private static final void invoke$lambda$29() {
                FafLobbyClientKt.access$getLOG$p().info("Outbound channel cancelled");
            }

            private static final Unit invoke$lambda$30(FafLobbyClient this$0, ClientMessage it) {
                if (!(it instanceof ClientPingMessage)) {
                    Disposable disposable = FafLobbyClient.access$getPingDisposable$p(this$0);
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    FafLobbyClient.access$setPingDisposable$p(this$0, FafLobbyClient.access$pingWithDelay(this$0).subscribeOn(Schedulers.single()).subscribe());
                }
                return Unit.INSTANCE;
            }

            private static final void invoke$lambda$31(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final String invoke$lambda$35$lambda$32(FafLobbyClient this$0, ClientMessage $it) {
                String jsonMessage;
                String logMessage = jsonMessage = FafLobbyClient.access$getMapper$p(this$0).writeValueAsString((Object)$it);
                for (String string : $it.stringsToMask()) {
                    String string2 = logMessage;
                    Intrinsics.checkNotNull((Object)string2);
                    logMessage = StringsKt.replace$default((String)string2, (String)string, (String)"**********", (boolean)false, (int)4, null);
                }
                FafLobbyClientKt.access$getLOG$p().trace("Outbound message: {}", (Object)logMessage);
                return jsonMessage + "\n";
            }

            private static final Mono invoke$lambda$35$lambda$33(ClientMessage $it, Throwable throwable) {
                FafLobbyClientKt.access$getLOG$p().error("Error during serialization of message {}", (Object)$it, (Object)throwable);
                return Mono.empty();
            }

            private static final Mono invoke$lambda$35$lambda$34(Function1 $tmp0, Object p0) {
                return (Mono)$tmp0.invoke(p0);
            }

            private static final Publisher invoke$lambda$35(FafLobbyClient this$0, ClientMessage it) {
                return (Publisher)Mono.fromCallable(() -> openConnection.1.invoke$lambda$35$lambda$32(this$0, it)).onErrorResume(arg_0 -> openConnection.1.invoke$lambda$35$lambda$34(arg_0 -> openConnection.1.invoke$lambda$35$lambda$33(it, arg_0), arg_0));
            }

            private static final Publisher invoke$lambda$36(Function1 $tmp0, Object p0) {
                return (Publisher)$tmp0.invoke(p0);
            }
        }, arg_0)).doOnCancel(FafLobbyClient::openConnection$lambda$33).doOnSubscribe(arg_0 -> FafLobbyClient.openConnection$lambda$35(arg_0 -> FafLobbyClient.openConnection$lambda$34(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSubscribe(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Player> connectAndLogin(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        return this.loginMono;
    }

    private final void prepareAuthenticateOnNextSession() {
        FafLobbyClientKt.access$getLOG$p().debug("Starting session listener");
        this.rawEvents.ofType(SessionResponse.class).next().doOnNext(arg_0 -> FafLobbyClient.prepareAuthenticateOnNextSession$lambda$37(arg_0 -> FafLobbyClient.prepareAuthenticateOnNextSession$lambda$36(this, arg_0), arg_0)).subscribeOn(Schedulers.single()).subscribe();
    }

    @Override
    public void disconnect() {
        block0: {
            Connection connection = this.connection;
            if (connection == null) break block0;
            connection.dispose();
        }
    }

    private final Mono<Unit> pingWithDelay() {
        Mono mono = this.ping().delaySubscription(Duration.ofSeconds(this.minPingIntervalSeconds));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"delaySubscription(...)");
        return mono;
    }

    private final Mono<Unit> ping() {
        Mono mono = Mono.fromCallable(() -> FafLobbyClient.ping$lambda$38(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromCallable(...)");
        return mono;
    }

    private final void send(ClientMessage message) {
        FafLobbyClientKt.access$getLOG$p().trace("Sending message of type {}", message.getClass());
        this.outboundSink.emitNext((Object)message, this.retrySerialFailure);
    }

    private final Mono<Unit> handle(ServerMessage message) {
        Mono mono = Mono.fromCallable(() -> FafLobbyClient.handle$lambda$39(this, message));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromCallable(...)");
        return mono;
    }

    @Override
    public void broadcastMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.send(new BroadcastRequest(message, null, 2, null));
    }

    @Override
    public void closePlayerGame(int playerId) {
        this.send(new ClosePlayerGameRequest(playerId, null, 2, null));
    }

    @Override
    public void closePlayerLobby(int playerId) {
        this.send(new ClosePlayerLobbyRequest(playerId, null, 2, null));
    }

    @Override
    @NotNull
    public Mono<GameLaunchResponse> requestHostGame(@NotNull String title, @NotNull String mapName, @NotNull String mod, @NotNull GameVisibility visibility, @Nullable String password, @Nullable Integer ratingMin, @Nullable Integer ratingMax, boolean enforceRatingRange) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)mapName, (String)"mapName");
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        Intrinsics.checkNotNullParameter((Object)((Object)visibility), (String)"visibility");
        Mono mono = Mono.fromCallable(() -> FafLobbyClient.requestHostGame$lambda$40(this, mapName, title, mod, password, visibility, ratingMin, ratingMax, enforceRatingRange)).then(this.getEvents().ofType(GameLaunchResponse.class).next());
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<GameLaunchResponse> requestJoinGame(int gameId, @Nullable String password) {
        Mono mono = Mono.fromCallable(() -> FafLobbyClient.requestJoinGame$lambda$41(this, gameId, password)).then(this.getEvents().filter(arg_0 -> FafLobbyClient.requestJoinGame$lambda$43(arg_0 -> FafLobbyClient.requestJoinGame$lambda$42(gameId, arg_0), arg_0)).flatMap(arg_0 -> FafLobbyClient.requestJoinGame$lambda$45(arg_0 -> FafLobbyClient.requestJoinGame$lambda$44(gameId, arg_0), arg_0)).next());
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @Override
    public void restoreGameSession(int gameId) {
        this.send(new RestoreGameSessionRequest(gameId));
    }

    @Override
    @Deprecated(message="Ice Servers should be queried from the FAF API")
    @NotNull
    public Flux<IceServer> getIceServers() {
        Flux flux = Mono.fromCallable(() -> FafLobbyClient.getIceServers$lambda$46(this)).thenMany((Publisher)this.getEvents().ofType(IceServerListResponse.class).next().flatMapIterable(arg_0 -> FafLobbyClient.getIceServers$lambda$48(FafLobbyClient::getIceServers$lambda$47, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"thenMany(...)");
        return flux;
    }

    @Override
    public void addFriend(int playerId) {
        this.send(new AddFriendRequest(playerId));
    }

    @Override
    public void addFoe(int playerId) {
        this.send(new AddFoeRequest(playerId));
    }

    @Override
    public void removeFriend(int playerId) {
        this.send(new RemoveFriendRequest(playerId));
    }

    @Override
    public void removeFoe(int playerId) {
        this.send(new RemoveFoeRequest(playerId));
    }

    @Override
    public void selectAvatar(@Nullable String url) {
        this.send(new SelectAvatarRequest(url));
    }

    @Override
    @NotNull
    public Flux<Player.Avatar> getAvailableAvatars() {
        Flux flux = Mono.fromCallable(() -> FafLobbyClient.getAvailableAvatars$lambda$49(this)).thenMany((Publisher)this.getEvents().ofType(AvatarListInfo.class).next().flatMapIterable(arg_0 -> FafLobbyClient.getAvailableAvatars$lambda$51(FafLobbyClient::getAvailableAvatars$lambda$50, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"thenMany(...)");
        return flux;
    }

    @Override
    public void sendReady(@NotNull String requestId) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        this.send(new IsReadyResponse(requestId));
    }

    @Override
    public void requestMatchmakerInfo() {
        this.send(new MatchmakerInfoRequest());
    }

    @Override
    public void gameMatchmaking(@NotNull String queueName, @NotNull MatchmakerState state) {
        Intrinsics.checkNotNullParameter((Object)queueName, (String)"queueName");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.send(new GameMatchmakingRequest(queueName, state));
    }

    @Override
    public void inviteToParty(int playerId) {
        this.send(new InviteToPartyRequest(playerId));
    }

    @Override
    public void acceptPartyInvite(int playerId) {
        this.send(new AcceptInviteToPartyRequest(playerId));
    }

    @Override
    public void kickPlayerFromParty(int playerId) {
        this.send(new KickPlayerFromPartyRequest(playerId));
    }

    @Override
    public void unreadyParty() {
        this.send(new UnreadyPartyRequest());
    }

    @Override
    public void leaveParty() {
        this.send(new LeavePartyRequest());
    }

    @Override
    public void setPartyFactions(@NotNull Set<? extends Faction> factions) {
        Intrinsics.checkNotNullParameter(factions, (String)"factions");
        this.send(new SelectPartyFactionsRequest(factions));
    }

    @Override
    public void setPlayerVetoes(@NotNull List<VetoData> vetoes) {
        Intrinsics.checkNotNullParameter(vetoes, (String)"vetoes");
        this.send(new SetPlayerVetoesRequest(vetoes));
    }

    @Override
    public void sendGpgGameMessage(@NotNull GpgGameOutboundMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.send(message);
    }

    private static final boolean events$lambda$0(ServerMessage it) {
        return !(it instanceof ServerPingMessage) && !(it instanceof ServerPongMessage) && !(it instanceof SessionResponse) && !(it instanceof LoginSuccessResponse) && !(it instanceof LoginFailedResponse);
    }

    private static final boolean events$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Mono loginResponseMono$lambda$2(LoginResponse it) {
        Mono mono;
        LoginResponse loginResponse = it;
        if (loginResponse instanceof LoginSuccessResponse) {
            mono = Mono.just((Object)((LoginSuccessResponse)it).getMe());
        } else if (loginResponse instanceof LoginFailedResponse) {
            mono = Mono.error((Throwable)new LoginException(((LoginFailedResponse)it).getText(), null, 2, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mono;
    }

    private static final Mono loginResponseMono$lambda$3(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void loginResponseMono$lambda$4(FafLobbyClient this$0) {
        this$0.prepareAuthenticateOnNextSession();
        Config config = this$0.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        String string = config.getVersion();
        Config config2 = this$0.config;
        if (config2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config2 = null;
        }
        this$0.send(new SessionRequest(string, config2.getUserAgent()));
    }

    private static final Mono loginMono$lambda$5(FafLobbyClient this$0) {
        return this$0.openConnection().then(this$0.loginResponseMono);
    }

    private static final Unit loginMono$lambda$6(FafLobbyClient this$0, Throwable it) {
        block0: {
            FafLobbyClientKt.access$getLOG$p().error("Error during connection", it);
            Connection connection = this$0.connection;
            if (connection == null) break block0;
            connection.dispose();
        }
        return Unit.INSTANCE;
    }

    private static final void loginMono$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void loginMono$lambda$8(FafLobbyClient this$0) {
        FafLobbyClientKt.access$getLOG$p().debug("Login cancelled");
        this$0.disconnect();
    }

    private static final Unit loginMono$lambda$9(FafLobbyClient this$0, Player it) {
        this$0.connectionStatusSink.emitNext((Object)ConnectionStatus.CONNECTED, this$0.retrySerialFailure);
        return Unit.INSTANCE;
    }

    private static final void loginMono$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit loginMono$lambda$11(Subscription it) {
        FafLobbyClientKt.access$getLOG$p().debug("Starting login process");
        return Unit.INSTANCE;
    }

    private static final void loginMono$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean loginMono$lambda$13(FafLobbyClient this$0, Signal it) {
        if (it.isOnError()) return true;
        if (this$0.connecting) return false;
        if (this$0.connection == null) return true;
        Connection connection = this$0.connection;
        if (connection == null) return false;
        if (!connection.isDisposed()) return false;
        return true;
    }

    private static final boolean loginMono$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean retrySerialFailure$lambda$15(SignalType signalType, Sinks.EmitResult emitResult) {
        Intrinsics.checkNotNullParameter((Object)signalType, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)emitResult, (String)"emitResult");
        return emitResult == Sinks.EmitResult.FAIL_NON_SERIALIZED;
    }

    private static final Unit httpClient$lambda$16(Connection connection, Throwable throwable) {
        FafLobbyClientKt.access$getLOG$p().error("Could not find server", throwable);
        connection.dispose();
        return Unit.INSTANCE;
    }

    private static final void httpClient$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit httpClient$lambda$18(FafLobbyClient this$0, HttpClientConfig it) {
        block0: {
            Connection connection = this$0.connection;
            if (connection == null) break block0;
            connection.dispose();
        }
        return Unit.INSTANCE;
    }

    private static final void httpClient$lambda$19(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit httpClient$lambda$20(FafLobbyClient this$0, Connection it) {
        SocketAddress socketAddress = it.channel().remoteAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress address = (InetSocketAddress)socketAddress;
        FafLobbyClientKt.access$getLOG$p().info("Connected to {} on port {}", (Object)address.getHostName(), (Object)address.getPort());
        Connection connection = it.addHandlerFirst((ChannelHandler)new LineEncoder(LineSeparator.UNIX));
        Config config = this$0.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        connection.addHandlerLast((ChannelHandler)new LineBasedFrameDecoder(config.getBufferSize()));
        this$0.connection = it;
        return Unit.INSTANCE;
    }

    private static final void httpClient$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit httpClient$lambda$22(FafLobbyClient this$0, Connection it) {
        FafLobbyClientKt.access$getLOG$p().info("Disconnected from server");
        it.dispose();
        Disposable disposable = this$0.pingDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this$0.connectionStatusSink.emitNext((Object)ConnectionStatus.DISCONNECTED, this$0.retrySerialFailure);
        return Unit.INSTANCE;
    }

    private static final void httpClient$lambda$23(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit httpClient$lambda$24(Connection conn, Throwable throwable) {
        FafLobbyClientKt.access$getLOG$p().error("Error resolving", throwable);
        conn.dispose();
        return Unit.INSTANCE;
    }

    private static final void httpClient$lambda$25(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final boolean _init_$lambda$26(ServerMessage it) {
        return it instanceof ServerPingMessage;
    }

    private static final boolean _init_$lambda$27(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$28(FafLobbyClient this$0, ServerMessage it) {
        this$0.send(new ClientPongMessage());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$30(FafLobbyClient this$0, ConnectionStatus it) {
        ConnectionStatus connectionStatus = it;
        this$0.connecting = switch (connectionStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[connectionStatus.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            case -1, 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$31(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void openConnection$lambda$32(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void openConnection$lambda$33() {
        FafLobbyClientKt.access$getLOG$p().info("Connection cancelled");
    }

    private static final Unit openConnection$lambda$34(FafLobbyClient this$0, Subscription it) {
        FafLobbyClientKt.access$getLOG$p().debug("Opening connection");
        this$0.connectionStatusSink.emitNext((Object)ConnectionStatus.CONNECTING, this$0.retrySerialFailure);
        return Unit.INSTANCE;
    }

    private static final void openConnection$lambda$35(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit prepareAuthenticateOnNextSession$lambda$36(FafLobbyClient this$0, SessionResponse it) {
        Config config = this$0.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        String string = config.getToken();
        long l = it.getSession();
        Config config2 = this$0.config;
        if (config2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config2 = null;
        }
        String string2 = config2.getUidGenerator().apply(it.getSession());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"apply(...)");
        this$0.send(new AuthenticateRequest(string, l, string2));
        return Unit.INSTANCE;
    }

    private static final void prepareAuthenticateOnNextSession$lambda$37(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit ping$lambda$38(FafLobbyClient this$0) {
        this$0.send(new ClientPingMessage());
        return Unit.INSTANCE;
    }

    private static final Unit handle$lambda$39(FafLobbyClient this$0, ServerMessage $message) {
        this$0.eventSink.emitNext((Object)$message, this$0.retrySerialFailure);
        return Unit.INSTANCE;
    }

    private static final Unit requestHostGame$lambda$40(FafLobbyClient this$0, String $mapName, String $title, String $mod, String $password, GameVisibility $visibility, Integer $ratingMin, Integer $ratingMax, boolean $enforceRatingRange) {
        this$0.send(new HostGameRequest($mapName, $title, $mod, new boolean[]{}, $password == null ? GameAccess.PUBLIC : GameAccess.PASSWORD, 0, $password, $visibility, $ratingMin, $ratingMax, $enforceRatingRange));
        return Unit.INSTANCE;
    }

    private static final Unit requestJoinGame$lambda$41(FafLobbyClient this$0, int $gameId, String $password) {
        this$0.send(new JoinGameRequest($gameId, $password));
        return Unit.INSTANCE;
    }

    private static final boolean requestJoinGame$lambda$42(int $gameId, ServerMessage event) {
        return event instanceof GameJoinFailed && $gameId == ((GameJoinFailed)event).getGameId() || event instanceof GameLaunchResponse && $gameId == ((GameLaunchResponse)event).getUid();
    }

    private static final boolean requestJoinGame$lambda$43(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Publisher requestJoinGame$lambda$44(int $gameId, ServerMessage event) {
        ServerMessage serverMessage = event;
        return (Publisher)(serverMessage instanceof GameJoinFailed ? Mono.error((Throwable)new GameJoinFailedException($gameId, ((GameJoinFailed)event).getReason())) : (serverMessage instanceof GameLaunchResponse ? Mono.just((Object)event) : Mono.empty()));
    }

    private static final Publisher requestJoinGame$lambda$45(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Unit getIceServers$lambda$46(FafLobbyClient this$0) {
        this$0.send(new IceServerListRequest());
        return Unit.INSTANCE;
    }

    private static final Iterable getIceServers$lambda$47(IceServerListResponse it) {
        return it.getIceServers();
    }

    private static final Iterable getIceServers$lambda$48(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Unit getAvailableAvatars$lambda$49(FafLobbyClient this$0) {
        this$0.send(new AvatarListRequest());
        return Unit.INSTANCE;
    }

    private static final Iterable getAvailableAvatars$lambda$50(AvatarListInfo it) {
        return it.getAvatarList();
    }

    private static final Iterable getAvailableAvatars$lambda$51(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Flux access$getOutboundMessages$p(FafLobbyClient $this) {
        return $this.outboundMessages;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(FafLobbyClient $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ Mono access$handle(FafLobbyClient $this, ServerMessage message) {
        return $this.handle(message);
    }

    public static final /* synthetic */ Disposable access$getPingDisposable$p(FafLobbyClient $this) {
        return $this.pingDisposable;
    }

    public static final /* synthetic */ void access$setPingDisposable$p(FafLobbyClient $this, Disposable disposable) {
        $this.pingDisposable = disposable;
    }

    public static final /* synthetic */ Mono access$pingWithDelay(FafLobbyClient $this) {
        return $this.pingWithDelay();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003J[\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u000bH\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/faforever/commons/lobby/FafLobbyClient$Config;", "", "token", "", "version", "userAgent", "url", "uidGenerator", "Ljava/util/function/Function;", "", "bufferSize", "", "wiretap", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Function;IZ)V", "getToken", "()Ljava/lang/String;", "getVersion", "getUserAgent", "getUrl", "getUidGenerator", "()Ljava/util/function/Function;", "getBufferSize", "()I", "getWiretap", "()Z", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "lobby"})
    public static final class Config {
        @NotNull
        private final String token;
        @NotNull
        private final String version;
        @NotNull
        private final String userAgent;
        @NotNull
        private final String url;
        @NotNull
        private final Function<Long, String> uidGenerator;
        private final int bufferSize;
        private final boolean wiretap;

        public Config(@NotNull String token, @NotNull String version, @NotNull String userAgent, @NotNull String url, @NotNull Function<Long, String> uidGenerator, int bufferSize, boolean wiretap) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(uidGenerator, (String)"uidGenerator");
            this.token = token;
            this.version = version;
            this.userAgent = userAgent;
            this.url = url;
            this.uidGenerator = uidGenerator;
            this.bufferSize = bufferSize;
            this.wiretap = wiretap;
        }

        public /* synthetic */ Config(String string, String string2, String string3, String string4, Function function, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            this(string, string2, string3, string4, function, n, bl);
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String getUserAgent() {
            return this.userAgent;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Function<Long, String> getUidGenerator() {
            return this.uidGenerator;
        }

        public final int getBufferSize() {
            return this.bufferSize;
        }

        public final boolean getWiretap() {
            return this.wiretap;
        }

        @NotNull
        public final String component1() {
            return this.token;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final String component3() {
            return this.userAgent;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        @NotNull
        public final Function<Long, String> component5() {
            return this.uidGenerator;
        }

        public final int component6() {
            return this.bufferSize;
        }

        public final boolean component7() {
            return this.wiretap;
        }

        @NotNull
        public final Config copy(@NotNull String token, @NotNull String version, @NotNull String userAgent, @NotNull String url, @NotNull Function<Long, String> uidGenerator, int bufferSize, boolean wiretap) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(uidGenerator, (String)"uidGenerator");
            return new Config(token, version, userAgent, url, uidGenerator, bufferSize, wiretap);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, String string2, String string3, String string4, Function function, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = config.token;
            }
            if ((n2 & 2) != 0) {
                string2 = config.version;
            }
            if ((n2 & 4) != 0) {
                string3 = config.userAgent;
            }
            if ((n2 & 8) != 0) {
                string4 = config.url;
            }
            if ((n2 & 0x10) != 0) {
                function = config.uidGenerator;
            }
            if ((n2 & 0x20) != 0) {
                n = config.bufferSize;
            }
            if ((n2 & 0x40) != 0) {
                bl = config.wiretap;
            }
            return config.copy(string, string2, string3, string4, function, n, bl);
        }

        @NotNull
        public String toString() {
            return "Config(token=" + this.token + ", version=" + this.version + ", userAgent=" + this.userAgent + ", url=" + this.url + ", uidGenerator=" + this.uidGenerator + ", bufferSize=" + this.bufferSize + ", wiretap=" + this.wiretap + ")";
        }

        public int hashCode() {
            int result = this.token.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + this.userAgent.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.uidGenerator.hashCode();
            result = result * 31 + Integer.hashCode(this.bufferSize);
            result = result * 31 + Boolean.hashCode(this.wiretap);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual((Object)this.token, (Object)config.token)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)config.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userAgent, (Object)config.userAgent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)config.url)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.uidGenerator, config.uidGenerator)) {
                return false;
            }
            if (this.bufferSize != config.bufferSize) {
                return false;
            }
            return this.wiretap == config.wiretap;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionStatus.values().length];
            try {
                nArray[ConnectionStatus.CONNECTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionStatus.CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionStatus.DISCONNECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

