/*
 * Decompiled with CFR 0.152.
 */
package com.falkonry.client.service;

import com.falkonry.client.service.HttpService;
import com.falkonry.helper.models.Assessment;
import com.falkonry.helper.models.AssessmentRequest;
import com.falkonry.helper.models.Datastream;
import com.falkonry.helper.models.EntityMeta;
import com.falkonry.helper.models.EntityMetaRequest;
import com.falkonry.helper.models.HttpResponseFormat;
import com.falkonry.helper.models.InputStatus;
import com.falkonry.helper.models.Tracker;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class FalkonryService {
    private HttpService httpService;

    public FalkonryService(String host, String token) throws Exception {
        this.httpService = new HttpService(host, token);
    }

    public Datastream createDatastream(Datastream datastream) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Datastream ds = new Datastream();
        ds.setName(datastream.getName());
        if (datastream.getDatasource() != null) {
            ds.setDatasource(datastream.getDatasource());
        }
        if (datastream.getField() != null) {
            ds.setField(datastream.getField());
        }
        if (datastream.getInputList() != null) {
            ds.setInputList(datastream.getInputList());
        }
        if (datastream.getTimePrecision() != null) {
            ds.setTimePrecision(datastream.getTimePrecision());
        }
        String datastream_json = this.httpService.post("/datastream", mapper.writeValueAsString((Object)ds));
        return (Datastream)mapper.readValue(datastream_json, Datastream.class);
    }

    public List<Datastream> getDatastreams() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String datastream_json = this.httpService.get("/datastream");
        return (List)mapper.readValue(datastream_json, (TypeReference)new TypeReference<List<Datastream>>(){});
    }

    public Datastream getDatastream(String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = "/datastream/" + id;
        String datastream_json = this.httpService.get(url);
        return (Datastream)mapper.readValue(datastream_json, Datastream.class);
    }

    public Datastream updateDatastream(Datastream datastream) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = "/datastream/" + datastream.getId();
        String datastream_json = this.httpService.put(url, mapper.writeValueAsString((Object)datastream));
        return (Datastream)mapper.readValue(datastream_json, Datastream.class);
    }

    public void deleteDatastream(String id) throws Exception {
        this.httpService.delete("/datastream/" + id);
    }

    public Assessment createAssessment(AssessmentRequest assessmentRequest) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        AssessmentRequest as = new AssessmentRequest();
        as.setName(assessmentRequest.getName());
        as.setAssessmentRate(assessmentRequest.getAssessmentRate());
        as.setDatastream(assessmentRequest.getDatastream());
        String assessment_json = this.httpService.post("/assessment", mapper.writeValueAsString((Object)as));
        return (Assessment)mapper.readValue(assessment_json, Assessment.class);
    }

    public List<Assessment> getAssessments() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String assessment_json = this.httpService.get("/assessment");
        return (List)mapper.readValue(assessment_json, (TypeReference)new TypeReference<List<Assessment>>(){});
    }

    public Assessment getAssessment(String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = "/assessment/" + id;
        String assessment_json = this.httpService.get(url);
        return (Assessment)mapper.readValue(assessment_json, Assessment.class);
    }

    public Assessment updateAssessment(Assessment assessment) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = "/assessment/" + assessment.getId();
        String assessment_json = this.httpService.put(url, mapper.writeValueAsString((Object)assessment));
        return (Assessment)mapper.readValue(assessment_json, Assessment.class);
    }

    public void deleteAssessment(String id) throws Exception {
        this.httpService.delete("/assessment/" + id);
    }

    public InputStatus addInputData(String id, String data, Map<String, String> options) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = this.getInputIngestionUrl(id, options);
        String status = this.httpService.postData(url, data);
        return (InputStatus)mapper.readValue(status, InputStatus.class);
    }

    public InputStatus addFacts(String id, String data, Map<String, String> options) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = this.getAddFactsUrl(id, options);
        String status = this.httpService.postData(url, data);
        return (InputStatus)mapper.readValue(status, InputStatus.class);
    }

    public InputStatus addInputFromStream(String id, ByteArrayInputStream stream, Map<String, String> options) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = this.getInputIngestionUrl(id, options);
        byte[] data_bytes = IOUtils.toByteArray((InputStream)stream);
        String status = this.httpService.upstream(url, data_bytes);
        return (InputStatus)mapper.readValue(status, InputStatus.class);
    }

    public InputStatus addFactsStream(String id, ByteArrayInputStream stream, Map<String, String> options) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = this.getAddFactsUrl(id, options);
        byte[] data_bytes = IOUtils.toByteArray((InputStream)stream);
        String status = this.httpService.upstream(url, data_bytes);
        return (InputStatus)mapper.readValue(status, InputStatus.class);
    }

    private String getAddFactsUrl(String assessmentId, Map<String, String> options) throws Exception {
        String url = "/assessment/" + assessmentId + "/facts?";
        Boolean firstReqParam = true;
        if (options.containsKey("startTimeIdentifier")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "startTimeIdentifier=" + URLEncoder.encode(options.get("startTimeIdentifier"), "UTF-8");
        }
        if (options.containsKey("endTimeIdentifier")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "endTimeIdentifier=" + URLEncoder.encode(options.get("endTimeIdentifier"), "UTF-8");
        }
        if (options.containsKey("timeFormat")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "timeFormat=" + URLEncoder.encode(options.get("timeFormat"), "UTF-8");
        }
        if (options.containsKey("timeZone")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "timeZone=" + URLEncoder.encode(options.get("timeZone"), "UTF-8");
        }
        if (options.containsKey("entityIdentifier")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "entityIdentifier=" + URLEncoder.encode(options.get("entityIdentifier"), "UTF-8");
        }
        if (options.containsKey("valueIdentifier")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "valueIdentifier=" + URLEncoder.encode(options.get("valueIdentifier"), "UTF-8");
        }
        if (options.containsKey("additionalKeyword")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "additionalKeyword=" + URLEncoder.encode(options.get("additionalKeyword"), "UTF-8");
        }
        if (options.containsKey("keywordIdentifier")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "keywordIdentifier=" + URLEncoder.encode(options.get("keywordIdentifier"), "UTF-8");
        }
        if (options.containsKey("batchIdentifier")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
            } else {
                url = url + "&";
            }
            url = url + "batchIdentifier=" + URLEncoder.encode(options.get("batchIdentifier"), "UTF-8");
        }
        return url;
    }

    private String getInputIngestionUrl(String datstreamId, Map<String, String> options) throws Exception {
        String url = "/datastream/" + datstreamId + "?";
        url = options.containsKey("streaming") ? url + "streaming=" + URLEncoder.encode(options.get("streaming"), "UTF-8") : url + "streaming=true";
        url = options.containsKey("hasMoreData") ? url + "&hasMoreData=" + URLEncoder.encode(options.get("hasMoreData"), "UTF-8") : url + "&hasMoreData=true";
        if (options.containsKey("timeFormat")) {
            url = url + "&timeFormat=" + URLEncoder.encode(options.get("timeFormat"), "UTF-8");
        }
        if (options.containsKey("timeZone")) {
            url = url + "&timeZone=" + URLEncoder.encode(options.get("timeZone"), "UTF-8");
        }
        if (options.containsKey("timeIdentifier")) {
            url = url + "&timeIdentifier=" + URLEncoder.encode(options.get("timeIdentifier"), "UTF-8");
        }
        if (options.containsKey("entityIdentifier")) {
            url = url + "&entityIdentifier=" + URLEncoder.encode(options.get("entityIdentifier"), "UTF-8");
        }
        if (options.containsKey("valueIdentifier")) {
            url = url + "&valueIdentifier=" + URLEncoder.encode(options.get("valueIdentifier"), "UTF-8");
        }
        if (options.containsKey("signalIdentifier")) {
            url = url + "&signalIdentifier=" + URLEncoder.encode(options.get("signalIdentifier"), "UTF-8");
        }
        if (options.containsKey("batchIdentifier")) {
            url = url + "&batchIdentifier=" + URLEncoder.encode(options.get("batchIdentifier"), "UTF-8");
        }
        return url;
    }

    public BufferedReader getOutput(String id) throws Exception {
        String url = "/assessment/" + id + "/output";
        return this.httpService.downstream(url);
    }

    public List<Assessment> onDatastream(String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = "/datastream/" + id + "/on";
        String assessment_json = this.httpService.post(url, "");
        return (List)mapper.readValue(assessment_json, (TypeReference)new TypeReference<List<Assessment>>(){});
    }

    public List<Assessment> offDatastream(String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String url = "/datastream/" + id + "/off";
        String assessment_json = this.httpService.post(url, "");
        return (List)mapper.readValue(assessment_json, (TypeReference)new TypeReference<List<Assessment>>(){});
    }

    public HttpResponseFormat getHistoricalOutput(Assessment assessment, Map<String, String> options) throws Exception {
        String format;
        String url = "/assessment/" + assessment.getId() + "/output?";
        Boolean firstReqParam = true;
        if (options.containsKey("trackerId")) {
            firstReqParam = false;
            url = url + "trackerId=" + URLEncoder.encode(options.get("trackerId"), "UTF-8");
        }
        if (options.containsKey("modelIndex")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
                url = url + "model=" + URLEncoder.encode(options.get("modelIndex"), "UTF-8");
            } else {
                url = url + "&model=" + URLEncoder.encode(options.get("modelIndex"), "UTF-8");
            }
        }
        if (options.containsKey("startTime")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
                url = url + "startTime=" + URLEncoder.encode(options.get("startTime"), "UTF-8");
            } else {
                url = url + "&startTime=" + URLEncoder.encode(options.get("startTime"), "UTF-8");
            }
        }
        if (options.containsKey("endTime")) {
            url = firstReqParam != false ? url + "endTime=" + URLEncoder.encode(options.get("endTime"), "UTF-8") : url + "&endTime=" + URLEncoder.encode(options.get("endTime"), "UTF-8");
        }
        String responseFormat = "application/json";
        if (options.containsKey("responseFormat") && (format = options.get("responseFormat")).equals("text/csv")) {
            responseFormat = format;
        }
        HttpResponseFormat outputData = this.httpService.getOutput(url, responseFormat);
        return outputData;
    }

    public List<EntityMeta> postEntityMeta(List<EntityMetaRequest> entityMetaRequest, String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String entityMetaRequest_json = this.httpService.post("/datastream/" + id + "/entityMeta", mapper.writeValueAsString(entityMetaRequest));
        return (List)mapper.readValue(entityMetaRequest_json, (TypeReference)new TypeReference<List<EntityMeta>>(){});
    }

    public List<EntityMeta> getEntityMeta(String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String entityMeta_json = this.httpService.get("/datastream/" + id + "/entityMeta");
        return (List)mapper.readValue(entityMeta_json, (TypeReference)new TypeReference<List<EntityMeta>>(){});
    }

    public HttpResponseFormat getFactsData(String assessment, Map<String, String> options) throws Exception {
        String format;
        String url = "/assessment/" + assessment + "/facts?";
        Boolean firstReqParam = true;
        if (options.containsKey("modelIndex")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
                url = url + "model=" + URLEncoder.encode(options.get("modelIndex"), "UTF-8");
            } else {
                url = url + "&model=" + URLEncoder.encode(options.get("modelIndex"), "UTF-8");
            }
        }
        if (options.containsKey("startTime")) {
            if (firstReqParam.booleanValue()) {
                firstReqParam = false;
                url = url + "startTime=" + URLEncoder.encode(options.get("startTime"), "UTF-8");
            } else {
                url = url + "&startTime=" + URLEncoder.encode(options.get("startTime"), "UTF-8");
            }
        }
        if (options.containsKey("endTime")) {
            url = firstReqParam != false ? url + "endTime=" + URLEncoder.encode(options.get("endTime"), "UTF-8") : url + "&endTime=" + URLEncoder.encode(options.get("endTime"), "UTF-8");
        }
        String responseFormat = "application/json";
        if (options.containsKey("responseFormat") && (format = options.get("responseFormat")).equals("text/csv")) {
            responseFormat = format;
        }
        HttpResponseFormat factsData = this.httpService.getOutput(url, responseFormat);
        return factsData;
    }

    public HttpResponseFormat getInputData(String datastream, Map<String, String> options) throws Exception {
        String format;
        String url = "/datastream/" + datastream + "/data";
        String responseFormat = "application/json";
        if (options.containsKey("responseFormat") && (format = options.get("responseFormat")).equals("text/csv")) {
            responseFormat = format;
        }
        HttpResponseFormat factsData = this.httpService.getOutput(url, responseFormat);
        return factsData;
    }

    public Tracker getStatus(String id) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String entityMeta_json = this.httpService.get("/app/track/" + id);
        return (Tracker)mapper.readValue(entityMeta_json, (TypeReference)new TypeReference<Tracker>(){});
    }
}

