/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class BukkitPermissionAttachmentManager {
    private final WorldEditPlugin plugin;
    private final Map<Player, PermissionAttachment> attachments = new ConcurrentHashMap<Player, PermissionAttachment>();
    private PermissionAttachment noopAttachment;

    public BukkitPermissionAttachmentManager(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    public PermissionAttachment getOrAddAttachment(@Nullable Player p) {
        if (p == null) {
            return null;
        }
        if (p.hasMetadata("NPC")) {
            if (this.noopAttachment == null) {
                this.noopAttachment = new PermissionAttachment((Plugin)this.plugin, (Permissible)new PermissibleBase(null));
            }
            return this.noopAttachment;
        }
        return this.attachments.computeIfAbsent(p, k -> k.addAttachment((Plugin)this.plugin));
    }

    public void removeAttachment(@Nullable Player p) {
        if (p == null) {
            return;
        }
        PermissionAttachment attach = this.attachments.remove(p);
        if (attach != null) {
            attach.remove();
        }
    }
}

