/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.QueueHandler;
import com.fastasyncworldedit.core.queue.implementation.blocks.CharGetBlocks;
import com.fastasyncworldedit.core.util.MemUtil;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBukkitGetBlocks<ServerLevel, LevelChunk>
extends CharGetBlocks {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected final ServerLevel serverLevel;
    protected final int chunkX;
    protected final int chunkZ;
    protected final ReentrantLock callLock = new ReentrantLock();
    protected final ConcurrentHashMap<Integer, IChunkGet> copies = new ConcurrentHashMap();
    protected final IntPair chunkPos;
    protected final int minHeight;
    protected final int maxHeight;
    protected boolean createCopy = false;
    protected boolean forceLoadSections = true;
    protected int copyKey = 0;

    protected AbstractBukkitGetBlocks(ServerLevel serverLevel, int chunkX, int chunkZ, int minY, int maxY) {
        super(minY >> 4, maxY >> 4);
        this.serverLevel = serverLevel;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.minHeight = minY;
        this.maxHeight = maxY;
        this.chunkPos = new IntPair(chunkX, chunkZ);
    }

    protected abstract void send();

    protected abstract CompletableFuture<LevelChunk> ensureLoaded(ServerLevel var1);

    protected abstract <T extends Future<T>> T internalCall(IChunkSet var1, Runnable var2, int var3, LevelChunk var4, ServerLevel var5) throws Exception;

    public synchronized <T extends Future<T>> T call(IQueueExtent<? extends IChunk> owner, IChunkSet set, Runnable finalizer) {
        if (!this.callLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Attempted to call chunk GET but chunk was not call-locked.");
        }
        this.forceLoadSections = false;
        ServerLevel nmsWorld = this.serverLevel;
        CompletableFuture<LevelChunk> nmsChunkFuture = this.ensureLoaded(nmsWorld);
        LevelChunk chunk = nmsChunkFuture.getNow(null);
        if (chunk == null && MemUtil.shouldBeginSlow() || Settings.settings().QUEUE.ASYNC_CHUNK_LOAD_WRITE) {
            try {
                chunk = nmsChunkFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Could not get chunk at {},{} whilst low memory", (Object)this.chunkX, (Object)this.chunkZ, (Object)e);
                throw new FaweException((Component)TextComponent.of((String)("Could not get chunk at " + this.chunkX + "," + this.chunkZ + " whilst low memory: " + e.getMessage())));
            }
        }
        int finalCopyKey = this.copyKey;
        if (chunk != null) {
            return this.tryWrappedInternalCall(set, finalizer, finalCopyKey, chunk, nmsWorld);
        }
        nmsChunkFuture.thenApply(nmsChunk -> owner.submitTaskUnchecked(() -> this.tryWrappedInternalCall(set, finalizer, finalCopyKey, nmsChunk, nmsWorld)));
        return (T)CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Future<T>> T tryWrappedInternalCall(IChunkSet set, Runnable finalizer, int copyKey, LevelChunk nmsChunk, ServerLevel nmsWorld) {
        try {
            T t = this.internalCall(set, finalizer, copyKey, nmsChunk, nmsWorld);
            return t;
        }
        catch (Throwable e) {
            LOGGER.error("Error performing chunk call at chunk {},{}", (Object)this.chunkX, (Object)this.chunkZ, (Object)e);
            T t = null;
            return t;
        }
        finally {
            this.forceLoadSections = true;
        }
    }

    protected <T extends Future<T>> T handleCallFinalizer(Runnable[] syncTasks, Runnable callback, Runnable finalizer) throws Exception {
        if (syncTasks != null) {
            QueueHandler queueHandler = Fawe.instance().getQueueHandler();
            Runnable[] finalSyncTasks = syncTasks;
            Callable<Future> chain = () -> {
                try {
                    for (Runnable task : finalSyncTasks) {
                        if (task == null) continue;
                        task.run();
                    }
                    if (callback != null) {
                        return queueHandler.async(callback, null);
                    }
                    if (finalizer != null) {
                        return queueHandler.async(finalizer, null);
                    }
                    return null;
                }
                catch (Throwable e) {
                    LOGGER.error("Error performing final chunk calling at {},{}", (Object)this.chunkX, (Object)this.chunkZ, (Object)e);
                    throw e;
                }
            };
            return (T)queueHandler.sync(chain);
        }
        if (callback != null) {
            callback.run();
        } else if (finalizer != null) {
            finalizer.run();
        }
        return null;
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public boolean isCreateCopy() {
        return this.createCopy;
    }

    public int setCreateCopy(boolean createCopy) {
        if (!this.callLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Attempting to set if chunk GET should create copy, but it is not call-locked.");
        }
        this.createCopy = createCopy;
        return ++this.copyKey;
    }

    public IChunkGet getCopy(int key) {
        return this.copies.remove(key);
    }

    public void lockCall() {
        this.callLock.lock();
    }

    public void unlockCall() {
        this.callLock.unlock();
    }

    public int getMaxY() {
        return this.maxHeight;
    }

    public int getMinY() {
        return this.minHeight;
    }
}

