/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Regenerator {
    protected final World originalBukkitWorld;
    protected final Region region;
    protected final Extent target;
    protected final RegenOptions options;
    protected long seed;
    protected SingleThreadQueueExtent source;

    public Regenerator(World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        this.originalBukkitWorld = originalBukkitWorld;
        this.region = region;
        this.target = target;
        this.options = options;
    }

    public boolean regenerate() throws Exception {
        if (!this.prepare()) {
            return false;
        }
        try {
            if (!this.initNewWorld()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            this.copyToWorld();
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        this.cleanup0();
        return true;
    }

    protected abstract void runTasks(BooleanSupplier var1);

    private void createSource() {
        this.source = new SingleThreadQueueExtent(BukkitWorld.HAS_MIN_Y ? this.originalBukkitWorld.getMinHeight() : 0, BukkitWorld.HAS_MIN_Y ? this.originalBukkitWorld.getMaxHeight() : 256);
        this.source.init(this.target, this.initSourceQueueCache(), null);
    }

    private void copyToWorld() {
        this.createSource();
        long timeoutPerTick = TimeUnit.MILLISECONDS.toNanos(10L);
        int taskId = TaskManager.taskManager().repeat(() -> {
            long startTime = System.nanoTime();
            this.runTasks(() -> System.nanoTime() - startTime < timeoutPerTick);
        }, 1);
        boolean genbiomes = this.options.shouldRegenBiomes();
        boolean hasBiome = this.options.hasBiomeType();
        BiomeType biome = this.options.getBiomeType();
        ChunkwisePattern pattern = !genbiomes && !hasBiome ? new PlacementPattern() : (hasBiome ? new WithBiomePlacementPattern((ignored1, ignored2) -> biome) : new WithBiomePlacementPattern((vec, chunk) -> {
            if (chunk != null) {
                return chunk.getBiomeType(vec.x() & 0xF, vec.y(), vec.z() & 0xF);
            }
            return this.source.getBiome(vec);
        }));
        this.target.setBlocks(this.region, (Pattern)pattern);
        TaskManager.taskManager().cancel(taskId);
    }

    private void cleanup0() {
        this.cleanup();
    }

    protected abstract boolean prepare();

    protected abstract boolean initNewWorld() throws Exception;

    protected abstract void cleanup();

    protected abstract IChunkCache<IChunkGet> initSourceQueueCache();

    protected BiomeProvider getBiomeProvider() {
        if (this.options.hasBiomeType()) {
            return new SingleBiomeProvider();
        }
        return this.originalBukkitWorld.getBiomeProvider();
    }

    private class PlacementPattern
    extends ChunkwisePattern {
        private PlacementPattern() {
        }

        public BaseBlock applyBlock(BlockVector3 position) {
            return Regenerator.this.source.getFullBlock(position);
        }

        public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
            BaseBlock fullBlock = this.chunk != null ? this.chunk.getFullBlock(get.x() & 0xF, get.y(), get.z() & 0xF) : Regenerator.this.source.getFullBlock(get.x(), get.y(), get.z());
            return set.setFullBlock(extent, fullBlock);
        }

        @Override
        public Pattern fork() {
            return new PlacementPattern();
        }
    }

    private class WithBiomePlacementPattern
    extends ChunkwisePattern {
        private final BiFunction<BlockVector3, @Nullable IChunk, BiomeType> biomeGetter;

        private WithBiomePlacementPattern(BiFunction<BlockVector3, IChunk, BiomeType> biomeGetter) {
            this.biomeGetter = biomeGetter;
        }

        public BaseBlock applyBlock(BlockVector3 position) {
            return Regenerator.this.source.getFullBlock(position);
        }

        public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
            BaseBlock fullBlock = this.chunk != null ? this.chunk.getFullBlock(get.x() & 0xF, get.y(), get.z() & 0xF) : Regenerator.this.source.getFullBlock(get.x(), get.y(), get.z());
            return extent.setBlock(set.x(), set.y(), set.z(), (BlockStateHolder)fullBlock) && extent.setBiome(set.x(), set.y(), set.z(), this.biomeGetter.apply(get, this.chunk));
        }

        @Override
        public Pattern fork() {
            return new WithBiomePlacementPattern(this.biomeGetter);
        }
    }

    public class SingleBiomeProvider
    extends BiomeProvider {
        private final Biome biome;

        public SingleBiomeProvider() {
            this.biome = BukkitAdapter.adapt(Regenerator.this.options.getBiomeType());
        }

        public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
            return this.biome;
        }

        public List<Biome> getBiomes(WorldInfo worldInfo) {
            return Collections.singletonList(this.biome);
        }
    }

    public static enum Concurrency {
        FULL,
        RADIUS,
        NONE;

    }

    private abstract class ChunkwisePattern
    implements Pattern {
        @Nullable
        protected IChunk chunk;

        private ChunkwisePattern() {
        }

        @NotNull
        public <T extends IChunk> T applyChunk(T chunk, @Nullable Region region) {
            this.chunk = Regenerator.this.source.getOrCreateChunk(chunk.getX(), chunk.getZ());
            return chunk;
        }

        public void finishChunk(IChunk chunk) {
            this.chunk = null;
        }

        public abstract Pattern fork();
    }
}

