/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.listener;

import com.fastasyncworldedit.bukkit.FaweBukkit;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.util.FaweTimer;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@Deprecated(since="2.0.0")
public abstract class ChunkListener
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected int rateLimit = 0;
    protected Location lastCancelPos;
    private final int[] badLimit;
    @Deprecated(since="2.0.0")
    public static boolean physicsFreeze = false;
    @Deprecated(since="2.0.0")
    public static boolean itemFreeze = false;
    protected final Long2ObjectOpenHashMap<Boolean> badChunks;
    private final Long2ObjectOpenHashMap<int[]> counter;
    private int lastX;
    private int lastZ;
    private int[] lastCount;
    protected int physSkip;
    protected boolean physCancel;
    protected long physCancelPair;
    protected long physStart;
    protected long physTick;

    public ChunkListener() {
        this.badLimit = new int[]{Settings.settings().TICK_LIMITER.PHYSICS_MS, Settings.settings().TICK_LIMITER.FALLING, Settings.settings().TICK_LIMITER.ITEMS};
        this.badChunks = new Long2ObjectOpenHashMap();
        this.counter = new Long2ObjectOpenHashMap();
        this.lastX = Integer.MIN_VALUE;
        this.lastZ = Integer.MIN_VALUE;
        if (Settings.settings().TICK_LIMITER.ENABLED) {
            PluginManager plm = Bukkit.getPluginManager();
            Plugin plugin = ((FaweBukkit)Fawe.platform()).getPlugin();
            plm.registerEvents((Listener)this, plugin);
            TaskManager.taskManager().repeat(() -> {
                Location tmpLoc = this.lastCancelPos;
                if (tmpLoc != null) {
                    LOGGER.info("[FAWE Tick Limiter] Detected and cancelled physics lag source at {}", (Object)tmpLoc);
                }
                --this.rateLimit;
                physicsFreeze = false;
                itemFreeze = false;
                this.lastZ = Integer.MIN_VALUE;
                this.physSkip = 0;
                this.physCancelPair = Long.MIN_VALUE;
                this.physCancel = false;
                this.lastCancelPos = null;
                this.counter.clear();
                for (Long2ObjectMap.Entry entry : this.badChunks.long2ObjectEntrySet()) {
                    long key = entry.getLongKey();
                    int x = MathMan.unpairIntX((long)key);
                    int z = MathMan.unpairIntY((long)key);
                    this.counter.put(key, (Object)this.badLimit);
                }
                this.badChunks.clear();
            }, Settings.settings().TICK_LIMITER.INTERVAL);
        }
    }

    protected abstract int getDepth(Exception var1);

    protected abstract StackTraceElement getElement(Exception var1, int var2);

    @Deprecated(since="2.0.0")
    public int[] getCount(int cx, int cz) {
        if (this.lastX == cx && this.lastZ == cz) {
            return this.lastCount;
        }
        this.lastX = cx;
        this.lastZ = cz;
        long pair = MathMan.pairInt((int)cx, (int)cz);
        this.lastCount = (int[])this.counter.get(pair);
        int[] tmp = this.lastCount;
        if (tmp == null) {
            tmp = new int[3];
            this.lastCount = tmp;
            this.counter.put(pair, (Object)tmp);
        }
        return tmp;
    }

    @Deprecated(since="2.0.0")
    public void cleanup(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != EntityType.ITEM) continue;
            entity.remove();
        }
    }

    @Deprecated(since="2.0.0")
    public final void reset() {
        this.physSkip = 0;
        this.physStart = System.currentTimeMillis();
        this.physCancel = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockExplodeEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockBurnEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockCanBuildEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockDamageEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockDispenseEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockExpEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockFadeEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockFromToEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockGrowEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockIgniteEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockPlaceEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(FurnaceBurnEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(FurnaceSmeltEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(LeavesDecayEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(NotePlayEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(SignChangeEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockRedstoneEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent event) {
        Exception e;
        int depth;
        if (physicsFreeze) {
            event.setCancelled(true);
            return;
        }
        if (this.physCancel) {
            Block block = event.getBlock();
            long pair = MathMan.pairInt((int)(block.getX() >> 4), (int)(block.getZ() >> 4));
            if (this.physCancelPair == pair) {
                event.setCancelled(true);
                return;
            }
            if (this.badChunks.containsKey(pair)) {
                this.physCancelPair = pair;
                event.setCancelled(true);
                return;
            }
        } else {
            if ((++this.physSkip & 0x3FF) != 0) {
                return;
            }
            FaweTimer timer = Fawe.instance().getTimer();
            if (timer.getTick() != this.physTick) {
                this.physTick = timer.getTick();
                this.physStart = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.physStart < (long)Settings.settings().TICK_LIMITER.PHYSICS_MS) {
                return;
            }
        }
        if ((depth = this.getDepth(e = new Exception())) >= 256 && this.containsSetAir(e, event)) {
            Block block = event.getBlock();
            int cx = block.getX() >> 4;
            int cz = block.getZ() >> 4;
            this.physCancelPair = MathMan.pairInt((int)cx, (int)cz);
            if (this.rateLimit <= 0) {
                this.rateLimit = 20;
                this.lastCancelPos = block.getLocation();
            }
            this.cancelNearby(cx, cz);
            event.setCancelled(true);
            this.physCancel = true;
            return;
        }
        this.physSkip = 1;
        this.physCancel = false;
    }

    protected boolean containsSetAir(Exception e, BlockPhysicsEvent event) {
        for (int frame = 25; frame < 35; ++frame) {
            String methodName;
            StackTraceElement elem = this.getElement(e, frame);
            if (elem == null || ((methodName = elem.getMethodName()).charAt(0) != 's' || methodName.length() != 6) && methodName.length() != 14) continue;
            return true;
        }
        return false;
    }

    protected void cancelNearby(int cx, int cz) {
        this.cancel(cx, cz);
        this.cancel(cx + 1, cz);
        this.cancel(cx - 1, cz);
        this.cancel(cx, cz + 1);
        this.cancel(cx, cz - 1);
        this.cancel(cx - 1, cz - 1);
        this.cancel(cx - 1, cz + 1);
        this.cancel(cx + 1, cz - 1);
        this.cancel(cx + 1, cz + 1);
    }

    private void cancel(int cx, int cz) {
        long key = MathMan.pairInt((int)cx, (int)cz);
        this.badChunks.put(key, (Object)true);
        this.counter.put(key, (Object)this.badLimit);
        int[] count = this.getCount(cx, cz);
        count[0] = Integer.MAX_VALUE;
        count[1] = Integer.MAX_VALUE;
        count[2] = Integer.MAX_VALUE;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockChange(EntityChangeBlockEvent event) {
        int z;
        int cz;
        if (physicsFreeze) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        int x = block.getX();
        int cx = x >> 4;
        int[] count = this.getCount(cx, cz = (z = block.getZ()) >> 4);
        if (count[1] >= Settings.settings().TICK_LIMITER.FALLING) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntityType() == EntityType.FALLING_BLOCK && (count[1] = count[1] + 1) >= Settings.settings().TICK_LIMITER.FALLING) {
            if (Fawe.instance().getTimer().getTPS() < 18.0) {
                this.cancelNearby(cx, cz);
                if (this.rateLimit <= 0) {
                    this.rateLimit = 20;
                    this.lastCancelPos = block.getLocation();
                }
                event.setCancelled(true);
            } else {
                count[1] = 0;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        int cz;
        if (physicsFreeze) {
            event.setCancelled(true);
            return;
        }
        Location loc = event.getLocation();
        int cx = loc.getBlockX() >> 4;
        int[] count = this.getCount(cx, cz = loc.getBlockZ() >> 4);
        if (count[2] >= Settings.settings().TICK_LIMITER.ITEMS) {
            event.setCancelled(true);
            return;
        }
        count[2] = count[2] + 1;
        if (count[2] >= Settings.settings().TICK_LIMITER.ITEMS) {
            this.cleanup(loc.getChunk());
            this.cancelNearby(cx, cz);
            if (this.rateLimit <= 0) {
                this.rateLimit = 20;
                LOGGER.warn("[FAWE `tick-limiter`] Detected and cancelled item lag source at {}", (Object)loc);
            }
            event.setCancelled(true);
        }
    }
}

