/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions.plotsquared;

import com.fastasyncworldedit.core.util.TaskManager;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.biome.Biomes;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;

@CommandDeclaration(command="generatebiome", permission="plots.generatebiome", category=CommandCategory.APPEARANCE, requiredType=RequiredType.PLAYER, description="Generate a biome in your plot", aliases={"bg", "gb"}, usage="/plots generatebiome <biome>")
public class PlotSetBiome
extends Command {
    public PlotSetBiome() {
        super((Command)MainCommand.getInstance(), true);
    }

    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        Plot plot = (Plot)this.check(player.getCurrentPlot(), (Caption)TranslatableCaption.of((String)"errors.not_in_plot"), new TagResolver[0]);
        this.checkTrue(plot.isOwner(player.getUUID()) || player.hasPermission("plots.admin.command.generatebiome"), (Caption)TranslatableCaption.of((String)"permission.no_plot_perms"), new TagResolver[0]);
        if (plot.getRunning() != 0) {
            player.sendMessage((Caption)TranslatableCaption.of((String)"errors.wait_for_timer"), new TagResolver[0]);
            return null;
        }
        this.checkTrue(args.length == 1, (Caption)TranslatableCaption.of((String)"commandconfig.command_syntax"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)this.getUsage())))});
        Set regions = plot.getRegions();
        BiomeRegistry biomeRegistry = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
        Collection knownBiomes = BiomeTypes.values();
        BiomeType biome = Biomes.findBiomeByName((Collection)knownBiomes, (String)args[0], (BiomeRegistry)biomeRegistry);
        if (biome == null) {
            String biomes = StringMan.join((Collection)BiomeType.REGISTRY.values(), (String)TranslatableCaption.of((String)"blocklist.block_list_separator").getComponent(player));
            player.sendMessage((Caption)TranslatableCaption.of((String)"biome.need_biome"), new TagResolver[0]);
            player.sendMessage((Caption)TranslatableCaption.of((String)"commandconfig.subcommand_set_options_header"), new TagResolver[]{TagResolver.resolver((String)"value", (Tag)Tag.inserting((Component)Component.text((String)biomes)))});
            return CompletableFuture.completedFuture(false);
        }
        confirm.run((Object)this, () -> {
            if (plot.getRunning() != 0) {
                player.sendMessage((Caption)TranslatableCaption.of((String)"errors.wait_for_timer"), new TagResolver[0]);
                return;
            }
            plot.addRunning();
            TaskManager.taskManager().async(() -> {
                EditSession session = WorldEdit.getInstance().newEditSessionBuilder().world(BukkitAdapter.adapt(Bukkit.getWorld((String)plot.getArea().getWorldName()))).checkMemory(Boolean.valueOf(false)).allowedRegionsEverywhere().actor((Actor)BukkitAdapter.adapt(Bukkit.getPlayer((UUID)player.getUUID()))).limitUnlimited().build();
                long seed = ThreadLocalRandom.current().nextLong();
                for (CuboidRegion region : regions) {
                    session.regenerate((Region)region, biome, Long.valueOf(seed));
                }
                session.flushQueue();
                plot.removeRunning();
            });
        }, null);
        return CompletableFuture.completedFuture(true);
    }

    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return SuggestionHelper.getNamespacedRegistrySuggestions((NamespacedRegistry)BiomeType.REGISTRY, (String)args[0]).map(value -> value.toLowerCase(Locale.ENGLISH).replace("minecraft:", "")).filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(this, null, false, (String)value, "", RequiredType.PLAYER, null){}).collect(Collectors.toList());
    }
}

