/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.fastasyncworldedit.bukkit.FaweBukkit;
import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.apache.logging.log4j.Logger;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ResidenceFeature
extends BukkitMaskManager
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final FaweBukkit plugin;
    private final Plugin residence;

    public ResidenceFeature(Plugin residencePlugin, FaweBukkit p3) {
        super(residencePlugin.getName());
        this.residence = residencePlugin;
        this.plugin = p3;
        LOGGER.info("Plugin 'Residence' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, ClaimedResidence residence, FaweMaskManager.MaskType type) {
        return residence != null && (residence.getOwner().equals(player.getName()) || residence.getOwner().equals(player.getUniqueId().toString()) || type == FaweMaskManager.MaskType.MEMBER && (Boolean)TaskManager.taskManager().sync(() -> residence.getPermissions().playerHas(player, "build", false)) != false);
    }

    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type, boolean isWhitelist) {
        org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        Location location = player.getLocation();
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByLoc(location);
        if (residence != null) {
            boolean isAllowed;
            while (!(isAllowed = this.isAllowed(player, residence, type)) && residence != null) {
                residence = residence.getSubzoneByLoc(location);
            }
            if (isAllowed) {
                CuboidArea area = residence.getAreaArray()[0];
                Location pos1 = area.getLowLoc();
                Location pos2 = area.getHighLoc();
                final ClaimedResidence finalResidence = residence;
                return new FaweMask((Region)new CuboidRegion(BukkitAdapter.asBlockVector(pos1), BukkitAdapter.asBlockVector(pos2))){

                    public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                        return ResidenceFeature.this.isAllowed(BukkitAdapter.adapt(player), finalResidence, type);
                    }
                };
            }
        }
        return null;
    }
}

