/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.util;

import com.fastasyncworldedit.core.util.TaskManager;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitTaskManager
extends TaskManager {
    private final Plugin plugin;

    public BukkitTaskManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public int repeat(@Nonnull Runnable runnable, int interval) {
        return this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask(this.plugin, runnable, (long)interval, (long)interval);
    }

    public int repeatAsync(@Nonnull Runnable runnable, int interval) {
        return this.plugin.getServer().getScheduler().scheduleAsyncRepeatingTask(this.plugin, runnable, (long)interval, (long)interval);
    }

    public void async(@Nonnull Runnable runnable) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, runnable).getTaskId();
    }

    public void task(@Nonnull Runnable runnable) {
        this.plugin.getServer().getScheduler().runTask(this.plugin, runnable).getTaskId();
    }

    public void later(@Nonnull Runnable runnable, int delay) {
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, runnable, (long)delay).getTaskId();
    }

    public void laterAsync(@Nonnull Runnable runnable, int delay) {
        this.plugin.getServer().getScheduler().runTaskLaterAsynchronously(this.plugin, runnable, (long)delay);
    }

    public void cancel(int task) {
        if (task != -1) {
            Bukkit.getScheduler().cancelTask(task);
        }
    }
}

