/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.fastasyncworldedit.bukkit.adapter.IBukkitAdapter;
import com.fastasyncworldedit.bukkit.adapter.SimpleBukkitAdapter;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitBlockCommandSender;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.PlayerProxy;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.item.ItemType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public enum BukkitAdapter {
    INSTANCE;

    private final IBukkitAdapter adapter;
    private static final ParserContext TO_BLOCK_CONTEXT;
    private static final EnumMap<Material, BlockType> materialBlockTypeCache;
    private static final EnumMap<Material, ItemType> materialItemTypeCache;
    private static final Int2ObjectMap<BlockState> blockStateCache;
    private static final Map<String, BlockState> blockStateStringCache;
    private static final Int2ObjectMap<BlockData> blockDataCache;

    private BukkitAdapter() {
        BukkitImplAdapter tmp = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        this.adapter = Objects.requireNonNullElseGet(tmp, SimpleBukkitAdapter::new);
    }

    private static IBukkitAdapter getAdapter() {
        return BukkitAdapter.INSTANCE.adapter;
    }

    public static boolean equals(BlockType blockType, Material type) {
        return BukkitAdapter.getAdapter().equals(blockType, type);
    }

    public static BukkitWorld asBukkitWorld(World world) {
        return BukkitAdapter.getAdapter().asBukkitWorld(world);
    }

    public static World adapt(org.bukkit.World world) {
        return BukkitAdapter.getAdapter().adapt(world);
    }

    public static Actor adapt(CommandSender sender) {
        return WorldEditPlugin.getInstance().wrapCommandSender(sender);
    }

    public static BukkitPlayer adapt(org.bukkit.entity.Player player) {
        return WorldEditPlugin.getInstance().wrapPlayer(player);
    }

    public static CommandSender adapt(Actor actor) {
        if (actor instanceof Player) {
            return BukkitAdapter.adapt((Player)actor);
        }
        if (actor instanceof BukkitBlockCommandSender) {
            return ((BukkitBlockCommandSender)actor).getSender();
        }
        return ((BukkitCommandSender)actor).getSender();
    }

    public static org.bukkit.entity.Player adapt(Player player) {
        return (player = PlayerProxy.unwrap((Player)player)) == null ? null : ((BukkitPlayer)player).getPlayer();
    }

    public static Direction adapt(@Nullable BlockFace face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.EAST;
            }
            case DOWN: {
                return Direction.DOWN;
            }
        }
        return Direction.UP;
    }

    public static org.bukkit.World adapt(World world) {
        return BukkitAdapter.getAdapter().adapt(world);
    }

    public static com.sk89q.worldedit.util.Location adapt(Location location) {
        Preconditions.checkNotNull((Object)location);
        Vector3 position = BukkitAdapter.asVector(location);
        return new com.sk89q.worldedit.util.Location((Extent)BukkitAdapter.adapt(location.getWorld()), position, location.getYaw(), location.getPitch());
    }

    public static Location adapt(com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)location);
        com.sk89q.worldedit.util.Location position = location;
        return new Location(BukkitAdapter.adapt((World)location.getExtent()), position.getX(), position.getY(), position.getZ(), location.getYaw(), location.getPitch());
    }

    public static Location adapt(org.bukkit.World world, Vector3 position) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        return new Location(world, position.getX(), position.getY(), position.getZ());
    }

    public static Location adapt(org.bukkit.World world, BlockVector3 position) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        return new Location(world, (double)position.getX(), (double)position.getY(), (double)position.getZ());
    }

    public static Location adapt(org.bukkit.World world, com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)location);
        return new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Vector3 asVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return Vector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static BlockVector3 asBlockVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static Entity adapt(org.bukkit.entity.Entity entity) {
        return BukkitAdapter.getAdapter().adapt(entity);
    }

    public static Material adapt(ItemType itemType) {
        return BukkitAdapter.getAdapter().adapt(itemType);
    }

    public static Material adapt(BlockType blockType) {
        return BukkitAdapter.getAdapter().adapt(blockType);
    }

    public static GameMode adapt(org.bukkit.GameMode gameMode) {
        return BukkitAdapter.getAdapter().adapt(gameMode);
    }

    public static BiomeType adapt(Biome biome) {
        return BukkitAdapter.getAdapter().adapt(biome);
    }

    public static Biome adapt(BiomeType biomeType) {
        return BukkitAdapter.getAdapter().adapt(biomeType);
    }

    public static com.sk89q.worldedit.world.entity.EntityType adapt(EntityType entityType) {
        return BukkitAdapter.getAdapter().adapt(entityType);
    }

    public static EntityType adapt(com.sk89q.worldedit.world.entity.EntityType entityType) {
        return BukkitAdapter.getAdapter().adapt(entityType);
    }

    @Nullable
    public static BlockType asBlockType(Material material) {
        return BukkitAdapter.getAdapter().asBlockType(material);
    }

    @Nullable
    public static ItemType asItemType(Material material) {
        return BukkitAdapter.getAdapter().asItemType(material);
    }

    public static BlockState adapt(@Nonnull BlockData blockData) {
        return BukkitAdapter.getAdapter().adapt(blockData);
    }

    public static BlockData adapt(@Nonnull BlockStateHolder block) {
        return BukkitAdapter.getAdapter().adapt(block);
    }

    public static BlockState asBlockState(ItemStack itemStack) throws WorldEditException {
        return BukkitAdapter.getAdapter().asBlockState(itemStack);
    }

    public static BaseItemStack adapt(ItemStack itemStack) {
        return BukkitAdapter.getAdapter().adapt(itemStack);
    }

    public static ItemStack adapt(BaseItemStack item) {
        return BukkitAdapter.getAdapter().adapt(item);
    }

    static {
        TO_BLOCK_CONTEXT = new ParserContext();
        TO_BLOCK_CONTEXT.setRestricted(false);
        materialBlockTypeCache = new EnumMap(Material.class);
        materialItemTypeCache = new EnumMap(Material.class);
        blockStateCache = new Int2ObjectOpenHashMap();
        blockStateStringCache = new HashMap<String, BlockState>();
        blockDataCache = new Int2ObjectOpenHashMap();
    }
}

