/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.fastasyncworldedit.core.util.UpdateNotification;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.SessionIdleEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.event.InteractionDebouncer;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Identifiable;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import java.util.Optional;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.InjectedValueStore;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;

public class WorldEditListener
implements Listener {
    private final WorldEditPlugin plugin;
    private final InteractionDebouncer debouncer;

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
        this.debouncer = new InteractionDebouncer((Platform)plugin.getInternalPlatform());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGamemode(PlayerGameModeChangeEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalSession session = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)player);
        if (session == null) {
            session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player);
        }
        session.loadDefaults((Actor)player, true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        LocalSession session;
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        if (player.getPlayer() != event.getPlayer()) {
            player = this.plugin.reCachePlayer(event.getPlayer());
        }
        if ((session = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)player)) != null) {
            session.loadDefaults((Actor)player, true);
        }
        UpdateNotification.doUpdateNotification((Actor)player);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        MapBackedValueStore store = MapBackedValueStore.create();
        store.injectValue(Key.of(Actor.class), context -> Optional.of(this.plugin.wrapCommandSender((CommandSender)event.getPlayer())));
        CommandManager commandManager = this.plugin.getWorldEdit().getPlatformManager().getPlatformCommandManager().getCommandManager();
        event.getCommands().removeIf(arg_0 -> WorldEditListener.lambda$onPlayerCommandSend$2(commandManager, (InjectedValueStore)store, arg_0));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Optional previousResult;
        if (!this.plugin.getInternalPlatform().isHookingEvents() || event.useItemInHand() == Event.Result.DENY || event.getHand() == EquipmentSlot.OFF_HAND || event.getAction() == Action.PHYSICAL) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && (previousResult = this.debouncer.getDuplicateInteractionResult((Identifiable)player)).isPresent()) {
            if (((Boolean)previousResult.get()).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        World world = player.getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        Direction direction = BukkitAdapter.adapt(event.getBlockFace());
        Block clickedBlock = event.getClickedBlock();
        Location pos = clickedBlock == null ? null : new Location((Extent)world, (double)clickedBlock.getX(), (double)clickedBlock.getY(), (double)clickedBlock.getZ());
        boolean result = false;
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: {
                result = we.handleBlockLeftClick((Player)player, pos, direction) || we.handleArmSwing((Player)player);
                break;
            }
            case LEFT_CLICK_AIR: {
                result = we.handleArmSwing((Player)player);
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                result = we.handleBlockRightClick((Player)player, pos, direction) || we.handleRightClick((Player)player);
                break;
            }
            case RIGHT_CLICK_AIR: {
                result = we.handleRightClick((Player)player);
                break;
            }
        }
        this.debouncer.setLastInteraction((Identifiable)player, result);
        if (result) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.debouncer.clearInteraction((Identifiable)this.plugin.wrapPlayer(event.getPlayer()));
        this.plugin.getWorldEdit().getEventBus().post((Object)new SessionIdleEvent((SessionKey)new BukkitPlayer.SessionKeyImpl(event.getPlayer())));
    }

    private static /* synthetic */ boolean lambda$onPlayerCommandSend$2(CommandManager commandManager, InjectedValueStore store, String name) {
        return commandManager.getCommand(name).filter(command -> !command.getCondition().satisfied((InjectedValueAccess)store)).isPresent();
    }
}

