/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.ErrorConsts;
import com.fasterxml.aalto.IoStreamException;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WNameFactory;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.util.CharsetNames;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public abstract class XmlWriter
extends WNameFactory {
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR1_LAST = 56319;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    protected static final int MIN_ARRAYCOPY = 12;
    protected static final int ATTR_MIN_ARRAYCOPY = 12;
    protected static final int DEFAULT_COPYBUFFER_LEN = 512;
    final WriterConfig _config;
    char[] mCopyBuffer;
    protected boolean mXml11 = false;
    protected final boolean mCfgNsAware;
    protected int mLocPastChars = 0;
    protected int mLocRowNr = 1;
    protected int mLocRowStartOffset = 0;
    protected final boolean mCheckContent;
    protected final boolean mCheckNames;

    protected XmlWriter(WriterConfig cfg) {
        this._config = cfg;
        this.mCopyBuffer = cfg.allocMediumCBuffer(512);
        this.mCfgNsAware = cfg.isNamespaceAware();
        this.mCheckContent = cfg.willCheckContent();
        this.mCheckNames = cfg.willCheckNames();
    }

    @Override
    public abstract WName constructName(String var1) throws XMLStreamException;

    @Override
    public abstract WName constructName(String var1, String var2) throws XMLStreamException;

    public void enableXml11() {
        this.mXml11 = true;
    }

    protected abstract int getOutputPtr();

    public abstract int getHighestEncodable();

    public final void close(boolean forceTargetClose) throws IOException {
        this.flush();
        this._releaseBuffers();
        this._closeTarget(forceTargetClose || this._config.willAutoCloseOutput());
    }

    public void _releaseBuffers() {
        char[] buf = this.mCopyBuffer;
        if (buf != null) {
            this.mCopyBuffer = null;
            this._config.freeMediumCBuffer(buf);
        }
    }

    public abstract void _closeTarget(boolean var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract int writeCData(String var1) throws IOException, XMLStreamException;

    public abstract int writeCData(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeCharacters(String var1) throws IOException, XMLStreamException;

    public abstract void writeCharacters(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeSpace(String var1) throws IOException, XMLStreamException;

    public abstract void writeSpace(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract int writeComment(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(WName var1, String var2, String var3, String var4) throws IOException, XMLStreamException;

    public abstract void writeEntityReference(WName var1) throws IOException, XMLStreamException;

    public abstract int writePI(WName var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeXmlDeclaration(String var1, String var2, String var3) throws IOException, XMLStreamException;

    public abstract void writeStartTagStart(WName var1) throws IOException, XMLStreamException;

    public abstract void writeStartTagEnd() throws IOException, XMLStreamException;

    public abstract void writeStartTagEmptyEnd() throws IOException, XMLStreamException;

    public abstract void writeEndTag(WName var1) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    public abstract void writeTypedValue(AsciiValueEncoder var1) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, AsciiValueEncoder var2) throws IOException, XMLStreamException;

    public int getRow() {
        return this.mLocRowNr;
    }

    public int getColumn() {
        return this.getOutputPtr() - this.mLocRowStartOffset + 1;
    }

    public int getAbsOffset() {
        return this.mLocPastChars + this.getOutputPtr();
    }

    public static final int guessEncodingBitSize(WriterConfig cfg) {
        String enc = cfg.getPreferredEncoding();
        if (enc == null || enc.length() == 0) {
            return 16;
        }
        if ((enc = CharsetNames.normalize(enc)) == "UTF-8") {
            return 16;
        }
        if (enc == "ISO-8859-1") {
            return 8;
        }
        if (enc == "US-ASCII") {
            return 7;
        }
        if (enc == "UTF-16" || enc == "UTF-16BE" || enc == "UTF-16LE" || enc == "UTF-32BE" || enc == "UTF-32LE") {
            return 16;
        }
        return 8;
    }

    protected void reportNwfName(String msg) throws XMLStreamException {
        this.throwOutputError(msg);
    }

    protected void reportNwfName(String msg, Object arg) throws XMLStreamException {
        this.throwOutputError(msg, arg);
    }

    protected void reportNwfContent(String msg) throws XMLStreamException {
        this.throwOutputError(msg);
    }

    protected void reportNwfContent(String format, Object arg1, Object arg2) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg1, arg2);
        this.reportNwfContent(msg);
    }

    protected void reportFailedEscaping(String type, int ch) throws XMLStreamException {
        if (ch == 65534 || ch == 65535 || ch >= 55296 && ch <= 57343) {
            this.reportInvalidChar(ch);
        }
        if (!(ch >= 32 || ch != 0 && this._config.isXml11())) {
            this.reportInvalidChar(ch);
        }
        String msg = MessageFormat.format(ErrorConsts.WERR_NO_ESCAPING, type, new Integer(ch));
        this.reportNwfContent(msg);
    }

    protected void reportInvalidEmptyName() throws XMLStreamException {
        this.reportNwfContent("Empty String is not a valid name (local name, prefix or processing instruction target)");
    }

    protected void reportInvalidChar(int c) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        if (c == 0) {
            this.reportNwfContent("Invalid null character in text to output");
        }
        if (c < 32 || c >= 127 && c <= 159) {
            String msg = "Invalid white space character (0x" + Integer.toHexString(c) + ") in text to output";
            if (this.mXml11) {
                msg = msg + " (can only be output using character entity)";
            }
            this.reportNwfContent(msg);
        }
        if (c > 0x10FFFF) {
            this.reportNwfContent("Illegal unicode character point (0x" + Integer.toHexString(c) + ") to output; max is 0x10FFFF as per RFC 3629");
        }
        if (c >= 55296 && c <= 57343) {
            this.reportNwfContent("Illegal surrogate pair -- can only be output via character entities (for current encoding), which are not allowed in this content");
        }
        this.reportNwfContent("Invalid XML character " + XmlChars.getCharDesc(c) + " in text to output");
    }

    protected void throwOutputError(String msg) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        throw new XMLStreamException(msg);
    }

    protected void throwOutputError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        this.throwOutputError(msg);
    }
}

