/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.EntityNames;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.CharsetNames;
import com.fasterxml.aalto.util.DataUtil;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class AsyncByteScanner
extends ByteBasedScanner {
    private static final int EVENT_INCOMPLETE = 257;
    static final int STATE_DEFAULT = 0;
    static final int STATE_PROLOG_INITIAL = 1;
    static final int STATE_PROLOG_SEEN_LT = 2;
    static final int STATE_PROLOG_DECL = 3;
    static final int STATE_TREE_SEEN_LT = 1;
    static final int STATE_TREE_SEEN_AMP = 2;
    static final int STATE_TREE_SEEN_EXCL = 3;
    static final int STATE_TREE_SEEN_SLASH = 4;
    static final int STATE_TREE_NUMERIC_ENTITY_START = 5;
    static final int STATE_TREE_NAMED_ENTITY_START = 6;
    private static final int STATE_XMLDECL_AFTER_XML = 1;
    private static final int STATE_XMLDECL_BEFORE_VERSION = 2;
    private static final int STATE_XMLDECL_VERSION = 3;
    private static final int STATE_XMLDECL_AFTER_VERSION = 4;
    private static final int STATE_XMLDECL_VERSION_EQ = 5;
    private static final int STATE_XMLDECL_VERSION_VALUE = 6;
    private static final int STATE_XMLDECL_AFTER_VERSION_VALUE = 7;
    private static final int STATE_XMLDECL_BEFORE_ENCODING = 8;
    private static final int STATE_XMLDECL_ENCODING = 9;
    private static final int STATE_XMLDECL_AFTER_ENCODING = 10;
    private static final int STATE_XMLDECL_ENCODING_EQ = 11;
    private static final int STATE_XMLDECL_ENCODING_VALUE = 12;
    private static final int STATE_XMLDECL_AFTER_ENCODING_VALUE = 13;
    private static final int STATE_XMLDECL_BEFORE_STANDALONE = 14;
    private static final int STATE_XMLDECL_STANDALONE = 15;
    private static final int STATE_XMLDECL_AFTER_STANDALONE = 16;
    private static final int STATE_XMLDECL_STANDALONE_EQ = 17;
    private static final int STATE_XMLDECL_STANDALONE_VALUE = 18;
    private static final int STATE_XMLDECL_AFTER_STANDALONE_VALUE = 19;
    private static final int STATE_XMLDECL_ENDQ = 20;
    private static final int STATE_DTD_DOCTYPE = 1;
    private static final int STATE_DTD_AFTER_DOCTYPE = 2;
    private static final int STATE_DTD_BEFORE_ROOT_NAME = 3;
    private static final int STATE_DTD_ROOT_NAME = 4;
    private static final int STATE_DTD_AFTER_ROOT_NAME = 5;
    private static final int STATE_DTD_BEFORE_IDS = 6;
    private static final int STATE_DTD_PUBLIC_OR_SYSTEM = 7;
    private static final int STATE_DTD_AFTER_PUBLIC = 8;
    private static final int STATE_DTD_AFTER_SYSTEM = 9;
    private static final int STATE_DTD_BEFORE_PUBLIC_ID = 10;
    private static final int STATE_DTD_PUBLIC_ID = 11;
    private static final int STATE_DTD_AFTER_PUBLIC_ID = 12;
    private static final int STATE_DTD_BEFORE_SYSTEM_ID = 13;
    private static final int STATE_DTD_SYSTEM_ID = 14;
    private static final int STATE_DTD_AFTER_SYSTEM_ID = 15;
    private static final int STATE_DTD_INT_SUBSET = 16;
    private static final int STATE_DTD_EXPECT_CLOSING_GT = 50;
    static final int STATE_TEXT_AMP = 4;
    static final int STATE_TEXT_AMP_NAME = 6;
    static final int STATE_COMMENT_CONTENT = 1;
    static final int STATE_COMMENT_HYPHEN = 2;
    static final int STATE_COMMENT_HYPHEN2 = 3;
    static final int STATE_CDATA_CONTENT = 1;
    static final int STATE_CDATA_C = 2;
    static final int STATE_CDATA_CD = 3;
    static final int STATE_CDATA_CDA = 4;
    static final int STATE_CDATA_CDAT = 5;
    static final int STATE_CDATA_CDATA = 6;
    static final int STATE_PI_AFTER_TARGET = 1;
    static final int STATE_PI_AFTER_TARGET_WS = 2;
    static final int STATE_PI_AFTER_TARGET_QMARK = 3;
    static final int STATE_PI_IN_TARGET = 4;
    static final int STATE_PI_IN_DATA = 5;
    static final int STATE_SE_ELEM_NAME = 1;
    static final int STATE_SE_SPACE_OR_END = 2;
    static final int STATE_SE_SPACE_OR_ATTRNAME = 3;
    static final int STATE_SE_ATTR_NAME = 4;
    static final int STATE_SE_SPACE_OR_EQ = 5;
    static final int STATE_SE_SPACE_OR_ATTRVALUE = 6;
    static final int STATE_SE_ATTR_VALUE_NORMAL = 7;
    static final int STATE_SE_ATTR_VALUE_NSDECL = 8;
    static final int STATE_SE_SEEN_SLASH = 9;
    static final int STATE_EE_NEED_GT = 1;
    static final int PENDING_STATE_CR = -1;
    private static final int PENDING_STATE_XMLDECL_LT = -5;
    private static final int PENDING_STATE_XMLDECL_LTQ = -6;
    private static final int PENDING_STATE_XMLDECL_TARGET = -7;
    static final int PENDING_STATE_PI_QMARK = -15;
    static final int PENDING_STATE_COMMENT_HYPHEN1 = -20;
    static final int PENDING_STATE_COMMENT_HYPHEN2 = -21;
    static final int PENDING_STATE_CDATA_BRACKET1 = -30;
    static final int PENDING_STATE_CDATA_BRACKET2 = -31;
    static final int PENDING_STATE_ENT_SEEN_HASH = -70;
    static final int PENDING_STATE_ENT_SEEN_HASH_X = -71;
    static final int PENDING_STATE_ENT_IN_DEC_DIGIT = -72;
    static final int PENDING_STATE_ENT_IN_HEX_DIGIT = -73;
    protected byte[] _inputBuffer;
    protected int _origBufferLen;
    protected int _nextEvent = 257;
    protected int _state = 1;
    protected int _surroundingEvent = 257;
    protected int _pendingInput = 0;
    protected boolean _endOfInput = false;
    protected int _quadCount;
    protected int _currQuad;
    protected int _currQuadBytes = 0;
    protected int _entityValue = 0;
    protected boolean _elemAllNsBound;
    protected boolean _elemAttrCount;
    protected byte _elemAttrQuote;
    protected PName _elemAttrName;
    protected int _elemAttrPtr;
    protected int _elemNsPtr;

    public AsyncByteScanner(ReaderConfig cfg) {
        super(cfg);
    }

    public String toString() {
        return "asyncScanner; curr=" + this._currToken + " next=" + this._nextEvent + ", state = " + this._state;
    }

    protected abstract int parseCommentContents() throws XMLStreamException;

    protected abstract int parseCDataContents() throws XMLStreamException;

    protected abstract int parsePIData() throws XMLStreamException;

    protected abstract int startCharactersPending() throws XMLStreamException;

    protected abstract int finishCharactersCoalescing() throws XMLStreamException;

    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    public void feedInput(byte[] buf, int start, int len) throws XMLStreamException {
        if (this._inputPtr < this._inputEnd) {
            throw new XMLStreamException("Still have " + (this._inputEnd - this._inputPtr) + " unread bytes");
        }
        if (this._endOfInput) {
            throw new XMLStreamException("Already closed, can not feed more input");
        }
        this._pastBytes += this._origBufferLen;
        this._rowStartOffset -= this._origBufferLen;
        this._inputBuffer = buf;
        this._inputPtr = start;
        this._inputEnd = start + len;
        this._origBufferLen = len;
    }

    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    protected void _closeSource() throws IOException {
        this._endOfInput = true;
    }

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        if (this._currToken != 257) {
            if (this._currToken == 7) {
                this._currToken = 257;
                if (this._tokenName != null) {
                    this._nextEvent = 3;
                    this._state = 1;
                    this.checkPITargetName(this._tokenName);
                    return this.handlePI();
                }
            } else {
                this._nextEvent = 257;
                this._currToken = 257;
                this._state = 0;
            }
        }
        if (this._nextEvent == 257) {
            byte b;
            if (this._state == 1) {
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if (this._pendingInput != 0) {
                    Boolean b2 = this.startXmlDeclaration();
                    if (b2 == null) {
                        return 257;
                    }
                    if (b2 == Boolean.FALSE) {
                        this._currToken = 7;
                        return 7;
                    }
                    return this.handleXmlDeclaration();
                }
                if (this._inputBuffer[this._inputPtr] == 60) {
                    ++this._inputPtr;
                    this._pendingInput = -5;
                    Boolean b3 = this.startXmlDeclaration();
                    if (b3 == null) {
                        return 257;
                    }
                    if (b3 == Boolean.FALSE) {
                        this._currToken = 7;
                        return 7;
                    }
                    return this.handleXmlDeclaration();
                }
                this._state = 0;
                this._currToken = 7;
                return 7;
            }
            if (this._pendingInput != 0 && !this.handlePartialCR()) {
                return this._currToken;
            }
            while (this._state == 0) {
                if (this._inputPtr >= this._inputEnd) {
                    if (this._endOfInput) {
                        return -1;
                    }
                    return this._currToken;
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == 60) {
                    this._state = 2;
                    break;
                }
                if (b == 32 || b == 13 || b == 10 || b == 9) {
                    if (this.asyncSkipSpace()) continue;
                    if (this._endOfInput) {
                        return -1;
                    }
                    return this._currToken;
                }
                this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), null);
            }
            if (this._state == 2) {
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == 33) {
                    this._state = 3;
                    return this.handlePrologDeclStart(isProlog);
                }
                if (b == 63) {
                    this._nextEvent = 3;
                    this._state = 0;
                    return this.handlePI();
                }
                if (b == 47 || !isProlog) {
                    this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (unbalanced start/end tags?)");
                }
                return this.handleStartElementStart(b);
            }
            if (this._state == 3) {
                return this.handlePrologDeclStart(isProlog);
            }
            return this.throwInternal();
        }
        switch (this._nextEvent) {
            case 1: {
                return this.handleStartElement();
            }
            case 7: {
                return this.handleXmlDeclaration();
            }
            case 3: {
                return this.handlePI();
            }
            case 5: {
                return this.handleComment();
            }
            case 11: {
                return this.handleDTD();
            }
        }
        return this.throwInternal();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int nextFromTree() throws XMLStreamException {
        block39: {
            block40: {
                byte b;
                block38: {
                    if (this._currToken != 257) {
                        if (this._currToken == 1) {
                            if (this._isEmptyTag) {
                                --this._depth;
                                this._currToken = 2;
                                return 2;
                            }
                        } else if (this._currToken == 2) {
                            this._currElem = this._currElem.getParent();
                            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                                this._lastNsDecl = this._lastNsDecl.unbind();
                            }
                        }
                        if (this._tokenIncomplete) {
                            if (!this.skipCharacters()) {
                                return 257;
                            }
                            this._tokenIncomplete = false;
                        }
                        this._nextEvent = 257;
                        this._currToken = 257;
                        this._state = 0;
                    }
                    if (this._nextEvent != 257) break block39;
                    if (this._state == 0) {
                        if (this._pendingInput != 0) {
                            this._nextEvent = 4;
                            return this.startCharactersPending();
                        }
                        if (this._inputPtr >= this._inputEnd) {
                            return this._currToken;
                        }
                        if ((b = this._inputBuffer[this._inputPtr++]) == 60) {
                            this._state = 1;
                        } else {
                            if (b != 38) {
                                this._nextEvent = 4;
                                return this.startCharacters(b);
                            }
                            this._state = 2;
                        }
                    }
                    if (this._inputPtr >= this._inputEnd) {
                        return this._currToken;
                    }
                    if (this._state == 1) {
                        if ((b = this._inputBuffer[this._inputPtr++]) == 33) {
                            this._state = 3;
                            break block38;
                        } else {
                            if (b == 63) {
                                this._nextEvent = 3;
                                this._state = 0;
                                return this.handlePI();
                            }
                            if (b != 47) return this.handleStartElementStart(b);
                            return this.handleEndElementStart();
                        }
                    }
                    if (this._state == 2) {
                        return this.handleEntityStartingToken();
                    }
                    if (this._state == 6) {
                        return this.handleNamedEntityStartingToken();
                    }
                    if (this._state == 5) {
                        return this.handleNumericEntityStartingToken();
                    }
                }
                if (this._state != 3) break block40;
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
                    this._nextEvent = 5;
                    this._state = 0;
                    break block39;
                } else if (b == 91) {
                    this._nextEvent = 12;
                    this._state = 0;
                    break block39;
                } else {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
                }
                break block39;
            }
            this.throwInternal();
        }
        switch (this._nextEvent) {
            case 1: {
                return this.handleStartElement();
            }
            case 2: {
                return this.handleEndElement();
            }
            case 3: {
                return this.handlePI();
            }
            case 5: {
                return this.handleComment();
            }
            case 12: {
                return this.handleCData();
            }
            case 4: {
                if (!this._cfgLazyParsing && this._cfgCoalescing) {
                    return this.finishCharactersCoalescing();
                }
                if (this._pendingInput != 0) {
                    return this.startCharactersPending();
                }
                this.throwInternal();
                return this.throwInternal();
            }
        }
        return this.throwInternal();
    }

    private final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
            this._nextEvent = 5;
            this._state = 0;
            return this.handleComment();
        }
        if (b == 68) {
            this._nextEvent = 11;
            this._state = 0;
            return this.handleDTD();
        }
        this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (expected '-' for COMMENT)");
        return 257;
    }

    private final Boolean startXmlDeclaration() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return null;
        }
        if (this._pendingInput == -5) {
            if (this._inputBuffer[this._inputPtr] != 63) {
                this._pendingInput = 0;
                this._state = 2;
                return Boolean.FALSE;
            }
            ++this._inputPtr;
            this._pendingInput = -6;
            if (this._inputPtr >= this._inputEnd) {
                return null;
            }
        }
        if (this._pendingInput == -6) {
            byte b = this._inputBuffer[this._inputPtr++];
            this._tokenName = this.parseNewName(b);
            if (this._tokenName == null) {
                this._pendingInput = -7;
                return null;
            }
            if (!"xml".equals(this._tokenName.getPrefixedName())) {
                this._pendingInput = 0;
                this._state = 1;
                this._nextEvent = 3;
                this.checkPITargetName(this._tokenName);
                return Boolean.FALSE;
            }
        } else if (this._pendingInput == -7) {
            this._tokenName = this.parsePName();
            if (this._tokenName == null) {
                return null;
            }
            if (!"xml".equals(this._tokenName.getPrefixedName())) {
                this._pendingInput = 0;
                this._state = 1;
                this._nextEvent = 3;
                this.checkPITargetName(this._tokenName);
                return Boolean.FALSE;
            }
        } else {
            this.throwInternal();
        }
        this._pendingInput = 0;
        this._nextEvent = 7;
        this._state = 1;
        return Boolean.TRUE;
    }

    private int handleXmlDeclaration() throws XMLStreamException {
        if (this._pendingInput == -1 && !this.handlePartialCR()) {
            return 257;
        }
        block22: while (this._inputPtr < this._inputEnd) {
            switch (this._state) {
                case 1: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 2;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after 'xml' in xml declaration)");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 2: {
                    if (!this.asyncSkipSpace()) continue block22;
                    if ((this._tokenName = this.parseNewName(this._inputBuffer[this._inputPtr++])) == null) {
                        this._state = 3;
                        continue block22;
                    }
                    if (!this._tokenName.hasPrefixedName("version")) {
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'version'");
                    }
                    this._state = 4;
                    continue block22;
                }
                case 3: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) continue block22;
                    if (!this._tokenName.hasPrefixedName("version")) {
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'version'");
                    }
                    this._state = 4;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 4: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block22;
                    if ((b = this._inputBuffer[this._inputPtr++]) != 61) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected '=' after 'version' in xml declaration)");
                    }
                    this._state = 5;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 5: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._elemAttrQuote = this._inputBuffer[this._inputPtr++];
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' in xml declaration for version value)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseXmlDeclAttr(buf, 0)) {
                        this._state = 6;
                        continue block22;
                    }
                    this.verifyAndSetXmlVersion();
                    this._state = 7;
                    continue block22;
                }
                case 6: {
                    if (!this.parseXmlDeclAttr(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) {
                        this._state = 6;
                        continue block22;
                    }
                    this.verifyAndSetXmlVersion();
                    this._state = 7;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 7: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 8;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after version value in xml declaration)");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 8: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block22;
                    if ((b = this._inputBuffer[this._inputPtr++]) == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    this._tokenName = this.parseNewName(b);
                    if (this._tokenName == null) {
                        this._state = 9;
                        continue block22;
                    }
                    if (this._tokenName.hasPrefixedName("encoding")) {
                        this._state = 10;
                        continue block22;
                    }
                    if (this._tokenName.hasPrefixedName("standalone")) {
                        this._state = 16;
                        continue block22;
                    }
                    this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'encoding'");
                    continue block22;
                }
                case 9: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) continue block22;
                    if (this._tokenName.hasPrefixedName("encoding")) {
                        this._state = 10;
                    } else {
                        if (this._tokenName.hasPrefixedName("standalone")) {
                            this._state = 16;
                            continue block22;
                        }
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'encoding'");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 10: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block22;
                    if ((b = this._inputBuffer[this._inputPtr++]) != 61) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected '=' after 'encoding' in xml declaration)");
                    }
                    this._state = 11;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 11: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._elemAttrQuote = this._inputBuffer[this._inputPtr++];
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' in xml declaration for encoding value)");
                    }
                    this._state = 12;
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseXmlDeclAttr(buf, 0)) {
                        this._state = 12;
                        continue block22;
                    }
                    this.verifyAndSetXmlEncoding();
                    this._state = 13;
                    continue block22;
                }
                case 12: {
                    if (!this.parseXmlDeclAttr(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) {
                        this._state = 12;
                        continue block22;
                    }
                    this.verifyAndSetXmlEncoding();
                    this._state = 13;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 13: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 14;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after encoding value in xml declaration)");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 14: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block22;
                    if ((b = this._inputBuffer[this._inputPtr++]) == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    this._tokenName = this.parseNewName(b);
                    if (this._tokenName == null) {
                        this._state = 15;
                        continue block22;
                    }
                    if (!this._tokenName.hasPrefixedName("standalone")) {
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'standalone'");
                    }
                    this._state = 16;
                    continue block22;
                }
                case 15: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) continue block22;
                    if (!this._tokenName.hasPrefixedName("standalone")) {
                        this.reportInputProblem("Unexpected keyword 'encoding' in XML declaration: expected 'standalone'");
                    }
                    this._state = 16;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 16: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block22;
                    if ((b = this._inputBuffer[this._inputPtr++]) != 61) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected '=' after 'standalone' in xml declaration)");
                    }
                    this._state = 17;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 17: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._elemAttrQuote = this._inputBuffer[this._inputPtr++];
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' in xml declaration for standalone value)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseXmlDeclAttr(buf, 0)) {
                        this._state = 18;
                        continue block22;
                    }
                    this.verifyAndSetXmlStandalone();
                    this._state = 19;
                    continue block22;
                }
                case 18: {
                    if (!this.parseXmlDeclAttr(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) {
                        this._state = 18;
                        continue block22;
                    }
                    this.verifyAndSetXmlStandalone();
                    this._state = 19;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 19: {
                    if (!this.asyncSkipSpace()) continue block22;
                    if (this._inputBuffer[this._inputPtr++] != 63) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._inputBuffer[this._inputPtr - 1]), " (expected '?>' to end xml declaration)");
                    }
                    this._state = 20;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 20: {
                    this._tokenName = null;
                    this._state = 0;
                    this._nextEvent = 257;
                    if (this._inputBuffer[this._inputPtr++] != 62) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._inputBuffer[this._inputPtr - 1]), " (expected '>' to end xml declaration)");
                    }
                    return 7;
                }
            }
            this.throwInternal();
        }
        return 257;
    }

    private int handleDTD() throws XMLStreamException {
        if (this._pendingInput == -1 && !this.handlePartialCR()) {
            return 257;
        }
        if (this._state == 16) {
            if (this.handleDTDInternalSubset(false)) {
                this._state = 50;
            } else {
                return 257;
            }
        }
        block19: while (this._inputPtr < this._inputEnd) {
            switch (this._state) {
                case 0: {
                    this._tokenName = this.parseNewName((byte)68);
                    if (this._tokenName == null) {
                        this._state = 1;
                        return 257;
                    }
                    if (!"DOCTYPE".equals(this._tokenName.getPrefixedName())) {
                        this.reportPrologProblem(true, "expected 'DOCTYPE'");
                    }
                    this._state = 2;
                    continue block19;
                }
                case 1: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) {
                        this._state = 1;
                        return 257;
                    }
                    if (!"DOCTYPE".equals(this._tokenName.getPrefixedName())) {
                        this.reportPrologProblem(true, "expected 'DOCTYPE'");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 2: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 3;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after 'DOCTYPE')");
                    }
                }
                case 3: {
                    if (!this.asyncSkipSpace()) continue block19;
                    if ((this._tokenName = this.parseNewName(this._inputBuffer[this._inputPtr++])) == null) {
                        this._state = 4;
                        continue block19;
                    }
                    this._state = 4;
                    continue block19;
                }
                case 4: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) continue block19;
                    this._state = 5;
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 5: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 62) {
                        this._state = 0;
                        this._nextEvent = 257;
                        return 11;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 6;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after root name in DOCTYPE declaration)");
                    }
                }
                case 6: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block19;
                    if ((b = this._inputBuffer[this._inputPtr++]) == 62) {
                        this._state = 0;
                        this._nextEvent = 257;
                        return 11;
                    }
                    PName name = this.parseNewName(b);
                    if (name == null) {
                        this._state = 7;
                        continue block19;
                    }
                    String str = name.getPrefixedName();
                    if ("PUBLIC".equals(str)) {
                        this._state = 8;
                        continue block19;
                    }
                    if ("SYSTEM".equals(str)) {
                        this._state = 9;
                        continue block19;
                    }
                    this.reportPrologProblem(true, "unexpected token '" + str + "': expected either PUBLIC or SYSTEM");
                    continue block19;
                }
                case 7: {
                    PName name = this.parsePName();
                    if (name == null) {
                        this._state = 7;
                        continue block19;
                    }
                    String str = name.getPrefixedName();
                    if ("PUBLIC".equals(str)) {
                        this._state = 8;
                        continue block19;
                    }
                    if ("SYSTEM".equals(str)) {
                        this._state = 9;
                        continue block19;
                    }
                    this.reportPrologProblem(true, "unexpected token '" + str + "': expected either PUBLIC or SYSTEM");
                    continue block19;
                }
                case 8: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 10;
                        continue block19;
                    }
                    this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after PUBLIC keyword)");
                    continue block19;
                }
                case 9: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 13;
                        continue block19;
                    }
                    this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after SYSTEM keyword)");
                    continue block19;
                }
                case 10: {
                    if (!this.asyncSkipSpace()) continue block19;
                    this._elemAttrQuote = this._inputBuffer[this._inputPtr++];
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' for PUBLIC ID)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseDtdId(buf, 0)) {
                        this._state = 11;
                        continue block19;
                    }
                    this.verifyAndSetPublicId();
                    this._state = 12;
                    continue block19;
                }
                case 11: {
                    if (!this.parseDtdId(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) continue block19;
                    this.verifyAndSetPublicId();
                    this._state = 12;
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 12: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 13;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after PUBLIC ID)");
                    }
                }
                case 13: {
                    if (!this.asyncSkipSpace()) continue block19;
                    this._elemAttrQuote = this._inputBuffer[this._inputPtr++];
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' for SYSTEM ID)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseDtdId(buf, 0)) {
                        this._state = 14;
                        continue block19;
                    }
                    this.verifyAndSetSystemId();
                    this._state = 15;
                    continue block19;
                }
                case 14: {
                    if (!this.parseDtdId(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) continue block19;
                    this.verifyAndSetSystemId();
                    this._state = 15;
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 15: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block19;
                    if ((b = this._inputBuffer[this._inputPtr++]) == 62) {
                        this._state = 0;
                        this._nextEvent = 257;
                        return 11;
                    }
                    if (b != 91) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected either '[' for internal subset, or '>' to end DOCTYPE)");
                    }
                    this._state = 16;
                    if (this.handleDTDInternalSubset(true)) {
                        this._state = 50;
                    } else {
                        return 257;
                    }
                }
                case 50: {
                    byte b;
                    if (!this.asyncSkipSpace()) continue block19;
                    if ((b = this._inputBuffer[this._inputPtr++]) != 62) {
                        this.reportPrologUnexpChar(true, b, "expected '>' to end DTD");
                    }
                    this._state = 0;
                    this._nextEvent = 257;
                    return 11;
                }
            }
            this.throwInternal();
        }
        return this._currToken;
    }

    protected abstract boolean handleDTDInternalSubset(boolean var1) throws XMLStreamException;

    private final boolean parseDtdId(char[] buffer, int ptr) throws XMLStreamException {
        byte quote = this._elemAttrQuote;
        while (this._inputPtr < this._inputEnd) {
            int ch;
            if ((ch = this._inputBuffer[this._inputPtr++] & 0xFF) == quote) {
                this._textBuilder.setCurrentLength(ptr);
                return true;
            }
            if (ch <= 32 || ch > 126) {
                this.reportPrologUnexpChar(true, this.decodeCharForError((byte)ch), " (not valid in PUBLIC or SYSTEM ID)");
            }
            if (ptr >= buffer.length) {
                buffer = this._textBuilder.finishCurrentSegment();
                ptr = 0;
            }
            buffer[ptr++] = (char)ch;
        }
        this._textBuilder.setCurrentLength(ptr);
        return false;
    }

    private boolean parseXmlDeclAttr(char[] buffer, int ptr) throws XMLStreamException {
        byte quote = this._elemAttrQuote;
        while (this._inputPtr < this._inputEnd) {
            int ch;
            if ((ch = this._inputBuffer[this._inputPtr++] & 0xFF) == quote) {
                this._textBuilder.setCurrentLength(ptr);
                return true;
            }
            if (ch <= 32 || ch > 122) {
                this.reportPrologUnexpChar(true, this.decodeCharForError((byte)ch), " (not valid in XML pseudo-attribute values)");
            }
            if (ptr >= buffer.length) {
                buffer = this._textBuilder.finishCurrentSegment();
                ptr = 0;
            }
            buffer[ptr++] = (char)ch;
        }
        this._textBuilder.setCurrentLength(ptr);
        return false;
    }

    private final void verifyAndSetXmlVersion() throws XMLStreamException {
        if (this._textBuilder.equalsString("1.0")) {
            this._config.setXmlVersion("1.0");
        } else if (this._textBuilder.equalsString("1.1")) {
            this._config.setXmlVersion("1.1");
        } else {
            this.reportInputProblem("Unrecognized XML version '" + this._textBuilder.contentsAsString() + "' (expected '1.0' or '1.1')");
        }
    }

    private final void verifyAndSetXmlEncoding() throws XMLStreamException {
        String enc = CharsetNames.normalize(this._textBuilder.contentsAsString());
        this._config.setXmlEncoding(enc);
        if ("UTF-8" != enc && "US-ASCII" != enc) {
            this.reportInputProblem("Unsupported encoding '" + enc + "': only UTF-8 and US-ASCII support by async parser");
        }
    }

    private final void verifyAndSetXmlStandalone() throws XMLStreamException {
        if (this._textBuilder.equalsString("yes")) {
            this._config.setXmlStandalone(Boolean.TRUE);
        } else if (this._textBuilder.equalsString("no")) {
            this._config.setXmlStandalone(Boolean.FALSE);
        } else {
            this.reportInputProblem("Invalid standalone value '" + this._textBuilder.contentsAsString() + "': can only use 'yes' and 'no'");
        }
    }

    private final void verifyAndSetPublicId() throws XMLStreamException {
        this._publicId = this._textBuilder.contentsAsString();
    }

    private final void verifyAndSetSystemId() throws XMLStreamException {
        this._systemId = this._textBuilder.contentsAsString();
    }

    protected abstract int startCharacters(byte var1) throws XMLStreamException;

    private int handleCData() throws XMLStreamException {
        if (this._state == 1) {
            return this.parseCDataContents();
        }
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        return this.handleCDataStartMarker(this._inputBuffer[this._inputPtr++]);
    }

    private int handleCDataStartMarker(byte b) throws XMLStreamException {
        switch (this._state) {
            case 0: {
                if (b != 67) {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected 'C' for CDATA)");
                }
                this._state = 2;
                if (this._inputPtr >= this._inputEnd) {
                    return 257;
                }
                b = this._inputBuffer[this._inputPtr++];
            }
            case 2: {
                if (b != 68) {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected 'D' for CDATA)");
                }
                this._state = 3;
                if (this._inputPtr >= this._inputEnd) {
                    return 257;
                }
                b = this._inputBuffer[this._inputPtr++];
            }
            case 3: {
                if (b != 65) {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected 'A' for CDATA)");
                }
                this._state = 4;
                if (this._inputPtr >= this._inputEnd) {
                    return 257;
                }
                b = this._inputBuffer[this._inputPtr++];
            }
            case 4: {
                if (b != 84) {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected 'T' for CDATA)");
                }
                this._state = 5;
                if (this._inputPtr >= this._inputEnd) {
                    return 257;
                }
                b = this._inputBuffer[this._inputPtr++];
            }
            case 5: {
                if (b != 65) {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected 'A' for CDATA)");
                }
                this._state = 6;
                if (this._inputPtr >= this._inputEnd) {
                    return 257;
                }
                b = this._inputBuffer[this._inputPtr++];
            }
            case 6: {
                if (b != 91) {
                    this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '[' for CDATA)");
                }
                this._textBuilder.resetWithEmpty();
                this._state = 1;
                if (this._inputPtr >= this._inputEnd) {
                    return 257;
                }
                return this.parseCDataContents();
            }
        }
        return this.throwInternal();
    }

    private int handlePI() throws XMLStreamException {
        if (this._state == 5) {
            return this.parsePIData();
        }
        block7: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            switch (this._state) {
                case 0: {
                    this._tokenName = this.parseNewName(this._inputBuffer[this._inputPtr++]);
                    if (this._tokenName == null) {
                        this._state = 4;
                        return 257;
                    }
                    this._state = 1;
                    this.checkPITargetName(this._tokenName);
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                }
                case 1: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 63) {
                        if (this._inputPtr < this._inputEnd && this._inputBuffer[this._inputPtr] == 62) {
                            ++this._inputPtr;
                            break block7;
                        }
                        this._state = 3;
                        continue block7;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        if (!this.asyncSkipSpace()) {
                            this._state = 2;
                            return 257;
                        }
                        this._textBuilder.resetWithEmpty();
                        if (this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr] == 63 && this._inputBuffer[this._inputPtr + 1] == 62) {
                            this._inputPtr += 2;
                            break block7;
                        }
                        this._state = 5;
                        return this.parsePIData();
                    }
                    this.reportMissingPISpace(this.decodeCharForError(b));
                }
                case 2: {
                    if (!this.asyncSkipSpace()) {
                        return 257;
                    }
                    this._state = 5;
                    this._textBuilder.resetWithEmpty();
                    return this.parsePIData();
                }
                case 3: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b == 62) break block7;
                    this.reportMissingPISpace(this.decodeCharForError(b));
                    break block7;
                }
                case 4: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) {
                        return 257;
                    }
                    this.checkPITargetName(this._tokenName);
                    this._state = 1;
                    continue block7;
                }
                default: {
                    return this.throwInternal();
                }
            }
            break;
        }
        this._state = 0;
        this._nextEvent = 257;
        return 3;
    }

    private final int handleComment() throws XMLStreamException {
        if (this._state == 1) {
            return this.parseCommentContents();
        }
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        byte b = this._inputBuffer[this._inputPtr++];
        if (this._state == 0) {
            if (b != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '-' for COMMENT)");
            }
            this._state = 1;
            this._textBuilder.resetWithEmpty();
            return this.parseCommentContents();
        }
        if (this._state == 3) {
            if (b != 62) {
                this.reportDoubleHyphenInComments();
            }
            this._state = 0;
            this._nextEvent = 257;
            return 5;
        }
        return this.throwInternal();
    }

    private boolean asyncSkipSpace() throws XMLStreamException {
        while (this._inputPtr < this._inputEnd) {
            byte b = this._inputBuffer[this._inputPtr];
            if ((b & 0xFF) > 32) {
                if (this._pendingInput == -1) {
                    this.markLF();
                    this._pendingInput = 0;
                }
                return true;
            }
            ++this._inputPtr;
            if (b == 10) {
                this.markLF();
                continue;
            }
            if (b == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this._pendingInput = -1;
                    break;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (b == 32 || b == 9) continue;
            this.throwInvalidSpace(b);
        }
        return false;
    }

    protected int handleEntityStartingToken() throws XMLStreamException {
        this._textBuilder.resetWithEmpty();
        byte b = this._inputBuffer[this._inputPtr++];
        if (b == 35) {
            this._textBuilder.resetWithEmpty();
            this._state = 5;
            this._pendingInput = -70;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            return this.handleNumericEntityStartingToken();
        }
        PName n = this.parseNewEntityName(b);
        if (n == null) {
            this._state = 6;
            return 257;
        }
        int ch = this.decodeGeneralEntity(n);
        if (ch == 0) {
            this._tokenName = n;
            this._currToken = 9;
            this._nextEvent = 9;
            return 9;
        }
        this._textBuilder.resetWithChar((char)ch);
        this._nextEvent = 0;
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        return this._currToken;
    }

    protected int handleNamedEntityStartingToken() throws XMLStreamException {
        PName n = this.parseEntityName();
        if (n == null) {
            return this._nextEvent;
        }
        int ch = this.decodeGeneralEntity(n);
        if (ch == 0) {
            this._tokenName = n;
            this._currToken = 9;
            return 9;
        }
        this._textBuilder.resetWithChar((char)ch);
        this._nextEvent = 0;
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        return this._currToken;
    }

    protected int handleNumericEntityStartingToken() throws XMLStreamException {
        if (this._pendingInput == -70) {
            byte b = this._inputBuffer[this._inputPtr];
            this._entityValue = 0;
            if (b == 120) {
                this._pendingInput = -73;
                if (++this._inputPtr >= this._inputEnd) {
                    return 257;
                }
            } else {
                this._pendingInput = -72;
            }
        }
        if (this._pendingInput == -73 ? !this.decodeHexEntity() : !this.decodeDecEntity()) {
            return 257;
        }
        this.verifyAndAppendEntityCharacter(this._entityValue);
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._pendingInput = 0;
        return this._currToken;
    }

    protected final boolean decodeHexEntity() throws XMLStreamException {
        int value = this._entityValue;
        while (this._inputPtr < this._inputEnd) {
            int b;
            if ((b = this._inputBuffer[this._inputPtr++]) == 59) {
                this._entityValue = value;
                return true;
            }
            int ch = b;
            if (ch <= 57 && ch >= 48) {
                ch -= 48;
            } else if (ch <= 70 && ch >= 65) {
                ch = 10 + (ch - 65);
            } else if (ch <= 102 && ch >= 97) {
                ch = 10 + (ch - 97);
            } else {
                this.throwUnexpectedChar(this.decodeCharForError((byte)b), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            if ((value = (value << 4) + ch) <= 0x10FFFF) continue;
            this._entityValue = value;
            this.reportEntityOverflow();
        }
        this._entityValue = value;
        return false;
    }

    protected final boolean decodeDecEntity() throws XMLStreamException {
        int value = this._entityValue;
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) == 59) {
                this._entityValue = value;
                return true;
            }
            int ch = b - 48;
            if (ch < 0 || ch > 9) {
                this.throwUnexpectedChar(this.decodeCharForError(b), " expected a digit (0 - 9) for character entity");
            }
            if ((value = value * 10 + ch) <= 0x10FFFF) continue;
            this._entityValue = value;
            this.reportEntityOverflow();
        }
        this._entityValue = value;
        return false;
    }

    protected final int decodeGeneralEntity(PName entityName) throws XMLStreamException {
        String name;
        byte b;
        if ((b = this._inputBuffer[this._inputPtr++]) != 59) {
            this.throwUnexpectedChar(this.decodeCharForError(b), " expected ';' following entity name (\"" + entityName.getPrefixedName() + "\")");
        }
        if ((name = entityName.getPrefixedName()) == "amp") {
            return 38;
        }
        if (name == "lt") {
            return 60;
        }
        if (name == "apos") {
            return 39;
        }
        if (name == "quot") {
            return 34;
        }
        if (name == "gt") {
            return 62;
        }
        return 0;
    }

    protected int handleStartElementStart(byte b) throws XMLStreamException {
        PName elemName = this.parseNewName(b);
        this._nextEvent = 1;
        if (elemName == null) {
            this._state = 1;
            return 257;
        }
        this.initStartElement(elemName);
        return this.handleStartElement();
    }

    protected int handleStartElement() throws XMLStreamException {
        block14: while (this._inputPtr < this._inputEnd) {
            switch (this._state) {
                case 1: {
                    PName elemName = this.parsePName();
                    if (elemName == null) {
                        return 257;
                    }
                    this.initStartElement(elemName);
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                }
                case 2: {
                    byte b;
                    int c;
                    if (this._pendingInput != 0) {
                        if (!this.handlePartialCR()) {
                            return 257;
                        }
                    } else if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32) {
                        if (c == 10) {
                            this.markLF();
                        } else if (c == 13) {
                            if (this._inputPtr >= this._inputEnd) {
                                this._pendingInput = -1;
                                return 257;
                            }
                            if (this._inputBuffer[this._inputPtr] == 10) {
                                ++this._inputPtr;
                            }
                            this.markLF();
                        } else if (c != 32 && c != 9) {
                            this.throwInvalidSpace(c);
                        }
                    } else {
                        if (c == 62) {
                            return this.finishStartElement(false);
                        }
                        if (c == 47) {
                            this._state = 9;
                            continue block14;
                        }
                        this.throwUnexpectedChar(this.decodeCharForError(b), " expected space, or '>' or \"/>\"");
                    }
                    this._state = 3;
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                }
                case 3: 
                case 5: 
                case 6: {
                    PName n;
                    if (this._pendingInput != 0) {
                        if (!this.handlePartialCR()) {
                            return 257;
                        }
                        if (this._inputPtr >= this._inputEnd) {
                            return 257;
                        }
                    }
                    byte b = this._inputBuffer[this._inputPtr++];
                    int c = b & 0xFF;
                    while (c <= 32) {
                        if (c == 10) {
                            this.markLF();
                        } else if (c == 13) {
                            if (this._inputPtr >= this._inputEnd) {
                                this._pendingInput = -1;
                                return 257;
                            }
                            if (this._inputBuffer[this._inputPtr] == 10) {
                                ++this._inputPtr;
                            }
                            this.markLF();
                        } else if (c != 32 && c != 9) {
                            this.throwInvalidSpace(c);
                        }
                        if (this._inputPtr >= this._inputEnd) {
                            return 257;
                        }
                        b = this._inputBuffer[this._inputPtr++];
                        c = b & 0xFF;
                    }
                    switch (this._state) {
                        case 3: {
                            if (b == 47) {
                                this._state = 9;
                                continue block14;
                            }
                            if (b == 62) {
                                return this.finishStartElement(false);
                            }
                            n = this.parseNewName(b);
                            if (n == null) {
                                this._state = 4;
                                return 257;
                            }
                            this._state = 5;
                            this._elemAttrName = n;
                            continue block14;
                        }
                        case 5: {
                            if (b != 61) {
                                this.throwUnexpectedChar(this.decodeCharForError(b), " expected '='");
                            }
                            this._state = 6;
                            continue block14;
                        }
                        case 6: {
                            if (b != 34 && b != 39) {
                                this.throwUnexpectedChar(this.decodeCharForError(b), " Expected a quote");
                            }
                            this.initAttribute(b);
                            continue block14;
                        }
                    }
                    this.throwInternal();
                }
                case 4: {
                    PName n = this.parsePName();
                    if (n == null) {
                        return 257;
                    }
                    this._elemAttrName = n;
                    this._state = 5;
                    continue block14;
                }
                case 7: {
                    if (!this.handleAttrValue()) {
                        return 257;
                    }
                    this._state = 2;
                    continue block14;
                }
                case 8: {
                    if (!this.handleNsDecl()) {
                        return 257;
                    }
                    this._state = 2;
                    continue block14;
                }
                case 9: {
                    byte b = this._inputBuffer[this._inputPtr++];
                    if (b != 62) {
                        this.throwUnexpectedChar(this.decodeCharForError(b), " expected '>'");
                    }
                    return this.finishStartElement(true);
                }
            }
            this.throwInternal();
        }
        return 257;
    }

    private void initStartElement(PName elemName) {
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            this._elemAllNsBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            this._elemAllNsBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        this._attrCount = 0;
        this._currNsCount = 0;
        this._elemAttrPtr = 0;
        this._state = 2;
    }

    private void initAttribute(byte quoteChar) {
        boolean nsDecl;
        this._elemAttrQuote = quoteChar;
        PName attrName = this._elemAttrName;
        String prefix = attrName.getPrefix();
        if (prefix == null) {
            nsDecl = attrName.getLocalName() == "xmlns";
        } else if (prefix == "xmlns") {
            nsDecl = true;
        } else {
            attrName = this.bindName(attrName, prefix);
            if (this._elemAllNsBound) {
                this._elemAllNsBound = attrName.isBound();
            }
            nsDecl = false;
        }
        if (nsDecl) {
            this._state = 8;
            this._elemNsPtr = 0;
            ++this._currNsCount;
        } else {
            this._state = 7;
            this._attrCollector.startNewValue(attrName, this._elemAttrPtr);
        }
    }

    protected abstract boolean handleAttrValue() throws XMLStreamException;

    protected abstract boolean handleNsDecl() throws XMLStreamException;

    private int finishStartElement(boolean emptyTag) throws XMLStreamException {
        this._isEmptyTag = emptyTag;
        int act = this._attrCollector.finishLastValue(this._elemAttrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!this._elemAllNsBound) {
            if (!this._tokenName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PName attrName = this._attrCollector.getName(i);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        this._currToken = 1;
        return 1;
    }

    private int handleEndElementStart() throws XMLStreamException {
        int q;
        --this._depth;
        this._tokenName = this._currElem.getName();
        int size = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (size << 2) + 1) {
            this._nextEvent = 2;
            this._state = 0;
            this._currQuadBytes = 0;
            this._currQuad = 0;
            this._quadCount = 0;
            return this.handleEndElement();
        }
        byte[] buf = this._inputBuffer;
        --size;
        for (int qix = 0; qix < size; ++qix) {
            int ptr = this._inputPtr;
            int q2 = buf[ptr] << 24 | (buf[ptr + 1] & 0xFF) << 16 | (buf[ptr + 2] & 0xFF) << 8 | buf[ptr + 3] & 0xFF;
            this._inputPtr += 4;
            if (q2 == this._tokenName.getQuad(qix)) continue;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int lastQ = this._tokenName.getQuad(size);
        if ((q = buf[this._inputPtr++] & 0xFF) != lastQ && (q = q << 8 | buf[this._inputPtr++] & 0xFF) != lastQ && (q = q << 8 | buf[this._inputPtr++] & 0xFF) != lastQ && (q = q << 8 | buf[this._inputPtr++] & 0xFF) != lastQ) {
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int i2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this._pendingInput = -1;
                    this._nextEvent = 2;
                    this._state = 1;
                    return 257;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            if (this._inputPtr >= this._inputEnd) {
                this._nextEvent = 2;
                this._state = 1;
                return 257;
            }
            i2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        this._currToken = 2;
        return 2;
    }

    private int handleEndElement() throws XMLStreamException {
        int i2;
        if (this._state == 0) {
            block17: {
                PName elemName = this._tokenName;
                int quadSize = elemName.sizeInQuads() - 1;
                while (this._quadCount < quadSize) {
                    while (this._currQuadBytes < 4) {
                        if (this._inputPtr >= this._inputEnd) {
                            return 257;
                        }
                        this._currQuad = this._currQuad << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                        ++this._currQuadBytes;
                    }
                    if (this._currQuad != elemName.getQuad(this._quadCount)) {
                        this.reportUnexpectedEndTag(elemName.getPrefixedName());
                    }
                    this._currQuadBytes = 0;
                    this._currQuad = 0;
                    ++this._quadCount;
                }
                int lastQ = elemName.getLastQuad();
                do {
                    if (this._inputPtr >= this._inputEnd) {
                        return 257;
                    }
                    int q = this._currQuad << 8;
                    this._currQuad = q |= this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (q == lastQ) break block17;
                } while (++this._currQuadBytes <= 3);
                this.reportUnexpectedEndTag(elemName.getPrefixedName());
            }
            this._state = 1;
        } else if (this._state != 1) {
            this.throwInternal();
        }
        if (this._pendingInput != 0 && !this.handlePartialCR()) {
            return 257;
        }
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) break;
            if (i2 == 10) {
                this.markLF();
                continue;
            }
            if (i2 == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this._pendingInput = -1;
                    return 257;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (i2 == 32 || i2 == 9) continue;
            this.throwInvalidSpace(i2);
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        this._currToken = 2;
        return 2;
    }

    @Override
    protected abstract void finishCharacters() throws XMLStreamException;

    @Override
    protected void finishCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishDTD(boolean copyContents) throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected abstract boolean skipCharacters() throws XMLStreamException;

    @Override
    protected void skipCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected boolean loadMore() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    protected PName parseNewName(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        this._quadCount = 0;
        this._currQuad = q;
        this._currQuadBytes = 1;
        return this.parsePName();
    }

    protected PName parsePName() throws XMLStreamException {
        int q = this._currQuad;
        while (true) {
            switch (this._currQuadBytes) {
                case 0: {
                    if (this._inputPtr >= this._inputEnd) {
                        return null;
                    }
                    if ((q = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (q < 45 || q > 58 || q == 47)) {
                        return this.findPName(q, 0);
                    }
                }
                case 1: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 1;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 1);
                    }
                    q = q << 8 | i;
                }
                case 2: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 2;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 2);
                    }
                    q = q << 8 | i;
                }
                case 3: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 3;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 3);
                    }
                    q = q << 8 | i;
                }
            }
            if (this._quadCount == 0) {
                this._quadBuffer[0] = q;
                this._quadCount = 1;
            } else {
                if (this._quadCount >= this._quadBuffer.length) {
                    this._quadBuffer = DataUtil.growArrayBy(this._quadBuffer, this._quadBuffer.length);
                }
                this._quadBuffer[this._quadCount++] = q;
            }
            this._currQuadBytes = 0;
        }
    }

    protected final PName parseNewEntityName(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        this._quadCount = 0;
        this._currQuad = q;
        this._currQuadBytes = 1;
        return this.parseEntityName();
    }

    protected final PName parseEntityName() throws XMLStreamException {
        int q = this._currQuad;
        while (true) {
            switch (this._currQuadBytes) {
                case 0: {
                    if (this._inputPtr >= this._inputEnd) {
                        return null;
                    }
                    if ((q = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (q < 45 || q > 58 || q == 47)) {
                        if (this._quadCount == 1) {
                            q = this._quadBuffer[0];
                            if (q == EntityNames.ENTITY_APOS_QUAD) {
                                --this._inputPtr;
                                return EntityNames.ENTITY_APOS;
                            }
                            if (q == EntityNames.ENTITY_QUOT_QUAD) {
                                --this._inputPtr;
                                return EntityNames.ENTITY_QUOT;
                            }
                        }
                        return this.findPName(q, 0);
                    }
                }
                case 1: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 1;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this.findPName(q, 1);
                    }
                    q = q << 8 | i;
                }
                case 2: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 2;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        if (this._quadCount == 0) {
                            if (q == EntityNames.ENTITY_GT_QUAD) {
                                --this._inputPtr;
                                return EntityNames.ENTITY_GT;
                            }
                            if (q == EntityNames.ENTITY_LT_QUAD) {
                                --this._inputPtr;
                                return EntityNames.ENTITY_LT;
                            }
                        }
                        return this.findPName(q, 2);
                    }
                    q = q << 8 | i;
                }
                case 3: {
                    int i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 3;
                        return null;
                    }
                    if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i < 45 || i > 58 || i == 47)) {
                        if (this._quadCount == 0 && q == EntityNames.ENTITY_AMP_QUAD) {
                            --this._inputPtr;
                            return EntityNames.ENTITY_AMP;
                        }
                        return this.findPName(q, 3);
                    }
                    q = q << 8 | i;
                }
            }
            if (this._quadCount == 0) {
                this._quadBuffer[0] = q;
                this._quadCount = 1;
            } else {
                if (this._quadCount >= this._quadBuffer.length) {
                    this._quadBuffer = DataUtil.growArrayBy(this._quadBuffer, this._quadBuffer.length);
                }
                this._quadBuffer[this._quadCount++] = q;
            }
            this._currQuadBytes = 0;
        }
    }

    private final PName findPName(int lastQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int qlen = this._quadCount;
        if (lastByteCount == 0) {
            lastQuad = this._quadBuffer[--qlen];
            lastByteCount = 4;
        }
        if (qlen <= 1) {
            if (qlen == 0) {
                int hash = ByteBasedPNameTable.calcHash(lastQuad);
                PName name = this._symbols.findSymbol(hash, lastQuad, 0);
                if (name == null) {
                    this._quadBuffer[0] = lastQuad;
                    name = this.addPName(hash, this._quadBuffer, 1, lastByteCount);
                }
                return name;
            }
            int firstQuad = this._quadBuffer[0];
            int hash = ByteBasedPNameTable.calcHash(firstQuad, lastQuad);
            PName name = this._symbols.findSymbol(hash, firstQuad, lastQuad);
            if (name == null) {
                this._quadBuffer[1] = lastQuad;
                name = this.addPName(hash, this._quadBuffer, 2, lastByteCount);
            }
            return name;
        }
        if (qlen >= this._quadBuffer.length) {
            this._quadBuffer = DataUtil.growArrayBy(this._quadBuffer, this._quadBuffer.length);
        }
        this._quadBuffer[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(this._quadBuffer, qlen);
        PName name = this._symbols.findSymbol(hash, this._quadBuffer, qlen);
        if (name == null) {
            name = this.addPName(hash, this._quadBuffer, qlen, lastByteCount);
        }
        return name;
    }

    @Override
    protected abstract PName addPName(int var1, int[] var2, int var3, int var4) throws XMLStreamException;

    protected void verifyAndAppendEntityCharacter(int charFromEntity) throws XMLStreamException {
        this.verifyXmlChar(charFromEntity);
        if (charFromEntity >> 16 != 0) {
            this._textBuilder.append((char)(0xD800 | (charFromEntity -= 65536) >> 10));
            charFromEntity = 0xDC00 | charFromEntity & 0x3FF;
        }
        this._textBuilder.append((char)charFromEntity);
    }

    protected final boolean handlePartialCR() {
        if (this._pendingInput != -1) {
            this.throwInternal();
        }
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        this._pendingInput = 0;
        if (this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currRow;
        this._rowStartOffset = this._inputPtr;
        return true;
    }

    @Override
    protected int decodeCharForError(byte b) throws XMLStreamException {
        return b;
    }

    private void checkPITargetName(PName targetName) throws XMLStreamException {
        String ln = targetName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && !targetName.hasPrefix()) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
    }

    protected int throwInternal() {
        throw new IllegalStateException("Internal error: should never execute this code path");
    }
}

