/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.async.AsyncByteScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import javax.xml.stream.XMLStreamException;

public class AsyncUtfScanner
extends AsyncByteScanner {
    private static final int EVENT_INCOMPLETE = 257;
    private static final int PENDING_STATE_ATTR_VALUE_AMP = -60;
    private static final int PENDING_STATE_ATTR_VALUE_AMP_HASH = -61;
    static final int PENDING_STATE_ATTR_VALUE_AMP_HASH_X = -62;
    private static final int PENDING_STATE_ATTR_VALUE_ENTITY_NAME = -63;
    private static final int PENDING_STATE_ATTR_VALUE_DEC_DIGIT = -64;
    private static final int PENDING_STATE_ATTR_VALUE_HEX_DIGIT = -65;
    private static final int PENDING_STATE_TEXT_AMP = -80;
    private static final int PENDING_STATE_TEXT_AMP_HASH = -81;
    private static final int PENDING_STATE_TEXT_DEC_ENTITY = -82;
    private static final int PENDING_STATE_TEXT_HEX_ENTITY = -83;
    private static final int PENDING_STATE_TEXT_IN_ENTITY = -84;
    private static final int PENDING_STATE_TEXT_BRACKET1 = -85;
    private static final int PENDING_STATE_TEXT_BRACKET2 = -86;
    protected boolean _inDtdDeclaration;

    public AsyncUtfScanner(ReaderConfig cfg) {
        super(cfg);
        this._currToken = 257;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected final int startCharacters(byte b) throws XMLStreamException {
        block20: {
            int c = b & 0xFF;
            switch (this._charTypes.TEXT_CHARS[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        return 257;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c;
                        return 257;
                    }
                    c = this.decodeUtf8_2(c);
                    break;
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            int d = this._inputBuffer[this._inputPtr++] & 0xFF;
                            c |= d << 8;
                        }
                        this._pendingInput = c;
                        return 257;
                    }
                    c = this.decodeUtf8_3(c);
                    break;
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            int d = this._inputBuffer[this._inputPtr++] & 0xFF;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 0xFF;
                                c |= d << 16;
                            }
                        }
                        this._pendingInput = c;
                        return 257;
                    }
                    c = this.decodeUtf8_4(c);
                    this._textBuilder.resetWithSurrogate(c);
                    break block20;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                    break;
                }
                case 9: 
                case 10: {
                    this.throwInternal();
                }
            }
            this._textBuilder.resetWithChar((char)c);
        }
        if (this._cfgCoalescing && !this._cfgLazyParsing) {
            return this.finishCharactersCoalescing();
        }
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
            return this._currToken;
        }
        this.finishCharacters();
        return this._currToken;
    }

    @Override
    protected int startCharactersPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        int c = this._pendingInput;
        this._pendingInput = 0;
        if (c == -1) {
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
            this.markLF();
            this._textBuilder.resetWithChar('\n');
        } else {
            switch (this._charTypes.TEXT_CHARS[c & 0xFF]) {
                case 5: {
                    this._textBuilder.resetWithChar((char)this.decodeUtf8_2(c));
                    break;
                }
                case 6: {
                    int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                    int c2 = c >> 8;
                    if (c2 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c | next << 8;
                            return 257;
                        }
                        int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_3(c, next, c3);
                    } else {
                        c = this.decodeUtf8_3(c & 0xFF, c2, next);
                    }
                    this._textBuilder.resetWithChar((char)c);
                    break;
                }
                case 7: {
                    int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (c >> 8 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c | next << 8;
                            return 257;
                        }
                        int c2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c | next << 8 | c2 << 16;
                            return 257;
                        }
                        int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_4(c, next, c2, c3);
                    } else {
                        int c2 = c >> 8 & 0xFF;
                        int c3 = c >> 16;
                        if (c3 == 0) {
                            if (this._inputPtr >= this._inputEnd) {
                                this._pendingInput = c | next << 16;
                                return 257;
                            }
                            c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                            c = this.decodeUtf8_4(c & 0xFF, c2, next, c3);
                        } else {
                            c = this.decodeUtf8_4(c & 0xFF, c2, c3, next);
                        }
                    }
                    this._textBuilder.resetWithSurrogate(c);
                    this._currToken = 4;
                    return 4;
                }
                default: {
                    this.throwInternal();
                }
            }
        }
        if (this._cfgCoalescing && !this._cfgLazyParsing) {
            return this.finishCharactersCoalescing();
        }
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        return this._currToken;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCharacters() throws XMLStreamException {
        if (this._pendingInput != 0) {
            this.throwInternal();
        }
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block12: while ((ptr = this._inputPtr) < this._inputEnd) {
            block32: {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block32;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        break block12;
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl102
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl102
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c;
                        break block12;
                    }
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl102
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this._pendingInput = c;
                        break block12;
                    }
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl102
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this._pendingInput = c;
                        break block12;
                    }
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl102
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInCharacters();
                    if (c == 0) {
                        --this._inputPtr;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl102
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl102
                }
                case 11: {
                    count = 1;
                    b = 0;
                    while (this._inputPtr < this._inputEnd && (b = inputBuffer[this._inputPtr]) == 93) {
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (--count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr < outputBuffer.length) continue;
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                }
lbl102:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final int finishCharactersCoalescing() throws XMLStreamException {
        if (this._pendingInput != 0 && !this.handleAndAppendPending()) {
            return 257;
        }
        throw new UnsupportedOperationException();
    }

    protected int handleEntityInCharacters() throws XMLStreamException {
        int ptr = this._inputPtr;
        if (ptr + 3 <= this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[ptr++]) == 35) {
                if (this._inputBuffer[ptr] == 120) {
                    return this.handleHexEntityInCharacters(ptr + 1);
                }
                return this.handleDecEntityInCharacters(ptr);
            }
            if (b == 97) {
                if ((b = this._inputBuffer[ptr++]) == 109) {
                    if (ptr + 1 < this._inputPtr && this._inputBuffer[ptr] == 112 && this._inputBuffer[ptr + 1] == 59) {
                        this._inputPtr = ptr + 2;
                        return 38;
                    }
                } else if (b == 112 && ptr + 2 < this._inputPtr && this._inputBuffer[ptr] == 111 && this._inputBuffer[ptr + 1] == 115 && this._inputBuffer[ptr + 2] == 59) {
                    this._inputPtr = ptr + 3;
                    return 39;
                }
            } else if (b == 103) {
                if (this._inputBuffer[ptr] == 116 && this._inputBuffer[ptr + 1] == 59) {
                    this._inputPtr = ptr + 2;
                    return 62;
                }
            } else if (b == 108) {
                if (this._inputBuffer[ptr] == 116 && this._inputBuffer[ptr + 1] == 59) {
                    this._inputPtr = ptr + 2;
                    return 60;
                }
            } else if (b == 113 && ptr + 3 < this._inputPtr && this._inputBuffer[ptr] == 117 && this._inputBuffer[ptr + 1] == 111 && this._inputBuffer[ptr + 2] == 116 && this._inputBuffer[ptr + 3] == 59) {
                this._inputPtr = ptr + 4;
                return 39;
            }
        }
        return 0;
    }

    protected int handleDecEntityInCharacters(int ptr) throws XMLStreamException {
        byte b = this._inputBuffer[ptr++];
        int end = this._inputEnd;
        int value = 0;
        do {
            byte ch;
            if ((ch = b) > 57 || ch < 48) {
                this.throwUnexpectedChar(this.decodeCharForError(b), " expected a digit (0 - 9) for character entity");
            }
            if ((value = value * 10 + (ch - 48)) > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (ptr < end) continue;
            return 0;
        } while ((b = this._inputBuffer[ptr++]) != 59);
        this._inputPtr = ptr;
        this.verifyXmlChar(value);
        return value;
    }

    protected int handleHexEntityInCharacters(int ptr) throws XMLStreamException {
        int b = this._inputBuffer[ptr++];
        int end = this._inputEnd;
        int value = 0;
        do {
            int ch;
            if ((ch = b) <= 57 && ch >= 48) {
                ch -= 48;
            } else if (ch <= 70 && ch >= 65) {
                ch = 10 + (ch - 65);
            } else if (ch <= 102 && ch >= 97) {
                ch = 10 + (ch - 97);
            } else {
                this.throwUnexpectedChar(this.decodeCharForError((byte)b), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            value = (value << 4) + ch;
            if (value > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (ptr < end) continue;
            return 0;
        } while ((b = this._inputBuffer[ptr++]) != 59);
        this._inputPtr = ptr;
        this.verifyXmlChar(value);
        return value;
    }

    private final boolean handleAndAppendPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        int c = this._pendingInput;
        this._pendingInput = 0;
        if (c < 0) {
            if (c == -1) {
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                this._textBuilder.append('\n');
                return true;
            }
            this.throwInternal();
        }
        switch (this._charTypes.TEXT_CHARS[c & 0xFF]) {
            case 5: {
                this._textBuilder.append((char)this.decodeUtf8_2(c));
                break;
            }
            case 6: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                int c2 = c >> 8;
                if (c2 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8;
                        return false;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    c = this.decodeUtf8_3(c, next, c3);
                } else {
                    c = this.decodeUtf8_3(c & 0xFF, c2, next);
                }
                this._textBuilder.append((char)c);
                break;
            }
            case 7: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (c >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8;
                        return false;
                    }
                    int c2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8 | c2 << 16;
                        return false;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    c = this.decodeUtf8_4(c, next, c2, c3);
                } else {
                    int c2 = c >> 8 & 0xFF;
                    int c3 = c >> 16;
                    if (c3 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c | next << 16;
                            return false;
                        }
                        c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_4(c & 0xFF, c2, next, c3);
                    } else {
                        c = this.decodeUtf8_4(c & 0xFF, c2, c3, next);
                    }
                }
                this._textBuilder.appendSurrogate(c);
                break;
            }
            default: {
                this.throwInternal();
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean skipCharacters() throws XMLStreamException {
        if (this._pendingInput != 0 && !this.skipPending()) {
            return false;
        }
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        block12: while ((ptr = this._inputPtr) < (max = this._inputEnd)) {
            block26: {
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) continue;
                    break block26;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        break block12;
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    ** GOTO lbl76
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl76
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c;
                        break block12;
                    }
                    this.skipUtf8_2(c);
                    ** GOTO lbl76
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this._pendingInput = c;
                        break block12;
                    }
                    this.decodeUtf8_3(c);
                    ** GOTO lbl76
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this._pendingInput = c;
                        break block12;
                    }
                    this.decodeUtf8_4(c);
                    ** GOTO lbl76
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    return true;
                }
                case 10: {
                    c = this.skipEntityInCharacters();
                    if (c == 0) {
                        this._pendingInput = -80;
                        return this._inputPtr < this._inputEnd && this.skipPending() != false;
                    }
                    ** GOTO lbl76
                }
                case 11: {
                    count = 1;
                    b = 0;
                    while (this._inputPtr < this._inputEnd && (b = inputBuffer[this._inputPtr]) == 93) {
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                }
lbl76:
                // 10 sources

                default: {
                    continue block12;
                }
            }
        }
        return false;
    }

    private final boolean skipPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        if (this._pendingInput < 0) {
            do {
                switch (this._pendingInput) {
                    case -1: {
                        this._pendingInput = 0;
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        return true;
                    }
                    case -80: {
                        byte b = this._inputBuffer[this._inputPtr++];
                        if (b == 35) {
                            this._pendingInput = -81;
                            break;
                        }
                        PName n = this.parseNewEntityName(b);
                        if (n == null) {
                            this._pendingInput = -84;
                            return false;
                        }
                        int ch = this.decodeGeneralEntity(n);
                        if (ch == 0) {
                            this._tokenName = n;
                            this._nextEvent = 9;
                        }
                        this._pendingInput = 0;
                        return true;
                    }
                    case -81: {
                        this._entityValue = 0;
                        if (this._inputBuffer[this._inputPtr] == 120) {
                            ++this._inputPtr;
                            if (this.decodeHexEntity()) {
                                this._pendingInput = 0;
                                return true;
                            }
                            this._pendingInput = -83;
                            return false;
                        }
                        if (this.decodeDecEntity()) {
                            this._pendingInput = 0;
                            return true;
                        }
                        this._pendingInput = -82;
                        return false;
                    }
                    case -82: {
                        if (this.decodeDecEntity()) {
                            this._pendingInput = 0;
                            return true;
                        }
                        return false;
                    }
                    case -83: {
                        if (this.decodeHexEntity()) {
                            this._pendingInput = 0;
                            return true;
                        }
                        return false;
                    }
                    case -84: {
                        PName n = this.parseEntityName();
                        if (n == null) {
                            return false;
                        }
                        int ch = this.decodeGeneralEntity(n);
                        if (ch == 0) {
                            this._tokenName = n;
                            this._nextEvent = 9;
                        }
                        this._pendingInput = 0;
                        return true;
                    }
                    case -85: {
                        if (this._inputBuffer[this._inputPtr] != 93) {
                            this._pendingInput = 0;
                            return true;
                        }
                        ++this._inputPtr;
                        this._pendingInput = -86;
                        break;
                    }
                    case -86: {
                        byte b = this._inputBuffer[this._inputPtr];
                        if (b == 93) {
                            ++this._inputPtr;
                            break;
                        }
                        if (b == 62) {
                            ++this._inputPtr;
                            this.reportInputProblem("Encountered ']]>' in text segment");
                        }
                        this._pendingInput = 0;
                        return true;
                    }
                    default: {
                        this.throwInternal();
                    }
                }
            } while (this._inputPtr < this._inputEnd);
            return false;
        }
        int c = this._pendingInput;
        switch (this._charTypes.TEXT_CHARS[c & 0xFF]) {
            case 5: {
                this.skipUtf8_2(c);
                break;
            }
            case 6: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                int c2 = c >> 8;
                if (c2 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8;
                        return false;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    this.decodeUtf8_3(c, next, c3);
                    break;
                }
                this.decodeUtf8_3(c & 0xFF, c2, next);
                break;
            }
            case 7: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (c >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8;
                        return false;
                    }
                    int c2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8 | c2 << 16;
                        return false;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    this.decodeUtf8_4(c, next, c2, c3);
                    break;
                }
                int c2 = c >> 8 & 0xFF;
                int c3 = c >> 16;
                if (c3 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 16;
                        return false;
                    }
                    c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    this.decodeUtf8_4(c & 0xFF, c2, next, c3);
                    break;
                }
                this.decodeUtf8_4(c & 0xFF, c2, c3, next);
                break;
            }
            default: {
                this.throwInternal();
            }
        }
        this._pendingInput = 0;
        return true;
    }

    private int skipEntityInCharacters() throws XMLStreamException {
        int ptr = this._inputPtr;
        if (ptr + 3 <= this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[ptr++]) == 35) {
                if (this._inputBuffer[ptr] == 120) {
                    return this.handleHexEntityInCharacters(ptr + 1);
                }
                return this.handleDecEntityInCharacters(ptr);
            }
            if (b == 97) {
                if ((b = this._inputBuffer[ptr++]) == 109) {
                    if (ptr + 1 < this._inputPtr && this._inputBuffer[ptr] == 112 && this._inputBuffer[ptr + 1] == 59) {
                        this._inputPtr = ptr + 2;
                        return 38;
                    }
                } else if (b == 112 && ptr + 2 < this._inputPtr && this._inputBuffer[ptr] == 111 && this._inputBuffer[ptr + 1] == 115 && this._inputBuffer[ptr + 2] == 59) {
                    this._inputPtr = ptr + 3;
                    return 39;
                }
            } else if (b == 103) {
                if (this._inputBuffer[ptr] == 116 && this._inputBuffer[ptr + 1] == 59) {
                    this._inputPtr = ptr + 2;
                    return 62;
                }
            } else if (b == 108) {
                if (this._inputBuffer[ptr] == 116 && this._inputBuffer[ptr + 1] == 59) {
                    this._inputPtr = ptr + 2;
                    return 60;
                }
            } else if (b == 113 && ptr + 3 < this._inputPtr && this._inputBuffer[ptr] == 117 && this._inputBuffer[ptr + 1] == 111 && this._inputBuffer[ptr + 2] == 116 && this._inputBuffer[ptr + 3] == 59) {
                this._inputPtr = ptr + 4;
                return 39;
            }
        }
        return 0;
    }

    @Override
    protected boolean skipCoalescedText() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleAttrValue() throws XMLStreamException {
        if (this._pendingInput != 0) {
            if (!this.handleAttrValuePending()) {
                return false;
            }
            this._pendingInput = 0;
        }
        attrBuffer = this._attrCollector.continueValue();
        TYPES = this._charTypes.ATTR_CHARS;
        quoteChar = this._elemAttrQuote;
        block13: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return false;
            }
            if (this._elemAttrPtr >= attrBuffer.length) {
                attrBuffer = this._attrCollector.valueBufferFull();
            }
            if ((max2 = this._inputPtr + (attrBuffer.length - this._elemAttrPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (true) {
                if (this._inputPtr >= max) continue block13;
                if (TYPES[c = this._inputBuffer[this._inputPtr++] & 255] != 0) break;
                attrBuffer[this._elemAttrPtr++] = (char)c;
            }
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        return false;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl83
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl83
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this._pendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl83
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this._pendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_4(c);
                    attrBuffer[this._elemAttrPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (this._elemAttrPtr >= attrBuffer.length) {
                        attrBuffer = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl83
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleEntityInAttributeValue();
                    if (c <= 0) {
                        if (c < 0) {
                            return false;
                        }
                        this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[this._elemAttrPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (this._elemAttrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl83
                }
                case 14: {
                    if (c == quoteChar) break block13;
                }
lbl83:
                // 7 sources

                default: {
                    attrBuffer[this._elemAttrPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        return true;
    }

    private final boolean handleAttrValuePending() throws XMLStreamException {
        int ch;
        if (this._pendingInput == -1) {
            if (!this.handlePartialCR()) {
                return false;
            }
            char[] attrBuffer = this._attrCollector.continueValue();
            if (this._elemAttrPtr >= attrBuffer.length) {
                attrBuffer = this._attrCollector.valueBufferFull();
            }
            attrBuffer[this._elemAttrPtr++] = 32;
            return true;
        }
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        if (this._pendingInput == -60) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) == 35) {
                this._pendingInput = -61;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr] == 120) {
                    this._pendingInput = -62;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        return false;
                    }
                    ch = this.handleHexEntityInAttribute(true);
                } else {
                    ch = this.handleDecEntityInAttribute(true);
                }
            } else {
                PName entityName = this.parseNewEntityName(b);
                if (entityName == null) {
                    this._pendingInput = -63;
                    return false;
                }
                ch = this.decodeGeneralEntity(entityName);
                if (ch == 0) {
                    this._tokenName = entityName;
                    this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
                }
            }
        } else if (this._pendingInput == -61) {
            if (this._inputBuffer[this._inputPtr] == 120) {
                this._pendingInput = -62;
                ++this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                ch = this.handleHexEntityInAttribute(true);
            } else {
                ch = this.handleDecEntityInAttribute(true);
            }
        } else if (this._pendingInput == -62) {
            ch = this.handleHexEntityInAttribute(true);
        } else if (this._pendingInput == -63) {
            PName entityName = this.parseEntityName();
            if (entityName == null) {
                return false;
            }
            ch = this.decodeGeneralEntity(entityName);
            if (ch == 0) {
                this._tokenName = entityName;
                this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
            }
        } else {
            ch = this._pendingInput == -64 ? this.handleDecEntityInAttribute(false) : (this._pendingInput == -65 ? this.handleHexEntityInAttribute(false) : this.handleAttrValuePendingUTF8());
        }
        if (ch == 0) {
            return false;
        }
        char[] attrBuffer = this._attrCollector.continueValue();
        if (ch >> 16 != 0) {
            ch -= 65536;
            if (this._elemAttrPtr >= attrBuffer.length) {
                attrBuffer = this._attrCollector.valueBufferFull();
            }
            attrBuffer[this._elemAttrPtr++] = (char)(0xD800 | ch >> 10);
            ch = 0xDC00 | ch & 0x3FF;
        }
        if (this._elemAttrPtr >= attrBuffer.length) {
            attrBuffer = this._attrCollector.valueBufferFull();
        }
        attrBuffer[this._elemAttrPtr++] = (char)ch;
        return true;
    }

    private final int handleAttrValuePendingUTF8() throws XMLStreamException {
        int c = this._pendingInput;
        this._pendingInput = 0;
        switch (this._charTypes.TEXT_CHARS[c & 0xFF]) {
            case 5: {
                return this.decodeUtf8_2(c);
            }
            case 6: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                int c2 = c >> 8;
                if (c2 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8;
                        return 0;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    c = this.decodeUtf8_3(c, next, c3);
                } else {
                    c = this.decodeUtf8_3(c & 0xFF, c2, next);
                }
                return c;
            }
            case 7: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (c >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8;
                        return 0;
                    }
                    int c2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c | next << 8 | c2 << 16;
                        return 0;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    c = this.decodeUtf8_4(c, next, c2, c3);
                } else {
                    int c2 = c >> 8 & 0xFF;
                    int c3 = c >> 16;
                    if (c3 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c | next << 16;
                            return 0;
                        }
                        c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_4(c & 0xFF, c2, next, c3);
                    } else {
                        c = this.decodeUtf8_4(c & 0xFF, c2, c3, next);
                    }
                }
                return c;
            }
        }
        this.throwInternal();
        return 0;
    }

    private final int handleDecEntityInAttribute(boolean starting) throws XMLStreamException {
        byte ch;
        byte b = this._inputBuffer[this._inputPtr++];
        if (starting) {
            ch = b;
            if (ch < 48 || ch > 57) {
                this.throwUnexpectedChar(this.decodeCharForError(b), " expected a digit (0 - 9) for character entity");
            }
            this._pendingInput = -64;
            this._entityValue = ch - 48;
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        while (b != 59) {
            int value;
            ch = b - 48;
            if (ch < 0 || ch > 9) {
                this.throwUnexpectedChar(this.decodeCharForError(b), " expected a digit (0 - 9) for character entity");
            }
            this._entityValue = value = this._entityValue * 10 + ch;
            if (value > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        this.verifyXmlChar(this._entityValue);
        this._pendingInput = 0;
        return this._entityValue;
    }

    private final int handleHexEntityInAttribute(boolean starting) throws XMLStreamException {
        int ch;
        int b = this._inputBuffer[this._inputPtr++];
        if (starting) {
            ch = b;
            if (ch < 48 || ch > 57) {
                this.throwUnexpectedChar(this.decodeCharForError((byte)b), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            this._pendingInput = -65;
            this._entityValue = ch - 48;
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        while (b != 59) {
            int value;
            ch = b;
            if (ch <= 57 && ch >= 48) {
                ch -= 48;
            } else if (ch <= 70 && ch >= 65) {
                ch = 10 + (ch - 65);
            } else if (ch <= 102 && ch >= 97) {
                ch = 10 + (ch - 97);
            } else {
                this.throwUnexpectedChar(this.decodeCharForError((byte)b), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            this._entityValue = value = (this._entityValue << 4) + ch;
            if (value > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        this.verifyXmlChar(this._entityValue);
        this._pendingInput = 0;
        return this._entityValue;
    }

    protected int handleEntityInAttributeValue() throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this._pendingInput = -60;
            return -1;
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 35) {
            int ch;
            this._pendingInput = -61;
            if (this._inputPtr >= this._inputEnd) {
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 120) {
                this._pendingInput = -62;
                ++this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    return -1;
                }
                ch = this.handleHexEntityInAttribute(true);
            } else {
                ch = this.handleDecEntityInAttribute(true);
            }
            if (ch == 0) {
                return -1;
            }
            return ch;
        }
        PName entityName = this.parseNewEntityName(b);
        if (entityName == null) {
            this._pendingInput = -63;
            return -1;
        }
        int ch = this.decodeGeneralEntity(entityName);
        if (ch != 0) {
            return ch;
        }
        this._tokenName = entityName;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleNsDecl() throws XMLStreamException {
        TYPES = this._charTypes.ATTR_CHARS;
        attrBuffer = this._nameBuffer;
        quoteChar = this._elemAttrQuote;
        if (this._pendingInput != 0) {
            if (!this.handleNsValuePending()) {
                return false;
            }
            this._pendingInput = 0;
        }
        block13: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return false;
            }
            if (this._elemNsPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            if ((max2 = this._inputPtr + (attrBuffer.length - this._elemNsPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (true) {
                if (this._inputPtr >= max) continue block13;
                if (TYPES[c = this._inputBuffer[this._inputPtr++] & 255] != 0) break;
                attrBuffer[this._elemNsPtr++] = (char)c;
            }
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        return false;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl83
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl83
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this._pendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl83
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this._pendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_4(c);
                    attrBuffer[this._elemNsPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (this._elemNsPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    ** GOTO lbl83
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleEntityInAttributeValue();
                    if (c <= 0) {
                        if (c < 0) {
                            return false;
                        }
                        this.reportUnexpandedEntityInAttr(this._elemAttrName, true);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[this._elemNsPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (this._elemNsPtr >= attrBuffer.length) {
                            this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                        }
                    }
                    ** GOTO lbl83
                }
                case 14: {
                    if (c == quoteChar) break block13;
                }
lbl83:
                // 7 sources

                default: {
                    attrBuffer[this._elemNsPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        attrPtr = this._elemNsPtr;
        if (attrPtr == 0) {
            this.bindNs(this._elemAttrName, "");
        } else {
            uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(this._elemAttrName, uri);
        }
        return true;
    }

    private final boolean handleNsValuePending() throws XMLStreamException {
        int ch;
        if (this._pendingInput == -1) {
            if (!this.handlePartialCR()) {
                return false;
            }
            char[] attrBuffer = this._nameBuffer;
            if (this._elemNsPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[this._elemNsPtr++] = 32;
            return true;
        }
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        if (this._pendingInput == -60) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) == 35) {
                this._pendingInput = -61;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr] == 120) {
                    this._pendingInput = -62;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        return false;
                    }
                    ch = this.handleHexEntityInAttribute(true);
                } else {
                    ch = this.handleDecEntityInAttribute(true);
                }
            } else {
                PName entityName = this.parseNewEntityName(b);
                if (entityName == null) {
                    this._pendingInput = -63;
                    return false;
                }
                ch = this.decodeGeneralEntity(entityName);
                if (ch == 0) {
                    this._tokenName = entityName;
                    this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
                }
            }
        } else if (this._pendingInput == -61) {
            if (this._inputBuffer[this._inputPtr] == 120) {
                this._pendingInput = -62;
                ++this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                ch = this.handleHexEntityInAttribute(true);
            } else {
                ch = this.handleDecEntityInAttribute(true);
            }
        } else if (this._pendingInput == -62) {
            ch = this.handleHexEntityInAttribute(true);
        } else if (this._pendingInput == -63) {
            PName entityName = this.parseEntityName();
            if (entityName == null) {
                return false;
            }
            ch = this.decodeGeneralEntity(entityName);
            if (ch == 0) {
                this._tokenName = entityName;
                this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
            }
        } else if (this._pendingInput == -64) {
            ch = this.handleDecEntityInAttribute(false);
        } else if (this._pendingInput == -65) {
            ch = this.handleHexEntityInAttribute(false);
        } else {
            this.throwInternal();
            ch = 0;
        }
        if (ch == 0) {
            return false;
        }
        char[] attrBuffer = this._attrCollector.continueValue();
        if (ch >> 16 != 0) {
            ch -= 65536;
            if (this._elemNsPtr >= attrBuffer.length) {
                attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                this._nameBuffer = attrBuffer;
            }
            attrBuffer[this._elemNsPtr++] = (char)(0xD800 | ch >> 10);
            ch = 0xDC00 | ch & 0x3FF;
        }
        if (this._elemNsPtr >= attrBuffer.length) {
            attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            this._nameBuffer = attrBuffer;
        }
        attrBuffer[this._elemNsPtr++] = (char)ch;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final boolean handleDTDInternalSubset(boolean init) throws XMLStreamException {
        if (init) {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            this._elemAttrQuote = 0;
            this._inDtdDeclaration = false;
        } else {
            if (this._pendingInput != 0 && !this.handleAndAppendPending()) {
                return false;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
            outPtr = this._textBuilder.getCurrentLength();
        }
        TYPES = this._charTypes.DTD_CHARS;
        inputBuffer = this._inputBuffer;
        block13: while (this._inputPtr < this._inputEnd) {
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            if ((max2 = this._inputPtr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (this._inputPtr < max) {
                if (TYPES[c = inputBuffer[this._inputPtr++] & 255] == 0) {
                    outputBuffer[outPtr++] = (char)c;
                    continue;
                }
                switch (TYPES[c]) {
                    case 1: {
                        this.throwInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block13;
                        }
                        if (inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        ** GOTO lbl91
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl91
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c;
                            break block13;
                        }
                        c = this.decodeUtf8_2(c);
                        ** GOTO lbl91
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                            }
                            this._pendingInput = c;
                            break block13;
                        }
                        c = this.decodeUtf8_3(c);
                        ** GOTO lbl91
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    d = this._inputBuffer[this._inputPtr++] & 255;
                                    c |= d << 16;
                                }
                            }
                            this._pendingInput = c;
                            break block13;
                        }
                        c = this.decodeUtf8_4(c);
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        c = 56320 | c & 1023;
                        ** GOTO lbl91
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 8: {
                        if (this._elemAttrQuote == 0) {
                            this._elemAttrQuote = (byte)c;
                        } else if (this._elemAttrQuote == c) {
                            this._elemAttrQuote = 0;
                        }
                        ** GOTO lbl91
                    }
                    case 9: {
                        if (!this._inDtdDeclaration) {
                            this._inDtdDeclaration = true;
                        }
                        ** GOTO lbl91
                    }
                    case 10: {
                        if (this._elemAttrQuote == 0) {
                            this._inDtdDeclaration = false;
                        }
                        ** GOTO lbl91
                    }
                    case 11: {
                        if (!this._inDtdDeclaration && this._elemAttrQuote == 0) {
                            this._textBuilder.setCurrentLength(outPtr);
                            return true;
                        }
                    }
lbl91:
                    // 12 sources

                    default: {
                        outputBuffer[outPtr++] = (char)c;
                        continue block13;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parseCommentContents() throws XMLStreamException {
        if (this._pendingInput != 0 && (result = this.handleCommentPending()) != 0) {
            return result;
        }
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            if ((max2 = this._inputPtr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (this._inputPtr < max) {
                if (TYPES[c = inputBuffer[this._inputPtr++] & 255] == 0) {
                    outputBuffer[outPtr++] = (char)c;
                    continue;
                }
                switch (TYPES[c]) {
                    case 1: {
                        this.throwInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block10;
                        }
                        if (inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        ** GOTO lbl81
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl81
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_2(c);
                        ** GOTO lbl81
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                            }
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_3(c);
                        ** GOTO lbl81
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    d = this._inputBuffer[this._inputPtr++] & 255;
                                    c |= d << 16;
                                }
                            }
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_4(c);
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        c = 56320 | c & 1023;
                        ** GOTO lbl81
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -20;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 45) {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this._pendingInput = -21;
                                break block10;
                            }
                            if (this._inputBuffer[this._inputPtr++] != 62) {
                                this.reportDoubleHyphenInComments();
                            }
                            this._textBuilder.setCurrentLength(outPtr);
                            this._state = 0;
                            this._nextEvent = 257;
                            return 5;
                        }
                    }
lbl81:
                    // 8 sources

                    default: {
                        outputBuffer[outPtr++] = (char)c;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
        return 257;
    }

    protected final int handleCommentPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        if (this._pendingInput == -20) {
            if (this._inputBuffer[this._inputPtr] != 45) {
                this._pendingInput = 0;
                this._textBuilder.append("-");
                return 0;
            }
            ++this._inputPtr;
            this._pendingInput = -21;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
        }
        if (this._pendingInput == -21) {
            byte b;
            this._pendingInput = 0;
            if ((b = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportDoubleHyphenInComments();
            }
            this._state = 0;
            this._nextEvent = 257;
            return 5;
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parseCDataContents() throws XMLStreamException {
        if (this._pendingInput != 0 && (result = this.handleCDataPending()) != 0) {
            return result;
        }
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            if ((max2 = this._inputPtr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (this._inputPtr < max) {
                if (TYPES[c = inputBuffer[this._inputPtr++] & 255] == 0) {
                    outputBuffer[outPtr++] = (char)c;
                    continue;
                }
                switch (TYPES[c]) {
                    case 1: {
                        this.throwInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block10;
                        }
                        if (inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        ** GOTO lbl95
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl95
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_2(c);
                        ** GOTO lbl95
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                            }
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_3(c);
                        ** GOTO lbl95
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    d = this._inputBuffer[this._inputPtr++] & 255;
                                    c |= d << 16;
                                }
                            }
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_4(c);
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        c = 56320 | c & 1023;
                        ** GOTO lbl95
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 11: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -30;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 93) {
                            ++this._inputPtr;
                            while (true) {
                                if (this._inputPtr >= this._inputEnd) {
                                    this._pendingInput = -31;
                                    break block10;
                                }
                                if (this._inputBuffer[this._inputPtr] == 62) {
                                    ++this._inputPtr;
                                    this._textBuilder.setCurrentLength(outPtr);
                                    this._state = 0;
                                    this._nextEvent = 257;
                                    return 12;
                                }
                                if (this._inputBuffer[this._inputPtr] != 93) {
                                    outputBuffer[outPtr++] = 93;
                                    if (outPtr >= outputBuffer.length) {
                                        outputBuffer = this._textBuilder.finishCurrentSegment();
                                        outPtr = 0;
                                    }
                                    outputBuffer[outPtr++] = 93;
                                    continue block10;
                                }
                                ++this._inputPtr;
                                outputBuffer[outPtr++] = 93;
                                if (outPtr < outputBuffer.length) continue;
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                        }
                    }
lbl95:
                    // 8 sources

                    default: {
                        outputBuffer[outPtr++] = (char)c;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
        return 257;
    }

    protected final int handleCDataPending() throws XMLStreamException {
        if (this._pendingInput == -30) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if (this._inputBuffer[this._inputPtr] != 93) {
                this._textBuilder.append(']');
                this._pendingInput = 0;
                return 0;
            }
            ++this._inputPtr;
            this._pendingInput = -31;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
        }
        while (this._pendingInput == -31) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == 62) {
                this._pendingInput = 0;
                this._state = 0;
                this._nextEvent = 257;
                return 12;
            }
            if (b != 93) {
                --this._inputPtr;
                this._textBuilder.append("]]");
                this._pendingInput = 0;
                return 0;
            }
            this._textBuilder.append(']');
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parsePIData() throws XMLStreamException {
        if (this._pendingInput != 0 && (result = this.handlePIPending()) != 0) {
            return result;
        }
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            if ((max2 = this._inputPtr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (this._inputPtr < max) {
                if (TYPES[c = inputBuffer[this._inputPtr++] & 255] == 0) {
                    outputBuffer[outPtr++] = (char)c;
                    continue;
                }
                switch (TYPES[c]) {
                    case 1: {
                        this.throwInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block10;
                        }
                        if (inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        ** GOTO lbl76
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl76
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_2(c);
                        ** GOTO lbl76
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                            }
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_3(c);
                        ** GOTO lbl76
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    d = this._inputBuffer[this._inputPtr++] & 255;
                                    c |= d << 16;
                                }
                            }
                            this._pendingInput = c;
                            break block10;
                        }
                        c = this.decodeUtf8_4(c);
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        c = 56320 | c & 1023;
                        ** GOTO lbl76
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -15;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 62) {
                            ++this._inputPtr;
                            this._textBuilder.setCurrentLength(outPtr);
                            this._state = 0;
                            this._nextEvent = 257;
                            return 3;
                        }
                    }
lbl76:
                    // 8 sources

                    default: {
                        outputBuffer[outPtr++] = (char)c;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
        return 257;
    }

    protected final int handlePIPending() throws XMLStreamException {
        if (this._pendingInput == -15) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            byte b = this._inputBuffer[this._inputPtr];
            this._pendingInput = 0;
            if (b != 62) {
                this._textBuilder.append('?');
                return 0;
            }
            ++this._inputPtr;
            this._state = 0;
            this._nextEvent = 257;
            return 3;
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    protected final int decodeUtf8_2(int c) throws XMLStreamException {
        byte d;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    protected final void skipUtf8_2(int c) throws XMLStreamException {
        byte d;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    protected final int decodeUtf8_3(int c1) throws XMLStreamException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
            this.throwInvalidXmlChar(c);
        }
        return c;
    }

    protected final int decodeUtf8_3(int c1, int c2, int c3) throws XMLStreamException {
        if ((c2 & 0xC0) != 128) {
            this.reportInvalidOther(c2 & 0xFF, this._inputPtr - 1);
        }
        if ((c3 & 0xC0) != 128) {
            this.reportInvalidOther(c3 & 0xFF, this._inputPtr);
        }
        int c = (c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
            this.throwInvalidXmlChar(c);
        }
        return c;
    }

    protected final int decodeUtf8_4(int c) throws XMLStreamException {
        byte d;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected final int decodeUtf8_4(int c1, int c2, int c3, int c4) throws XMLStreamException {
        if ((c2 & 0xC0) != 128) {
            this.reportInvalidOther(c2 & 0xFF, this._inputPtr - 2);
        }
        int c = (c1 & 7) << 6 | c2 & 0x3F;
        if ((c3 & 0xC0) != 128) {
            this.reportInvalidOther(c3 & 0xFF, this._inputPtr - 1);
        }
        c = c << 6 | c3 & 0x3F;
        if ((c4 & 0xC0) != 128) {
            this.reportInvalidOther(c4 & 0xFF, this._inputPtr);
        }
        return (c << 6 | c4 & 0x3F) - 65536;
    }

    @Override
    protected final PName addPName(int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        return this.addUtfPName(this._charTypes, hash, quads, qlen, lastQuadBytes);
    }

    @Override
    protected void reportInvalidInitial(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    @Override
    protected void reportInvalidOther(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }
}

