/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.DataUtil;
import java.text.MessageFormat;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;

public final class AttributeCollector {
    private static final int INT_SPACE = 32;
    private static final int DEFAULT_ENTRY_COUNT = 12;
    private static final int DEFAULT_BUFFER_LENGTH = 120;
    final ReaderConfig _config;
    private int _attrCount;
    private PName[] _names = null;
    private char[] _valueBuffer = null;
    protected int[] _attrMap = null;
    protected int _hashAreaSize;
    protected int _spillAreaEnd;
    private int[] _valueOffsets = null;
    private boolean _needToResetValues = true;
    private String _errorMsg = null;
    private String _allAttrValues = null;

    protected AttributeCollector(ReaderConfig readerConfig) {
        this._config = readerConfig;
        this._attrCount = 0;
    }

    public char[] startNewValue(PName pName, int n) {
        int n2;
        if (this._needToResetValues) {
            this._needToResetValues = false;
            n2 = 0;
            this._attrCount = 0;
            this._allAttrValues = null;
            if (this._valueBuffer == null) {
                this._names = new PName[12];
                this._valueBuffer = new char[120];
                this._valueOffsets = new int[12];
            }
        } else {
            n2 = this._attrCount;
            if (n2 >= this._valueOffsets.length) {
                int[] nArray = this._valueOffsets;
                PName[] pNameArray = this._names;
                int n3 = nArray.length;
                int n4 = n3 + n3;
                this._valueOffsets = new int[n4];
                this._names = new PName[n4];
                for (int i = 0; i < n3; ++i) {
                    this._valueOffsets[i] = nArray[i];
                    this._names[i] = pNameArray[i];
                }
            }
            if (n2 > 0) {
                this._valueOffsets[n2 - 1] = n;
            }
        }
        this._names[n2] = pName;
        ++this._attrCount;
        return this._valueBuffer;
    }

    public char[] continueValue() {
        return this._valueBuffer;
    }

    public final int finishLastValue(int n) {
        if (this._needToResetValues) {
            return 0;
        }
        this._needToResetValues = true;
        int n2 = this._attrCount;
        this._valueOffsets[n2 - 1] = n;
        if (n2 < 3) {
            PName[] pNameArray;
            this._hashAreaSize = 0;
            if (n2 == 2 && (pNameArray = this._names)[0].boundEquals(pNameArray[1])) {
                this.noteDupAttr(0, 1);
                return -1;
            }
            return n2;
        }
        return this.finishLastValue2();
    }

    public final int finishLastValue2() {
        int n;
        int n2;
        int n3 = this._attrCount;
        PName[] pNameArray = this._names;
        int[] nArray = this._attrMap;
        int n4 = n3 + (n3 >> 2);
        for (n2 = 8; n2 < n4; n2 += n2) {
        }
        this._hashAreaSize = n2;
        n4 = n2 + (n2 >> 4);
        if (nArray == null || nArray.length < n4) {
            nArray = new int[n4];
        } else {
            nArray[7] = 0;
            nArray[6] = 0;
            nArray[5] = 0;
            nArray[4] = 0;
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
            for (n = 8; n < n2; ++n) {
                nArray[n] = 0;
            }
        }
        n4 = n2 - 1;
        n = n2;
        for (int i = 0; i < n3; ++i) {
            PName pName = pNameArray[i];
            int n5 = pName.boundHashCode();
            int n6 = n5 & n4;
            int n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = i + 1;
                continue;
            }
            if (pNameArray[--n7].boundEquals(pName) && this._errorMsg == null) {
                this.noteDupAttr(n7, i);
            }
            if (n + 1 >= nArray.length) {
                nArray = DataUtil.growArrayBy(nArray, 8);
            }
            for (int j = n2; j < n; j += 2) {
                if (nArray[j] != n5 || !pNameArray[n7 = nArray[j + 1]].boundEquals(pName)) continue;
                if (this._errorMsg != null) break;
                this.noteDupAttr(n7, i);
                break;
            }
            nArray[n++] = n5;
            nArray[n++] = i;
        }
        this._spillAreaEnd = n;
        this._attrMap = nArray;
        return this._errorMsg == null ? n3 : -1;
    }

    public char[] valueBufferFull() {
        this._valueBuffer = DataUtil.growArrayBy(this._valueBuffer, this._valueBuffer.length);
        return this._valueBuffer;
    }

    public final int getCount() {
        return this._attrCount;
    }

    public final PName getName(int n) {
        return this._names[n];
    }

    public final QName getQName(int n) {
        return this._names[n].constructQName();
    }

    public String getValue(int n) {
        int n2;
        int n3 = this._attrCount;
        if (this._allAttrValues == null) {
            n2 = this._valueOffsets[n3 - 1];
            String string = this._allAttrValues = n2 == 0 ? "" : new String(this._valueBuffer, 0, n2);
        }
        if (n == 0) {
            if (n3 == 1) {
                return this._allAttrValues;
            }
            n2 = this._valueOffsets[0];
            return n2 == 0 ? "" : this._allAttrValues.substring(0, n2);
        }
        n2 = this._valueOffsets[n - 1];
        int n4 = this._valueOffsets[n];
        return n2 == n4 ? "" : this._allAttrValues.substring(n2, n4);
    }

    public String getValue(String string, String string2) {
        int n = this.findIndex(string, string2);
        return n >= 0 ? this.getValue(n) : null;
    }

    public int findIndex(String string, String string2) {
        int n = this._hashAreaSize;
        if (n < 1) {
            int n2 = this._attrCount;
            for (int i = 0; i < n2; ++i) {
                PName pName = this._names[i];
                if (!pName.boundEquals(string, string2)) continue;
                return i;
            }
            return -1;
        }
        int n3 = PName.boundHashCode(string, string2);
        int n4 = this._attrMap[n3 & n - 1];
        if (n4 > 0) {
            if (this._names[--n4].boundEquals(string, string2)) {
                return n4;
            }
            int n5 = this._spillAreaEnd;
            for (int i = n; i < n5; i += 2) {
                if (this._attrMap[i] != n3 || !this._names[n4 = this._attrMap[i + 1]].boundEquals(string, string2)) continue;
                return n4;
            }
        }
        return -1;
    }

    public String getErrorMsg() {
        return this._errorMsg;
    }

    public final void decodeValue(int n, TypedValueDecoder typedValueDecoder) throws IllegalArgumentException {
        int n2;
        int n3;
        if (n < 0 || n >= this._attrCount) {
            throw new IllegalArgumentException("Invalid index " + n + "; current element has only " + this._attrCount + " attributes");
        }
        if (n == 0) {
            n3 = 0;
            n2 = this._valueOffsets[0];
        } else {
            n3 = this._valueOffsets[n - 1];
            n2 = this._valueOffsets[n];
        }
        char[] cArray = this._valueBuffer;
        while (true) {
            if (n3 >= n2) {
                typedValueDecoder.handleEmptyValue();
                return;
            }
            if (!AttributeCollector.isSpace(cArray[n3])) break;
            ++n3;
        }
        while (--n2 > n3 && AttributeCollector.isSpace(cArray[n2])) {
        }
        typedValueDecoder.decode(cArray, n3, n2 + 1);
    }

    public final int decodeValues(int n, TypedArrayDecoder typedArrayDecoder, XmlScanner xmlScanner) throws XMLStreamException {
        int n2;
        int n3;
        if (n < 0 || n >= this._attrCount) {
            throw new IllegalArgumentException("Invalid index " + n + "; current element has only " + this._attrCount + " attributes");
        }
        if (n == 0) {
            n3 = 0;
            n2 = this._valueOffsets[0];
        } else {
            n3 = this._valueOffsets[n - 1];
            n2 = this._valueOffsets[n];
        }
        return this.decodeValues(typedArrayDecoder, this._valueBuffer, n3, n2, xmlScanner);
    }

    private final int decodeValues(TypedArrayDecoder typedArrayDecoder, char[] cArray, int n, int n2, XmlScanner xmlScanner) throws XMLStreamException {
        int n3;
        block5: {
            int n4 = n;
            n3 = 0;
            try {
                while (n < n2) {
                    while (cArray[n] <= ' ') {
                        if (++n < n2) continue;
                        break block5;
                    }
                    n4 = n++;
                    while (n < n2 && cArray[n] > ' ') {
                        ++n;
                    }
                    int n5 = n++;
                    ++n3;
                    if (!typedArrayDecoder.decodeValue(cArray, n4, n5) || this.checkExpand(typedArrayDecoder)) continue;
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                XMLStreamLocation2 xMLStreamLocation2 = xmlScanner.getCurrentLocation();
                String string = new String(cArray, n4, n - n4);
                throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), (Location)xMLStreamLocation2, illegalArgumentException);
            }
        }
        return n3;
    }

    public byte[] decodeBinaryValue(int n, Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, XmlScanner xmlScanner) throws XMLStreamException {
        int n2;
        int n3;
        if (n < 0 || n >= this._attrCount) {
            throw new IllegalArgumentException("Invalid index " + n + "; current element has only " + this._attrCount + " attributes");
        }
        if (n == 0) {
            n3 = 0;
            n2 = this._valueOffsets[0];
        } else {
            n3 = this._valueOffsets[n - 1];
            n2 = this._valueOffsets[n];
        }
        int n4 = n2 - n3;
        charArrayBase64Decoder.init(base64Variant, true, this._valueBuffer, n3, n2, null);
        try {
            return charArrayBase64Decoder.decodeCompletely();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = new String(this._valueBuffer, n3, n4);
            throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), (Location)xmlScanner.getCurrentLocation(), illegalArgumentException);
        }
    }

    private static final boolean isSpace(char c) {
        return c <= ' ';
    }

    private final boolean checkExpand(TypedArrayDecoder typedArrayDecoder) {
        if (typedArrayDecoder instanceof ValueDecoderFactory.BaseArrayDecoder) {
            ((ValueDecoderFactory.BaseArrayDecoder)typedArrayDecoder).expand();
            return true;
        }
        return false;
    }

    private void noteDupAttr(int n, int n2) {
        this._errorMsg = MessageFormat.format(ErrorConsts.ERR_WF_DUP_ATTRS, this._names[n].toString(), new Integer(n), this._names[n2].toString(), new Integer(n2));
    }
}

