/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.util.XmlCharTypes;

public final class InputCharTypes
extends XmlCharTypes {
    public static final int CT_INPUT_NAME_MB_N = 4;
    public static final int CT_INPUT_NAME_MB_2 = 5;
    public static final int CT_INPUT_NAME_MB_3 = 6;
    public static final int CT_INPUT_NAME_MB_4 = 7;
    private static XmlCharTypes sAsciiCharTypes = null;
    private static XmlCharTypes sLatin1CharTypes = null;
    private static final XmlCharTypes sUtf8CharTypes = new XmlCharTypes();

    public static final XmlCharTypes getUtf8CharTypes() {
        return sUtf8CharTypes;
    }

    public static final synchronized XmlCharTypes getAsciiCharTypes() {
        if (sAsciiCharTypes == null) {
            sAsciiCharTypes = new XmlCharTypes();
            InputCharTypes.fillInLatin1Chars(InputCharTypes.sAsciiCharTypes.TEXT_CHARS, InputCharTypes.sAsciiCharTypes.ATTR_CHARS, InputCharTypes.sAsciiCharTypes.NAME_CHARS, InputCharTypes.sAsciiCharTypes.DTD_CHARS, InputCharTypes.sAsciiCharTypes.OTHER_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.TEXT_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.ATTR_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.NAME_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.DTD_CHARS);
            InputCharTypes.fillInIllegalAsciiRange(InputCharTypes.sAsciiCharTypes.OTHER_CHARS);
        }
        return sAsciiCharTypes;
    }

    public static final synchronized XmlCharTypes getLatin1CharTypes() {
        if (sLatin1CharTypes == null) {
            sLatin1CharTypes = new XmlCharTypes();
            InputCharTypes.fillInLatin1Chars(InputCharTypes.sLatin1CharTypes.TEXT_CHARS, InputCharTypes.sLatin1CharTypes.ATTR_CHARS, InputCharTypes.sLatin1CharTypes.NAME_CHARS, InputCharTypes.sLatin1CharTypes.DTD_CHARS, InputCharTypes.sLatin1CharTypes.OTHER_CHARS);
        }
        return sLatin1CharTypes;
    }

    public static void fillInUtf8Chars(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        InputCharTypes.fillIn8BitTextRange(nArray);
        InputCharTypes.fillInMultiByteTextRange(nArray);
        InputCharTypes.fillIn8BitAttrRange(nArray2);
        InputCharTypes.fillInMultiByteTextRange(nArray2);
        InputCharTypes.fillIn8BitNameRange(nArray3);
        InputCharTypes.fillInMultiByteNameRange(nArray3);
        InputCharTypes.fillIn8BitDtdRange(nArray4);
        InputCharTypes.fillInMultiByteTextRange(nArray4);
        nArray5[93] = 11;
        nArray5[62] = 17;
        InputCharTypes.fillIn8BitTextRange(nArray5);
        InputCharTypes.fillInMultiByteTextRange(nArray5);
        nArray5[38] = 0;
        nArray5[60] = 0;
        nArray5[93] = 11;
        nArray5[63] = 12;
        nArray5[45] = 13;
    }

    private static void fillInMultiByteTextRange(int[] nArray) {
        for (int i = 128; i < 256; ++i) {
            int n = (i & 0xE0) == 192 ? 5 : ((i & 0xF0) == 224 ? 6 : ((i & 0xF8) == 240 ? 7 : 1));
            nArray[i] = n;
        }
    }

    private static void fillInMultiByteNameRange(int[] nArray) {
        for (int i = 128; i < 256; ++i) {
            int n = (i & 0xE0) == 192 ? 5 : ((i & 0xF0) == 224 ? 6 : ((i & 0xF8) == 240 ? 7 : 1));
            nArray[i] = n;
        }
    }

    protected static void fillInIllegalAsciiRange(int[] nArray) {
        for (int i = 128; i <= 255; ++i) {
            nArray[i] = 1;
        }
    }

    static {
        InputCharTypes.fillInUtf8Chars(InputCharTypes.sUtf8CharTypes.TEXT_CHARS, InputCharTypes.sUtf8CharTypes.ATTR_CHARS, InputCharTypes.sUtf8CharTypes.NAME_CHARS, InputCharTypes.sUtf8CharTypes.DTD_CHARS, InputCharTypes.sUtf8CharTypes.OTHER_CHARS);
    }
}

