/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.ReaderConfig;
import java.io.IOException;
import java.io.InputStream;

public final class MergedStream
extends InputStream {
    final ReaderConfig mConfig;
    final InputStream mIn;
    byte[] mData;
    int mPtr;
    final int mEnd;

    public MergedStream(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n, int n2) {
        this.mConfig = readerConfig;
        this.mIn = inputStream;
        this.mData = byArray;
        this.mPtr = n;
        this.mEnd = n2;
    }

    @Override
    public int available() throws IOException {
        if (this.mData != null) {
            return this.mEnd - this.mPtr;
        }
        return this.mIn.available();
    }

    @Override
    public void close() throws IOException {
        this.freeBuffers();
        this.mIn.close();
    }

    @Override
    public void mark(int n) {
        if (this.mData == null) {
            this.mIn.mark(n);
        }
    }

    @Override
    public boolean markSupported() {
        return this.mData == null && this.mIn.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.mData != null) {
            int n = this.mData[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeBuffers();
            }
            return n;
        }
        return this.mIn.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mData != null) {
            int n3 = this.mEnd - this.mPtr;
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.mData, this.mPtr, byArray, n, n2);
            this.mPtr += n2;
            if (this.mPtr >= this.mEnd) {
                this.freeBuffers();
            }
            return n2;
        }
        return this.mIn.read(byArray, n, n2);
    }

    @Override
    public void reset() throws IOException {
        if (this.mData == null) {
            this.mIn.reset();
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (this.mData != null) {
            int n = this.mEnd - this.mPtr;
            if ((long)n > l) {
                this.mPtr += (int)l;
                return l;
            }
            this.freeBuffers();
            l2 += (long)n;
            l -= (long)n;
        }
        if (l > 0L) {
            l2 += this.mIn.skip(l);
        }
        return l2;
    }

    private void freeBuffers() {
        if (this.mData != null) {
            byte[] byArray = this.mData;
            this.mData = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(byArray);
            }
        }
    }
}

