/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.ReaderConfig;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class Utf32Reader
extends Reader {
    static final char NULL_CHAR = '\u0000';
    final ReaderConfig mConfig;
    protected InputStream mIn;
    protected byte[] mBuffer;
    protected int mPtr;
    protected int mLength;
    final boolean mBigEndian;
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;
    char[] mTmpBuf = null;

    public Utf32Reader(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) {
        this.mConfig = readerConfig;
        this.mBigEndian = bl;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.mIn;
        if (inputStream != null) {
            this.mIn = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (n2 < 1) {
            return n2;
        }
        if (n < 0 || n + n2 > cArray.length) {
            this.reportBounds(cArray, n, n2);
        }
        n2 += n;
        int n3 = n;
        if (this.mSurrogate != '\u0000') {
            cArray[n3++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int n4 = this.mLength - this.mPtr;
            if (n4 < 4 && !this.loadMore(n4)) {
                return -1;
            }
        }
        byte[] byArray = this.mBuffer;
        while (n3 < n2) {
            int n5 = this.mPtr;
            int n6 = this.mBigEndian ? byArray[n5] << 24 | (byArray[n5 + 1] & 0xFF) << 16 | (byArray[n5 + 2] & 0xFF) << 8 | byArray[n5 + 3] & 0xFF : byArray[n5] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8 | (byArray[n5 + 2] & 0xFF) << 16 | byArray[n5 + 3] << 24;
            this.mPtr += 4;
            if (n6 >= 55296) {
                if (n6 > 0x10FFFF) {
                    this.reportInvalid(n6, n3 - n, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                if (n6 > 65535) {
                    cArray[n3++] = (char)(55296 + ((n6 -= 65536) >> 10));
                    n6 = 0xDC00 | n6 & 0x3FF;
                    if (n3 >= n2) {
                        this.mSurrogate = (char)n6;
                        break;
                    }
                } else if (n6 < 57344) {
                    this.reportInvalid(n6, n3 - n, "(a surrogate char) ");
                } else if (n6 >= 65534) {
                    this.reportInvalid(n6, n3 - n, "");
                }
            }
            cArray[n3++] = (char)n6;
            if (this.mPtr < this.mLength) continue;
            break;
        }
        n2 = n3 - n;
        this.mCharCount += n2;
        return n2;
    }

    private boolean loadMore(int n) throws IOException {
        int n2;
        this.mByteCount += this.mLength - n;
        if (n > 0) {
            if (this.mPtr > 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    this.mBuffer[n2] = this.mBuffer[this.mPtr + n2];
                }
                this.mPtr = 0;
            }
            this.mLength = n;
        } else {
            this.mPtr = 0;
            n2 = this.mIn.read(this.mBuffer);
            if (n2 < 1) {
                this.mLength = 0;
                if (n2 < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this.mLength = n2;
        }
        while (this.mLength < 4) {
            n2 = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (n2 < 1) {
                if (n2 < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this.mLength, 4);
                }
                this.reportStrangeStream();
            }
            this.mLength += n2;
        }
        return true;
    }

    public final void freeBuffers() {
        byte[] byArray = this.mBuffer;
        if (byArray != null) {
            this.mBuffer = null;
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(byArray);
            }
        }
    }

    private void reportUnexpectedEOF(int n, int n2) throws IOException {
        int n3 = this.mByteCount + n;
        int n4 = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n + ", needed " + n2 + ", at char #" + n4 + ", byte #" + n3 + ")");
    }

    private void reportInvalid(int n, int n2, String string) throws IOException {
        int n3 = this.mByteCount + this.mPtr - 1;
        int n4 = this.mCharCount + n2;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n) + string + " at char #" + n4 + ", byte #" + n3 + ")");
    }

    protected void reportBounds(char[] cArray, int n, int n2) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n + "," + n2 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

