/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import com.fasterxml.aalto.util.XmlConsts;
import java.io.OutputStreamWriter;
import java.io.Writer;

public final class CharsetNames
implements XmlConsts {
    public static final String CS_US_ASCII = "US-ASCII";
    public static final String CS_UTF8 = "UTF-8";
    public static final String CS_UTF16 = "UTF-16";
    public static final String CS_UTF16BE = "UTF-16BE";
    public static final String CS_UTF16LE = "UTF-16LE";
    public static final String CS_UTF32 = "UTF-32";
    public static final String CS_UTF32BE = "UTF-32BE";
    public static final String CS_UTF32LE = "UTF-32LE";
    public static final String CS_ISO_LATIN1 = "ISO-8859-1";
    public static final String CS_SHIFT_JIS = "Shift_JIS";
    public static final String CS_EBCDIC = "EBCDIC";
    private static final int EOS = 65536;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String normalize(String string) {
        int n;
        if (string == null || string.length() < 3) {
            return string;
        }
        boolean bl = false;
        char c = string.charAt(0);
        if (!(c != 'c' && c != 'C' || (n = string.charAt(1)) != 115 && n != 83)) {
            string = string.substring(2);
            c = string.charAt(0);
            bl = true;
        }
        switch (c) {
            case 'A': 
            case 'a': {
                if (string != "ASCII" && !CharsetNames.equalEncodings(string, "ASCII")) return string;
                return CS_US_ASCII;
            }
            case 'C': 
            case 'c': {
                if (!CharsetNames.encodingStartsWith(string, "cs")) return string;
                return string;
            }
            case 'E': 
            case 'e': {
                if (!string.startsWith(CS_EBCDIC) && !string.startsWith("ebcdic")) return string;
                return CS_EBCDIC;
            }
            case 'I': 
            case 'i': {
                if (string == CS_ISO_LATIN1 || CharsetNames.equalEncodings(string, CS_ISO_LATIN1) || CharsetNames.equalEncodings(string, "ISO-Latin1")) {
                    return CS_ISO_LATIN1;
                }
                if (!CharsetNames.encodingStartsWith(string, "ISO-10646")) return string;
                n = string.indexOf("10646");
                String string2 = string.substring(n + 5);
                if (CharsetNames.equalEncodings(string2, "UCS-Basic")) {
                    return CS_US_ASCII;
                }
                if (CharsetNames.equalEncodings(string2, "Unicode-Latin1")) {
                    return CS_ISO_LATIN1;
                }
                if (CharsetNames.equalEncodings(string2, "UCS-2")) {
                    return CS_UTF16;
                }
                if (CharsetNames.equalEncodings(string2, "UCS-4")) {
                    return CS_UTF32;
                }
                if (CharsetNames.equalEncodings(string2, "UTF-1")) {
                    return CS_US_ASCII;
                }
                if (CharsetNames.equalEncodings(string2, "J-1")) {
                    return CS_US_ASCII;
                }
                if (!CharsetNames.equalEncodings(string2, CS_US_ASCII)) return string;
                return CS_US_ASCII;
            }
            case 'J': 
            case 'j': {
                if (!CharsetNames.equalEncodings(string, "JIS_Encoding")) return string;
                return CS_SHIFT_JIS;
            }
            case 'S': 
            case 's': {
                if (!CharsetNames.equalEncodings(string, CS_SHIFT_JIS)) return string;
                return CS_SHIFT_JIS;
            }
            case 'U': 
            case 'u': {
                if (string.length() < 2) return string;
                switch (string.charAt(1)) {
                    case 'C': 
                    case 'c': {
                        if (CharsetNames.equalEncodings(string, "UCS-2")) {
                            return CS_UTF16;
                        }
                        if (!CharsetNames.equalEncodings(string, "UCS-4")) return string;
                        return CS_UTF32;
                    }
                    case 'N': 
                    case 'n': {
                        if (!bl) return string;
                        if (CharsetNames.equalEncodings(string, "Unicode")) {
                            return CS_UTF16;
                        }
                        if (CharsetNames.equalEncodings(string, "UnicodeAscii")) {
                            return CS_ISO_LATIN1;
                        }
                        if (!CharsetNames.equalEncodings(string, "UnicodeAscii")) return string;
                        return CS_US_ASCII;
                    }
                    case 'S': 
                    case 's': {
                        if (!CharsetNames.equalEncodings(string, CS_US_ASCII)) return string;
                        return CS_US_ASCII;
                    }
                    case 'T': 
                    case 't': {
                        if (string == CS_UTF8 || CharsetNames.equalEncodings(string, CS_UTF8)) {
                            return CS_UTF8;
                        }
                        if (CharsetNames.equalEncodings(string, CS_UTF16BE)) {
                            return CS_UTF16BE;
                        }
                        if (CharsetNames.equalEncodings(string, CS_UTF16LE)) {
                            return CS_UTF16LE;
                        }
                        if (CharsetNames.equalEncodings(string, CS_UTF16)) {
                            return CS_UTF16;
                        }
                        if (CharsetNames.equalEncodings(string, CS_UTF32BE)) {
                            return CS_UTF32BE;
                        }
                        if (CharsetNames.equalEncodings(string, CS_UTF32LE)) {
                            return CS_UTF32LE;
                        }
                        if (CharsetNames.equalEncodings(string, CS_UTF32)) {
                            return CS_UTF32;
                        }
                        if (!CharsetNames.equalEncodings(string, "UTF")) return string;
                        return CS_UTF16;
                    }
                }
            }
        }
        return string;
    }

    public static String findEncodingFor(Writer writer) {
        if (writer instanceof OutputStreamWriter) {
            String string = ((OutputStreamWriter)writer).getEncoding();
            return CharsetNames.normalize(string);
        }
        return null;
    }

    public static boolean equalEncodings(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n || n4 < n2) {
            int n5;
            int n6 = n3 >= n ? 65536 : (int)string.charAt(n3++);
            if (n6 == (n5 = n4 >= n2 ? 65536 : (int)string2.charAt(n4++))) continue;
            while (n6 <= 32 || n6 == 95 || n6 == 45) {
                n6 = n3 >= n ? 65536 : (int)string.charAt(n3++);
            }
            while (n5 <= 32 || n5 == 95 || n5 == 45) {
                n5 = n4 >= n2 ? 65536 : (int)string2.charAt(n4++);
            }
            if (n6 == n5) continue;
            if (n6 == 65536 || n5 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)n6) == Character.toLowerCase((char)n5)) continue;
            return false;
        }
        return true;
    }

    public static boolean encodingStartsWith(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n || n4 < n2) {
            int n5;
            int n6 = n3 >= n ? 65536 : (int)string.charAt(n3++);
            if (n6 == (n5 = n4 >= n2 ? 65536 : (int)string2.charAt(n4++))) continue;
            while (n6 <= 32 || n6 == 95 || n6 == 45) {
                n6 = n3 >= n ? 65536 : (int)string.charAt(n3++);
            }
            while (n5 <= 32 || n5 == 95 || n5 == 45) {
                n5 = n4 >= n2 ? 65536 : (int)string2.charAt(n4++);
            }
            if (n6 == n5) continue;
            if (n5 == 65536) {
                return true;
            }
            if (n6 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)n6) == Character.toLowerCase((char)n5)) continue;
            return false;
        }
        return true;
    }
}

