/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import com.fasterxml.aalto.in.ReaderConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class TextBuilder {
    static final char[] sNoChars = new char[0];
    static final int DEF_INITIAL_BUFFER_SIZE = 500;
    static final int MAX_SEGMENT_LENGTH = 262144;
    static final int INT_SPACE = 32;
    private final ReaderConfig _config;
    private ArrayList<char[]> _segments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;
    private int _resultLen;
    private char[] _decodeBuffer;
    private int _decodePtr;
    private int _decodeEnd;
    private boolean _isIndentation = false;
    public static final int MAX_INDENT_SPACES = 32;
    public static final int MAX_INDENT_TABS = 8;
    private static final String sIndSpaces = "\n                                 ";
    private static final char[] sIndSpacesArray = "\n                                 ".toCharArray();
    private static final String[] sIndSpacesStrings = new String[sIndSpacesArray.length];
    private static final String sIndTabs = "\n\t\t\t\t\t\t\t\t\t";
    private static final char[] sIndTabsArray = "\n\t\t\t\t\t\t\t\t\t".toCharArray();
    private static final String[] sIndTabsStrings = new String[sIndTabsArray.length];

    private TextBuilder(ReaderConfig readerConfig) {
        this._config = readerConfig;
    }

    public static TextBuilder createRecyclableBuffer(ReaderConfig readerConfig) {
        return new TextBuilder(readerConfig);
    }

    public void recycle(boolean bl) {
        if (this._config != null && this._currentSegment != null) {
            if (bl) {
                this._resultString = null;
                this._resultArray = null;
            } else if (this._segmentSize + this._currentSize > 0) {
                return;
            }
            if (this._segments != null && this._segments.size() > 0) {
                this._segments.clear();
                this._segmentSize = 0;
            }
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._config.freeMediumCBuffer(cArray);
        }
    }

    public char[] resetWithEmpty() {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 0;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(0);
        }
        return this._currentSegment;
    }

    public void resetWithIndentation(int n, char c) {
        String string;
        int n2;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = -1;
        this._isIndentation = true;
        this._resultLen = n2 = n + 1;
        if (c == '\t') {
            this._resultArray = sIndTabsArray;
            string = sIndTabsStrings[n];
            if (string == null) {
                TextBuilder.sIndTabsStrings[n] = string = sIndTabs.substring(0, n2);
            }
        } else {
            this._resultArray = sIndSpacesArray;
            string = sIndSpacesStrings[n];
            if (string == null) {
                TextBuilder.sIndSpacesStrings[n] = string = sIndSpaces.substring(0, n2);
            }
        }
        this._resultString = string;
    }

    public void resetWithChar(char c) {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 1;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(1);
        }
        this._currentSegment[0] = c;
    }

    public void resetWithSurrogate(int n) {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 2;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(2);
        }
        this._currentSegment[0] = (char)(0xD800 | n >> 10);
        this._currentSegment[1] = (char)(0xDC00 | n & 0x3FF);
    }

    public char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    public int size() {
        int n = this._currentSize;
        if (n < 0) {
            return this._resultLen;
        }
        return n + this._segmentSize;
    }

    public char[] getTextBuffer() {
        if (this._segments == null || this._segments.size() == 0) {
            if (this._resultArray != null) {
                return this._resultArray;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else {
                int n = this._segmentSize;
                int n2 = this._currentSize;
                if (n == 0) {
                    this._resultString = n2 == 0 ? "" : new String(this._currentSegment, 0, n2);
                    return this._resultString;
                }
                StringBuilder stringBuilder = new StringBuilder(n + n2);
                if (this._segments != null) {
                    int n3 = this._segments.size();
                    for (int i = 0; i < n3; ++i) {
                        char[] cArray = this._segments.get(i);
                        stringBuilder.append(cArray, 0, cArray.length);
                    }
                }
                stringBuilder.append(this._currentSegment, 0, n2);
                this._resultString = stringBuilder.toString();
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (cArray == null) {
            this._resultArray = cArray = this.buildResultArray();
        }
        return cArray;
    }

    public int contentsToArray(int n, char[] cArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        if (this._segments != null) {
            int n6 = this._segments.size();
            for (n4 = 0; n4 < n6; ++n4) {
                char[] cArray2 = this._segments.get(n4);
                int n7 = cArray2.length;
                int n8 = n7 - n;
                if (n8 < 1) {
                    n -= n7;
                    continue;
                }
                if (n8 >= n3) {
                    System.arraycopy(cArray2, n, cArray, n2, n3);
                    return n5 + n3;
                }
                System.arraycopy(cArray2, n, cArray, n2, n8);
                n5 += n8;
                n2 += n8;
                n3 -= n8;
                n = 0;
            }
        }
        if (n3 > 0) {
            n4 = this._currentSize - n;
            if (n3 > n4) {
                n3 = n4;
            }
            if (n3 > 0) {
                System.arraycopy(this._currentSegment, n, cArray, n2, n3);
                n5 += n3;
            }
        }
        return n5;
    }

    public int rawContentsTo(Writer writer) throws IOException {
        if (this._resultArray != null) {
            writer.write(this._resultArray);
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            writer.write(this._resultString);
            return this._resultString.length();
        }
        int n = 0;
        if (this._segments != null) {
            int n2 = this._segments.size();
            for (int i = 0; i < n2; ++i) {
                char[] cArray = this._segments.get(i);
                writer.write(cArray);
                n += cArray.length;
            }
        }
        if (this._currentSize > 0) {
            writer.write(this._currentSegment, 0, this._currentSize);
            n += this._currentSize;
        }
        return n;
    }

    public boolean isAllWhitespace() {
        int n;
        if (this._isIndentation) {
            return true;
        }
        if (this._segments != null) {
            n = this._segments.size();
            for (int i = 0; i < n; ++i) {
                char[] cArray = this._segments.get(i);
                int n2 = cArray.length;
                for (int j = 0; j < n2; ++j) {
                    if (cArray[j] <= ' ') continue;
                    return false;
                }
            }
        }
        char[] cArray = this._currentSegment;
        int n3 = this._currentSize;
        for (n = 0; n < n3; ++n) {
            if (cArray[n] <= ' ') continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String string) {
        int n = this._segments == null ? 0 : this._segments.size();
        int n2 = string.length() - 1;
        char[] cArray = this._currentSegment;
        int n3 = this._currentSize - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) != cArray[n3]) {
                return false;
            }
            if (--n2 == 0) break;
            if (--n3 >= 0) continue;
            if (--n < 0) {
                return false;
            }
            cArray = this._segments.get(n);
            n3 = cArray.length - 1;
        }
        return true;
    }

    public boolean equalsString(String string) {
        int n = string.length();
        if (n != this.size()) {
            return false;
        }
        char[] cArray = this._segments == null || this._segments.size() == 0 ? this._currentSegment : this.contentsAsArray();
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public void fireSaxCharacterEvents(ContentHandler contentHandler) throws SAXException {
        if (this._resultArray != null) {
            contentHandler.characters(this._resultArray, 0, this._resultLen);
        } else {
            if (this._segments != null) {
                int n = this._segments.size();
                for (int i = 0; i < n; ++i) {
                    char[] cArray = this._segments.get(i);
                    contentHandler.characters(cArray, 0, cArray.length);
                }
            }
            if (this._currentSize > 0) {
                contentHandler.characters(this._currentSegment, 0, this._currentSize);
            }
        }
    }

    public void fireSaxSpaceEvents(ContentHandler contentHandler) throws SAXException {
        if (this._resultArray != null) {
            contentHandler.ignorableWhitespace(this._resultArray, 0, this._resultLen);
        } else {
            if (this._segments != null) {
                int n = this._segments.size();
                for (int i = 0; i < n; ++i) {
                    char[] cArray = this._segments.get(i);
                    contentHandler.ignorableWhitespace(cArray, 0, cArray.length);
                }
            }
            if (this._currentSize > 0) {
                contentHandler.ignorableWhitespace(this._currentSegment, 0, this._currentSize);
            }
        }
    }

    public void fireSaxCommentEvent(LexicalHandler lexicalHandler) throws SAXException {
        if (this._resultArray != null) {
            lexicalHandler.comment(this._resultArray, 0, this._resultLen);
        } else if (this._segments != null && this._segments.size() > 0) {
            char[] cArray = this.contentsAsArray();
            lexicalHandler.comment(cArray, 0, cArray.length);
        } else {
            lexicalHandler.comment(this._currentSegment, 0, this._currentSize);
        }
    }

    public void append(char c) {
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
        }
        cArray[this._currentSize++] = c;
    }

    public void appendSurrogate(int n) {
        this.append((char)(0xD800 | n >> 10));
        this.append((char)(0xDC00 | n & 0x3FF));
    }

    public void append(char[] cArray, int n, int n2) {
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n3 = cArray2.length - this._currentSize;
        if (n3 >= n2) {
            System.arraycopy(cArray, n, cArray2, this._currentSize, n2);
            this._currentSize += n2;
        } else {
            if (n3 > 0) {
                System.arraycopy(cArray, n, cArray2, this._currentSize, n3);
                n += n3;
                n2 -= n3;
            }
            this.expand(n2);
            System.arraycopy(cArray, n, this._currentSegment, 0, n2);
            this._currentSize = n2;
        }
    }

    public void append(String string) {
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n = cArray.length - this._currentSize;
        int n2 = string.length();
        if (n >= n2) {
            string.getChars(0, n2, cArray, this._currentSize);
            this._currentSize += n2;
        } else {
            if (n > 0) {
                string.getChars(0, n, cArray, this._currentSize);
                n2 -= n;
            }
            this.expand(n2);
            string.getChars(n, n + n2, this._currentSegment, 0);
            this._currentSize = n2;
        }
    }

    public int getCurrentLength() {
        return this._currentSize;
    }

    public void setCurrentLength(int n) {
        this._currentSize = n;
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._segments.add(this._currentSegment);
        int n = this._currentSegment.length;
        this._segmentSize += n;
        char[] cArray = new char[this.calcNewSize(n)];
        this._currentSize = 0;
        this._currentSegment = cArray;
        return cArray;
    }

    private int calcNewSize(int n) {
        int n2 = n < 8000 ? n : n >> 1;
        int n3 = n + n2;
        return Math.min(n3, 262144);
    }

    public int decodeElements(TypedArrayDecoder typedArrayDecoder, boolean bl) throws TypedXMLStreamException {
        if (bl) {
            this.resetForDecode();
        }
        int n = this._decodePtr;
        char[] cArray = this._decodeBuffer;
        int n2 = 0;
        int n3 = n;
        try {
            int n4 = this._decodeEnd;
            block2: while (n < n4) {
                int n5;
                while (cArray[n] <= ' ') {
                    if (++n < n4) continue;
                    break block2;
                }
                n3 = n++;
                while (n < n4 && cArray[n] > ' ') {
                    ++n;
                }
                ++n2;
                if (typedArrayDecoder.decodeValue(cArray, n3, n5 = n++)) break;
                this._decodePtr = n;
            }
            this._decodePtr = n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = new String(cArray, n3, n - n3 - 1);
            throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        return n2;
    }

    public void resetForBinaryDecode(Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, boolean bl) {
        if ((this._segments == null || this._segments.size() == 0) && this._isIndentation) {
            charArrayBase64Decoder.init(base64Variant, bl, this._resultArray, 0, this._resultArray.length, null);
            return;
        }
        charArrayBase64Decoder.init(base64Variant, bl, this._currentSegment, 0, this._currentSize, this._segments);
    }

    private final void resetForDecode() {
        this._decodePtr = 0;
        if (this._segments == null || this._segments.size() == 0) {
            if (this._isIndentation) {
                this._decodeBuffer = this._resultArray;
                this._decodeEnd = this._resultArray.length;
            } else {
                this._decodeBuffer = this._currentSegment;
                this._decodeEnd = this._currentSize;
            }
        } else {
            this._decodeBuffer = this.contentsAsArray();
            this._decodeEnd = this._decodeBuffer.length;
        }
    }

    public String toString() {
        this._resultString = null;
        this._resultArray = null;
        return this.contentsAsString();
    }

    private final char[] allocBuffer(int n) {
        int n2 = Math.max(500, n);
        char[] cArray = null;
        if (this._config != null && (cArray = this._config.allocMediumCBuffer(n2)) != null) {
            return cArray;
        }
        return new char[n2];
    }

    private void expand(int n) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._segments.add(cArray);
        int n2 = cArray.length;
        this._segmentSize += n2;
        int n3 = Math.max(n, this.calcNewSize(n2));
        cArray = new char[n3];
        this._currentSize = 0;
        this._currentSegment = cArray;
    }

    private char[] buildResultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        int n = this.size();
        if (n < 1) {
            return sNoChars;
        }
        int n2 = 0;
        char[] cArray = new char[n];
        if (this._segments != null) {
            int n3 = this._segments.size();
            for (int i = 0; i < n3; ++i) {
                char[] cArray2 = this._segments.get(i);
                int n4 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n2, n4);
                n2 += n4;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n2, this._currentSize);
        return cArray;
    }
}

