/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamReader2;

public class TestStreamReader
implements XMLStreamConstants {
    protected TestStreamReader() {
    }

    protected XMLInputFactory getFactory() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.fasterxml.aalto.stax.InputFactoryImpl");
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        System.out.println("Factory instance: " + xMLInputFactory.getClass());
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return xMLInputFactory;
    }

    protected int test(File file) throws Exception {
        XMLInputFactory xMLInputFactory = this.getFactory();
        System.out.print("Coalesce: " + xMLInputFactory.getProperty("javax.xml.stream.isCoalescing"));
        System.out.println(", NS-aware: " + xMLInputFactory.getProperty("javax.xml.stream.isNamespaceAware"));
        System.out.print("Entity-expanding: " + xMLInputFactory.getProperty("javax.xml.stream.isReplacingEntityReferences"));
        System.out.println(", validating: " + xMLInputFactory.getProperty("javax.xml.stream.isValidating"));
        int n = 0;
        XMLStreamReader2 xMLStreamReader2 = (XMLStreamReader2)xMLInputFactory.createXMLStreamReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        System.out.println("SR; name interning: " + xMLStreamReader2.getProperty("org.codehaus.stax2.internNames"));
        System.out.println("SR; URI interning: " + xMLStreamReader2.getProperty("org.codehaus.stax2.internNsUris"));
        int n2 = xMLStreamReader2.getEventType();
        System.out.println("START: version = '" + xMLStreamReader2.getVersion() + "', xml-encoding = '" + xMLStreamReader2.getCharacterEncodingScheme() + "', input encoding = '" + xMLStreamReader2.getEncoding() + "'");
        while (n2 != 8) {
            int n3;
            String string;
            n2 = xMLStreamReader2.next();
            n += n2;
            System.out.print("[" + n2 + "]");
            if (xMLStreamReader2.hasText()) {
                string = xMLStreamReader2.getText();
                n += string.length();
                if (n2 == 4 || n2 == 12 || n2 == 5) {
                    System.out.println(" Text(" + string.length() + " = '" + string + "'.");
                    if (string.length() >= 1) {
                        System.out.println(" [first char code: 0x" + Integer.toHexString(string.charAt(0)) + "]");
                    }
                    LocationInfo locationInfo = xMLStreamReader2.getLocationInfo();
                    System.out.println(" [Loc, start: " + locationInfo.getStartLocation() + ", end: " + locationInfo.getEndLocation() + "]");
                } else if (n2 == 6) {
                    int n4;
                    System.out.print(" Ws = '" + string + "'.");
                    int n5 = n4 = string.length() == 0 ? 32 : (int)string.charAt(string.length() - 1);
                    if (n4 != 13 && n4 != 10) {
                        System.out.println();
                    }
                } else if (n2 == 11) {
                    System.out.println(" DTD;");
                    List list = (List)xMLStreamReader2.getProperty("javax.xml.stream.entities");
                    List list2 = (List)xMLStreamReader2.getProperty("javax.xml.stream.notations");
                    n3 = list == null ? -1 : list.size();
                    int n6 = list2 == null ? -1 : list2.size();
                    System.out.print("  (" + n3 + " entities, " + n6 + " notations), sysid ");
                    System.out.print(", declaration = <<");
                    System.out.print(string);
                    System.out.println(">>");
                } else if (n2 == 9) {
                    System.out.println(" Entity ref: &" + xMLStreamReader2.getLocalName() + " -> '" + xMLStreamReader2.getText() + "'.");
                }
            }
            if (n2 == 3) {
                System.out.println(" PI target = '" + xMLStreamReader2.getPITarget() + "'.");
                System.out.println(" PI data = '" + xMLStreamReader2.getPIData() + "'.");
                continue;
            }
            if (n2 == 1) {
                string = xMLStreamReader2.getPrefix();
                System.out.print('<');
                if (string != null && string.length() > 0) {
                    System.out.print(string);
                    System.out.print(':');
                }
                System.out.print(xMLStreamReader2.getLocalName());
                System.out.print(" [QNameNS: " + xMLStreamReader2.getName().getNamespaceURI() + "]");
                System.out.print(" {ns '");
                System.out.print(xMLStreamReader2.getNamespaceURI());
                System.out.print("'}> ");
                int n7 = xMLStreamReader2.getAttributeCount();
                int n8 = xMLStreamReader2.getNamespaceCount();
                System.out.println(" [" + n8 + " ns, " + n7 + " attrs]");
                for (n3 = 0; n3 < n8; ++n3) {
                    System.out.println(" ns#" + n3 + ": '" + xMLStreamReader2.getNamespacePrefix(n3) + "' -> '" + xMLStreamReader2.getNamespaceURI(n3) + "'");
                }
                for (n3 = 0; n3 < n7; ++n3) {
                    String string2 = xMLStreamReader2.getAttributeValue(n3);
                    System.out.print(" attr#" + n3 + ": " + xMLStreamReader2.getAttributePrefix(n3) + ":" + xMLStreamReader2.getAttributeLocalName(n3) + " (" + xMLStreamReader2.getAttributeNamespace(n3) + ") -> '" + string2 + "' [" + string2.length() + "]");
                    System.out.println(xMLStreamReader2.isAttributeSpecified(n3) ? "[specified]" : "[Default]");
                }
                continue;
            }
            if (n2 == 2) {
                System.out.print("</");
                string = xMLStreamReader2.getPrefix();
                if (string != null && string.length() > 0) {
                    System.out.print(string);
                    System.out.print(':');
                }
                System.out.print(xMLStreamReader2.getLocalName());
                System.out.print(" {ns '");
                System.out.print(xMLStreamReader2.getNamespaceURI());
                System.out.print("'}> ");
                int n9 = xMLStreamReader2.getNamespaceCount();
                System.out.println(" [" + n9 + " ns unbound]");
                continue;
            }
            if (n2 != 7) continue;
            System.out.print("XML-DECL: version = '" + xMLStreamReader2.getVersion() + "', xml-decl-encoding = '" + xMLStreamReader2.getCharacterEncodingScheme() + "', app-encoding = '" + xMLStreamReader2.getEncoding() + "', stand-alone set: " + xMLStreamReader2.standaloneSet());
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java ... " + TestStreamReader.class + " [file]");
            System.exit(1);
        }
        try {
            int n = new TestStreamReader().test(new File(stringArray[0]));
            System.out.println();
            System.out.println("Total: " + n);
        }
        catch (Throwable throwable) {
            System.err.println("Error: " + throwable);
            throwable.printStackTrace();
        }
    }
}

