/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonorg;

import com.fasterxml.jackson.module.jsonorg.JSONArraySerializer;
import com.fasterxml.jackson.module.jsonorg.JSONBaseSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectSerializer
extends JSONBaseSerializer<JSONObject> {
    public static final JSONObjectSerializer instance = new JSONObjectSerializer();

    public JSONObjectSerializer() {
        super(JSONObject.class);
    }

    public void serialize(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(JSONObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject((Object)value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForObject((Object)value, jgen);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Iterator it = value.keys();
        while (it.hasNext()) {
            Object ob;
            String key = (String)it.next();
            try {
                ob = value.get(key);
            }
            catch (JSONException e) {
                throw new JsonGenerationException((Throwable)e);
            }
            if (ob == null || ob == JSONObject.NULL) {
                if (!provider.isEnabled(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES)) continue;
                jgen.writeNullField(key);
                continue;
            }
            jgen.writeFieldName(key);
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                this.serialize((JSONObject)ob, jgen, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber(((Integer)ob).intValue());
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber(((Long)ob).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber(((Double)ob).doubleValue());
                continue;
            }
            if (cls == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                this.serialize((JSONObject)ob, jgen, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, jgen);
        }
    }
}

