/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.impl.UTF8Reader;
import com.fasterxml.jackson.dataformat.csv.impl.UTF8Writer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.format.InputAccessor;
import org.codehaus.jackson.format.MatchStrength;
import org.codehaus.jackson.io.IOContext;

public class CsvFactory
extends JsonFactory {
    public static final String FORMAT_NAME_CSV = "CSV";
    static final int DEFAULT_CSV_PARSER_FEATURE_FLAGS = CsvParser.Feature.collectDefaults();
    static final int DEFAULT_CSV_GENERATOR_FEATURE_FLAGS = CsvGenerator.Feature.collectDefaults();
    protected static final char[] DEFAULT_LF = new char[]{'\n'};
    protected int _csvParserFeatures = DEFAULT_CSV_PARSER_FEATURE_FLAGS;
    protected int _csvGeneratorFeatures = DEFAULT_CSV_GENERATOR_FEATURE_FLAGS;
    protected char _cfgColumnSeparator = (char)44;
    protected char _cfgQuoteCharacter = (char)34;
    protected char[] _cfgLineSeparator = DEFAULT_LF;
    protected final Charset UTF8 = Charset.forName("UTF-8");

    public CsvFactory() {
        this(null);
    }

    public CsvFactory(ObjectCodec oc) {
        super(oc);
    }

    public String getFormatName() {
        return FORMAT_NAME_CSV;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    public final CsvFactory configure(CsvParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public CsvFactory enable(CsvParser.Feature f) {
        this._csvParserFeatures |= f.getMask();
        return this;
    }

    public CsvFactory disable(CsvParser.Feature f) {
        this._csvParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(CsvParser.Feature f) {
        return (this._csvParserFeatures & f.getMask()) != 0;
    }

    public final CsvFactory configure(CsvGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public CsvFactory enable(CsvGenerator.Feature f) {
        this._csvGeneratorFeatures |= f.getMask();
        return this;
    }

    public CsvFactory disable(CsvGenerator.Feature f) {
        this._csvGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(CsvGenerator.Feature f) {
        return (this._csvGeneratorFeatures & f.getMask()) != 0;
    }

    public CsvParser createJsonParser(File f) throws IOException, JsonParseException {
        return this._createJsonParser(new FileInputStream(f), this._createContext(f, true));
    }

    public CsvParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this._createJsonParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    public CsvParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this._createJsonParser(in, this._createContext(in, false));
    }

    public CsvParser createJsonParser(byte[] data) throws IOException, JsonParseException {
        return this._createJsonParser(data, 0, data.length, this._createContext(data, true));
    }

    public CsvParser createJsonParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        return this._createJsonParser(data, offset, len, this._createContext(data, true));
    }

    public CsvGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this.createJsonGenerator(out);
    }

    public CsvGenerator createJsonGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createJsonGenerator(ctxt, this._createWriter(out, JsonEncoding.UTF8, ctxt));
    }

    protected CsvParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(in, null, ctxt);
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, r);
    }

    protected JsonParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, r);
    }

    protected CsvParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(data, offset, len, null, ctxt);
        return new CsvParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._csvParserFeatures, this._objectCodec, r);
    }

    protected JsonGenerator _createJsonGenerator(Writer out, IOContext ctxt) throws IOException {
        return this._createJsonGenerator(ctxt, out);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == JsonEncoding.UTF8) {
            return new UTF8Writer(ctxt, out);
        }
        return new OutputStreamWriter(out, enc.getJavaName());
    }

    protected CsvGenerator _createJsonGenerator(IOContext ctxt, Writer out) throws IOException {
        int feats = this._csvGeneratorFeatures;
        CsvGenerator gen = new CsvGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out, this._cfgColumnSeparator, this._cfgQuoteCharacter, this._cfgLineSeparator);
        return gen;
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null || enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(ctxt, in, autoClose);
        }
        return new InputStreamReader(in, enc.getJavaName());
    }

    protected Reader _createReader(byte[] data, int offset, int len, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(null, data, offset, len);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        return new InputStreamReader((InputStream)in, enc.getJavaName());
    }
}

