/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.dataformat.csv.impl.BufferedValue;
import com.fasterxml.jackson.dataformat.csv.impl.NumberOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.io.IOContext;

public final class CsvWriter {
    protected static final int SHORT_WRITE = 32;
    protected static final int MAX_QUOTE_CHECK = 20;
    protected final BufferedValue[] NO_BUFFERED = new BufferedValue[0];
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();
    protected final IOContext _ioContext;
    protected final Writer _out;
    protected final char _cfgColumnSeparator;
    protected final char _cfgQuoteCharacter;
    protected final char[] _cfgLineSeparator;
    protected final int _cfgLineSeparatorLength;
    protected final int _cfgMinSafeChar;
    protected int _nextColumnToWrite = 0;
    protected BufferedValue[] _buffered = this.NO_BUFFERED;
    protected int _lastBuffered = -1;
    protected char[] _outputBuffer;
    protected boolean _bufferRecyclable;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _charsWritten;

    public CsvWriter(IOContext ctxt, Writer out, char columnSeparator, char quoteChar, char[] linefeed) {
        this._ioContext = ctxt;
        this._outputBuffer = ctxt.allocConcatBuffer();
        this._bufferRecyclable = true;
        this._outputEnd = this._outputBuffer.length;
        this._out = out;
        this._cfgColumnSeparator = columnSeparator;
        this._cfgQuoteCharacter = quoteChar;
        this._cfgLineSeparator = linefeed;
        this._cfgLineSeparatorLength = linefeed.length;
        int min = Math.max(this._cfgColumnSeparator, this._cfgQuoteCharacter);
        for (int i = 0; i < this._cfgLineSeparatorLength; ++i) {
            min = Math.max(min, this._cfgLineSeparator[i]);
        }
        this._cfgMinSafeChar = min + 1;
    }

    public Object getOutputTarget() {
        return this._out;
    }

    public int nextColumnIndex() {
        return this._nextColumnToWrite;
    }

    public void write(int columnIndex, String value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public void write(int columnIndex, char[] ch, int offset, int len) throws IOException {
        this.write(columnIndex, new String(ch, offset, len));
    }

    public void write(int columnIndex, int value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public void write(int columnIndex, long value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public void write(int columnIndex, double value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public void write(int columnIndex, boolean value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public void writeColumnName(String name) throws IOException {
        this.appendValue(name);
        ++this._nextColumnToWrite;
    }

    public void endRow() throws IOException {
        if (this._lastBuffered >= 0) {
            int last = this._lastBuffered;
            this._lastBuffered = -1;
            for (int i = this._nextColumnToWrite; i <= last; ++i) {
                BufferedValue value = this._buffered[i];
                if (value == null) {
                    this.appendColumnSeparator();
                    continue;
                }
                this._buffered[i] = null;
                value.write(this);
            }
        } else if (this._nextColumnToWrite <= 0) {
            return;
        }
        this._nextColumnToWrite = 0;
        if (this._outputTail + this._cfgLineSeparatorLength > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(this._cfgLineSeparator, 0, this._outputBuffer, this._outputTail, this._cfgLineSeparatorLength);
        this._outputTail += this._cfgLineSeparatorLength;
    }

    protected void appendValue(String value) throws IOException {
        int len;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        if (this._mayNeedQuotes(value, len = value.length())) {
            this._writeQuoted(value);
        } else {
            this.writeRaw(value);
        }
    }

    protected void appendValue(int value) throws IOException {
        if (this._outputTail + 12 > this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this._outputTail = NumberOutput.outputInt(value, this._outputBuffer, this._outputTail);
    }

    protected void appendValue(long value) throws IOException {
        if (this._outputTail + 22 > this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this._outputTail = NumberOutput.outputLong(value, this._outputBuffer, this._outputTail);
    }

    protected void appendValue(double value) throws IOException {
        String str = NumberOutput.toString(value);
        int len = str.length();
        if (this._outputTail + len >= this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        System.arraycopy(value, 0, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    protected void appendValue(boolean value) throws IOException {
        char[] ch = value ? TRUE_CHARS : FALSE_CHARS;
        int len = ch.length;
        if (this._outputTail + len >= this._outputTail) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        System.arraycopy(ch, 0, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    protected void appendColumnSeparator() throws IOException {
        if (this._nextColumnToWrite > 0) {
            if (this._outputTail >= this._outputTail) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
    }

    public void _writeQuoted(String text) throws IOException {
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        this.writeRaw(text);
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = 44;
        }
    }

    public void writeRaw(String text) throws IOException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text);
        }
    }

    public void writeRaw(String text, int start, int len) throws IOException {
        int room = this._outputEnd - this._outputTail;
        if (room < len) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(start, start + len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text.substring(start, start + len));
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        if (len < 32) {
            int room = this._outputEnd - this._outputTail;
            if (len > room) {
                this._flushBuffer();
            }
            System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
            this._outputTail += len;
            return;
        }
        this._flushBuffer();
        this._out.write(text, offset, len);
    }

    public void writeRaw(char c) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String text) throws IOException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    public void flush(boolean flushStream) throws IOException {
        this._flushBuffer();
        if (flushStream) {
            this._out.flush();
        }
    }

    public void close(boolean autoClose) throws IOException {
        this._flushBuffer();
        if (autoClose) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    protected final boolean _mayNeedQuotes(String value, int length) {
        if (length > 20) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (value.charAt(i) >= this._cfgMinSafeChar) continue;
            return true;
        }
        return false;
    }

    protected void _buffer(int index, BufferedValue v) {
        this._lastBuffered = Math.max(this._lastBuffered, index);
        if (index >= this._buffered.length) {
            this._buffered = Arrays.copyOf(this._buffered, index + 4);
        }
        this._buffered[index] = v;
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._charsWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    public void _releaseBuffers() {
        char[] buf = this._outputBuffer;
        if (buf != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }
}

