/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.databind.util.JSONWrappedObject;
import com.fasterxml.jackson.jaxrs.cfg.EndpointConfigBase;
import com.fasterxml.jackson.jaxrs.json.annotation.JSONP;
import com.fasterxml.jackson.jaxrs.json.annotation.JacksonFeatures;
import java.lang.annotation.Annotation;

public class JsonEndpointConfig
extends EndpointConfigBase<JsonEndpointConfig> {
    protected JSONP.Def _jsonp;

    protected JsonEndpointConfig() {
    }

    public static JsonEndpointConfig forReading(ObjectMapper mapper, Annotation[] annotations) {
        return (JsonEndpointConfig)((JsonEndpointConfig)new JsonEndpointConfig().add(annotations, false)).initReader(mapper);
    }

    public static JsonEndpointConfig forWriting(ObjectMapper mapper, Annotation[] annotations, String defaultJsonpMethod) {
        JsonEndpointConfig config = new JsonEndpointConfig();
        if (defaultJsonpMethod != null) {
            config._jsonp = new JSONP.Def(defaultJsonpMethod);
        }
        return (JsonEndpointConfig)((JsonEndpointConfig)config.add(annotations, true)).initWriter(mapper);
    }

    protected void addAnnotation(Class<? extends Annotation> type, Annotation annotation, boolean forWriting) {
        if (type == JSONP.class) {
            if (forWriting) {
                this._jsonp = new JSONP.Def((JSONP)annotation);
            }
        } else if (type == JacksonFeatures.class) {
            JacksonFeatures feats = (JacksonFeatures)annotation;
            if (forWriting) {
                this._serEnable = (SerializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])feats.serializationEnable());
                this._serDisable = (SerializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])feats.serializationDisable());
            } else {
                this._deserEnable = (DeserializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])feats.deserializationEnable());
                this._deserDisable = (DeserializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])feats.deserializationDisable());
            }
        } else {
            super.addAnnotation(type, annotation, forWriting);
        }
    }

    public Object modifyBeforeWrite(Object value) {
        return this.applyJSONP(value);
    }

    public Object applyJSONP(Object value) {
        if (this._jsonp != null) {
            if (this._jsonp.prefix != null || this._jsonp.suffix != null) {
                return new JSONWrappedObject(this._jsonp.prefix, this._jsonp.suffix, value);
            }
            if (this._jsonp.method != null) {
                return new JSONPObject(this._jsonp.method, value);
            }
        }
        return value;
    }
}

