/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.smile;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.jaxrs.smile.Annotations;
import com.fasterxml.jackson.jaxrs.smile.ModuleVersion;
import com.fasterxml.jackson.jaxrs.smile.SmileMediaTypes;
import com.fasterxml.jackson.jaxrs.smile.annotation.EndpointConfig;
import com.fasterxml.jackson.jaxrs.smile.cfg.MapperConfigurator;
import com.fasterxml.jackson.jaxrs.smile.util.AnnotationBundleKey;
import com.fasterxml.jackson.jaxrs.smile.util.ClassKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/x-jackson-smile"})
@Produces(value={"application/x-jackson-smile"})
public class JacksonSmileProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object>,
Versioned {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    public static final HashSet<ClassKey> _untouchables = new HashSet();
    public static final Class<?>[] _unreadableClasses;
    public static final Class<?>[] _unwritableClasses;
    protected final LRUMap<AnnotationBundleKey, EndpointConfig> _readers = new LRUMap(16, 120);
    protected final LRUMap<AnnotationBundleKey, EndpointConfig> _writers = new LRUMap(16, 120);
    protected final MapperConfigurator _mapperConfig;
    protected HashSet<ClassKey> _cfgCustomUntouchables;
    @Context
    protected Providers _providers;
    protected boolean _cfgCheckCanSerialize = false;
    protected boolean _cfgCheckCanDeserialize = false;

    public JacksonSmileProvider() {
        this((ObjectMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonSmileProvider(Annotations ... annotationsToUse) {
        this((ObjectMapper)null, annotationsToUse);
    }

    public JacksonSmileProvider(ObjectMapper mapper) {
        this(mapper, BASIC_ANNOTATIONS);
    }

    public JacksonSmileProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
        this._mapperConfig = new MapperConfigurator(mapper, annotationsToUse);
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public void checkCanDeserialize(boolean state) {
        this._cfgCheckCanDeserialize = state;
    }

    public void checkCanSerialize(boolean state) {
        this._cfgCheckCanSerialize = state;
    }

    public void setAnnotationsToUse(Annotations[] annotationsToUse) {
        this._mapperConfig.setAnnotationsToUse(annotationsToUse);
    }

    public void setMapper(ObjectMapper m) {
        this._mapperConfig.setMapper(m);
    }

    public JacksonSmileProvider configure(DeserializationFeature f, boolean state) {
        this._mapperConfig.configure(f, state);
        return this;
    }

    public JacksonSmileProvider configure(SerializationFeature f, boolean state) {
        this._mapperConfig.configure(f, state);
        return this;
    }

    public JacksonSmileProvider configure(JsonParser.Feature f, boolean state) {
        this._mapperConfig.configure(f, state);
        return this;
    }

    public JacksonSmileProvider configure(JsonGenerator.Feature f, boolean state) {
        this._mapperConfig.configure(f, state);
        return this;
    }

    public JacksonSmileProvider enable(DeserializationFeature f, boolean state) {
        this._mapperConfig.configure(f, true);
        return this;
    }

    public JacksonSmileProvider enable(SerializationFeature f, boolean state) {
        this._mapperConfig.configure(f, true);
        return this;
    }

    public JacksonSmileProvider enable(JsonParser.Feature f, boolean state) {
        this._mapperConfig.configure(f, true);
        return this;
    }

    public JacksonSmileProvider enable(JsonGenerator.Feature f, boolean state) {
        this._mapperConfig.configure(f, true);
        return this;
    }

    public JacksonSmileProvider disable(DeserializationFeature f, boolean state) {
        this._mapperConfig.configure(f, false);
        return this;
    }

    public JacksonSmileProvider disable(SerializationFeature f, boolean state) {
        this._mapperConfig.configure(f, false);
        return this;
    }

    public JacksonSmileProvider disable(JsonParser.Feature f, boolean state) {
        this._mapperConfig.configure(f, false);
        return this;
    }

    public JacksonSmileProvider disable(JsonGenerator.Feature f, boolean state) {
        this._mapperConfig.configure(f, false);
        return this;
    }

    public void addUntouchable(Class<?> type) {
        if (this._cfgCustomUntouchables == null) {
            this._cfgCustomUntouchables = new HashSet();
        }
        this._cfgCustomUntouchables.add(new ClassKey(type));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ObjectMapper mapper;
        if (!this.isSmileType(mediaType)) {
            return false;
        }
        if (_untouchables.contains(new ClassKey(type))) {
            return false;
        }
        for (Class<?> cls : _unreadableClasses) {
            if (!cls.isAssignableFrom(type)) continue;
            return false;
        }
        if (JacksonSmileProvider._containedIn(type, this._cfgCustomUntouchables)) {
            return false;
        }
        return !this._cfgCheckCanSerialize || (mapper = this.locateMapper(type, mediaType)).canDeserialize(mapper.constructType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ObjectReader reader;
        JsonParser jp;
        EndpointConfig endpoint;
        AnnotationBundleKey key = new AnnotationBundleKey(annotations);
        LRUMap<AnnotationBundleKey, EndpointConfig> lRUMap = this._readers;
        synchronized (lRUMap) {
            endpoint = (EndpointConfig)this._readers.get((Object)key);
        }
        if (endpoint == null) {
            ObjectMapper mapper = this.locateMapper(type, mediaType);
            endpoint = EndpointConfig.forReading(mapper, annotations);
            LRUMap<AnnotationBundleKey, EndpointConfig> lRUMap2 = this._readers;
            synchronized (lRUMap2) {
                this._readers.put((Object)key.immutableKey(), (Object)endpoint);
            }
        }
        if ((jp = (reader = endpoint.getReader()).getFactory().createJsonParser(entityStream)).nextToken() == null) {
            return null;
        }
        return reader.withType(genericType).readValue(jp);
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.isSmileType(mediaType)) {
            return false;
        }
        if (_untouchables.contains(new ClassKey(type))) {
            return false;
        }
        for (Class<?> cls : _unwritableClasses) {
            if (!cls.isAssignableFrom(type)) continue;
            return false;
        }
        if (JacksonSmileProvider._containedIn(type, this._cfgCustomUntouchables)) {
            return false;
        }
        return !this._cfgCheckCanSerialize || this.locateMapper(type, mediaType).canSerialize(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        EndpointConfig endpoint;
        AnnotationBundleKey key = new AnnotationBundleKey(annotations);
        LRUMap<AnnotationBundleKey, EndpointConfig> lRUMap = this._writers;
        synchronized (lRUMap) {
            endpoint = (EndpointConfig)this._writers.get((Object)key);
        }
        if (endpoint == null) {
            ObjectMapper mapper = this.locateMapper(type, mediaType);
            endpoint = EndpointConfig.forWriting(mapper, annotations);
            LRUMap<AnnotationBundleKey, EndpointConfig> lRUMap2 = this._writers;
            synchronized (lRUMap2) {
                this._writers.put((Object)key.immutableKey(), (Object)endpoint);
            }
        }
        ObjectWriter writer = endpoint.getWriter();
        JsonEncoding enc = this.findEncoding(mediaType, httpHeaders);
        JsonGenerator jg = writer.getJsonFactory().createJsonGenerator(entityStream, enc);
        if (writer.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jg.useDefaultPrettyPrinter();
        }
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = writer.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        if (rootType != null) {
            writer = writer.withType(rootType);
        }
        writer.writeValue(jg, value);
    }

    protected JsonEncoding findEncoding(MediaType mediaType, MultivaluedMap<String, Object> httpHeaders) {
        return JsonEncoding.UTF8;
    }

    protected boolean isSmileType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return SmileMediaTypes.APPLICATION_JACKSON_SMILE_TYPE.getSubtype().equalsIgnoreCase(subtype) || "smile".equalsIgnoreCase(subtype) || subtype.endsWith("+smile");
        }
        return true;
    }

    public ObjectMapper locateMapper(Class<?> type, MediaType mediaType) {
        ObjectMapper m = this._mapperConfig.getConfiguredMapper();
        if (m == null) {
            if (this._providers != null) {
                ContextResolver resolver = this._providers.getContextResolver(ObjectMapper.class, mediaType);
                if (resolver == null) {
                    resolver = this._providers.getContextResolver(ObjectMapper.class, null);
                }
                if (resolver != null) {
                    m = (ObjectMapper)resolver.getContext(type);
                }
            }
            if (m == null) {
                m = this._mapperConfig.getDefaultMapper();
            }
        }
        return m;
    }

    protected static boolean _containedIn(Class<?> mainType, HashSet<ClassKey> set) {
        if (set != null) {
            ClassKey key = new ClassKey(mainType);
            if (set.contains(key)) {
                return true;
            }
            for (Class<?> cls : JacksonSmileProvider.findSuperTypes(mainType, null)) {
                key.reset(cls);
                if (!set.contains(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore) {
        return JacksonSmileProvider.findSuperTypes(cls, endBefore, new ArrayList(8));
    }

    private static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore, List<Class<?>> result) {
        JacksonSmileProvider._addSuperTypes(cls, endBefore, result, false);
        return result;
    }

    private static void _addSuperTypes(Class<?> cls, Class<?> endBefore, Collection<Class<?>> result, boolean addClassItself) {
        if (cls == endBefore || cls == null || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result.contains(cls)) {
                return;
            }
            result.add(cls);
        }
        for (Class<?> intCls : cls.getInterfaces()) {
            JacksonSmileProvider._addSuperTypes(intCls, endBefore, result, true);
        }
        JacksonSmileProvider._addSuperTypes(cls.getSuperclass(), endBefore, result, true);
    }

    static {
        _untouchables.add(new ClassKey(InputStream.class));
        _untouchables.add(new ClassKey(Reader.class));
        _untouchables.add(new ClassKey(OutputStream.class));
        _untouchables.add(new ClassKey(Writer.class));
        _untouchables.add(new ClassKey(char[].class));
        _untouchables.add(new ClassKey(String.class));
        _untouchables.add(new ClassKey(byte[].class));
        _unreadableClasses = new Class[]{InputStream.class, Reader.class};
        _unwritableClasses = new Class[]{OutputStream.class, Writer.class, StreamingOutput.class, Response.class};
    }
}

