/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.smile;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.ProviderBase;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.smile.PackageVersion;
import com.fasterxml.jackson.jaxrs.smile.SmileEndpointConfig;
import com.fasterxml.jackson.jaxrs.smile.SmileMapperConfigurator;
import com.fasterxml.jackson.jaxrs.smile.SmileMediaTypes;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"application/x-jackson-smile"})
@Produces(value={"application/x-jackson-smile"})
public class JacksonSmileProvider
extends ProviderBase<JacksonSmileProvider, ObjectMapper, SmileEndpointConfig, SmileMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonSmileProvider() {
        this((ObjectMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonSmileProvider(Annotations ... annotationsArray) {
        this((ObjectMapper)null, annotationsArray);
    }

    public JacksonSmileProvider(ObjectMapper objectMapper) {
        this(objectMapper, BASIC_ANNOTATIONS);
    }

    public JacksonSmileProvider(ObjectMapper objectMapper, Annotations[] annotationsArray) {
        super((MapperConfiguratorBase)new SmileMapperConfigurator(objectMapper, annotationsArray));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    @Deprecated
    protected boolean isSmileType(MediaType mediaType) {
        return this.hasMatchingMediaType(mediaType);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String string = mediaType.getSubtype();
            return SmileMediaTypes.APPLICATION_JACKSON_SMILE_TYPE.getSubtype().equalsIgnoreCase(string) || "smile".equalsIgnoreCase(string) || string.endsWith("+smile");
        }
        return true;
    }

    protected ObjectMapper _locateMapperViaProvider(Class<?> clazz, MediaType mediaType) {
        if (this._providers != null) {
            ContextResolver contextResolver = this._providers.getContextResolver(ObjectMapper.class, mediaType);
            if (contextResolver == null) {
                contextResolver = this._providers.getContextResolver(ObjectMapper.class, null);
            }
            if (contextResolver != null) {
                return (ObjectMapper)contextResolver.getContext(clazz);
            }
        }
        return null;
    }

    protected SmileEndpointConfig _configForReading(ObjectMapper objectMapper, Annotation[] annotationArray) {
        return SmileEndpointConfig.forReading(objectMapper, annotationArray);
    }

    protected SmileEndpointConfig _configForWriting(ObjectMapper objectMapper, Annotation[] annotationArray) {
        return SmileEndpointConfig.forWriting(objectMapper, annotationArray);
    }
}

