/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.smile;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.jaxrs.base.ProviderBase;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.smile.PackageVersion;
import com.fasterxml.jackson.jaxrs.smile.SmileEndpointConfig;
import com.fasterxml.jackson.jaxrs.smile.SmileMapperConfigurator;
import com.fasterxml.jackson.jaxrs.smile.SmileMediaTypes;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"application/x-jackson-smile"})
@Produces(value={"application/x-jackson-smile"})
public class JacksonSmileProvider
extends ProviderBase<JacksonSmileProvider, ObjectMapper, SmileEndpointConfig, SmileMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonSmileProvider() {
        this((ObjectMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonSmileProvider(Annotations ... annotationsToUse) {
        this((ObjectMapper)null, annotationsToUse);
    }

    public JacksonSmileProvider(ObjectMapper mapper) {
        this(mapper, BASIC_ANNOTATIONS);
    }

    public JacksonSmileProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
        super((MapperConfiguratorBase)new SmileMapperConfigurator(mapper, annotationsToUse));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    @Deprecated
    protected boolean isSmileType(MediaType mediaType) {
        return this.hasMatchingMediaType(mediaType);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return SmileMediaTypes.APPLICATION_JACKSON_SMILE_TYPE.getSubtype().equalsIgnoreCase(subtype) || "smile".equalsIgnoreCase(subtype) || subtype.endsWith("+smile");
        }
        return true;
    }

    protected ObjectMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        if (this._providers != null) {
            ObjectMapper mapper;
            ContextResolver resolver = this._providers.getContextResolver(ObjectMapper.class, mediaType);
            if (resolver == null) {
                resolver = this._providers.getContextResolver(ObjectMapper.class, null);
            }
            if (resolver != null && (mapper = (ObjectMapper)resolver.getContext(type)).getFactory() instanceof SmileFactory) {
                return mapper;
            }
        }
        return null;
    }

    protected SmileEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return SmileEndpointConfig.forReading(reader, annotations);
    }

    protected SmileEndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return SmileEndpointConfig.forWriting(writer, annotations);
    }
}

