/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyWriter;
import com.fasterxml.jackson.jr.ob.impl.ValueWriterLocator;
import com.fasterxml.jackson.jr.private_.JsonGenerator;
import com.fasterxml.jackson.jr.private_.TreeCodec;
import com.fasterxml.jackson.jr.private_.TreeNode;
import com.fasterxml.jackson.jr.private_.io.SerializedString;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;

public class JSONWriter {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final TreeCodec _treeCodec;
    protected final ValueWriterLocator _writerLocator;
    protected final JsonGenerator _generator;
    protected final TimeZone _timezone;
    protected final int _features;
    protected final boolean _writeNullValues;

    public JSONWriter() {
        this._features = 0;
        this._writeNullValues = false;
        this._writerLocator = null;
        this._treeCodec = null;
        this._generator = null;
        this._timezone = DEFAULT_TIMEZONE;
    }

    protected JSONWriter(JSONWriter jSONWriter, int n, ValueWriterLocator valueWriterLocator, TreeCodec treeCodec, JsonGenerator jsonGenerator) {
        this._features = n;
        this._writeNullValues = JSON.Feature.WRITE_NULL_PROPERTIES.isEnabled(n);
        this._treeCodec = treeCodec;
        this._writerLocator = valueWriterLocator.perOperationInstance(this, n);
        this._generator = jsonGenerator;
        this._timezone = DEFAULT_TIMEZONE;
    }

    public JSONWriter withCacheCheck(int n) {
        return this;
    }

    public JSONWriter perOperationInstance(int n, ValueWriterLocator valueWriterLocator, TreeCodec treeCodec, JsonGenerator jsonGenerator) {
        if (this.getClass() != JSONWriter.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONWriter(this, n, valueWriterLocator, treeCodec, jsonGenerator);
    }

    public boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public int features() {
        return this._features;
    }

    public void writeValue(Object object) throws IOException {
        if (object == null) {
            this.writeNullValue();
            return;
        }
        this._writeValue(object, this._writerLocator.findSerializationType(object.getClass()));
    }

    public void writeField(String string, Object object, int n) throws IOException {
        ValueWriter valueWriter;
        switch (n) {
            case 1: {
                this.writeMapField(string, (Map)object);
                return;
            }
            case 2: {
                this.writeListField(string, (List)object);
                return;
            }
            case 3: {
                this.writeCollectionField(string, (Collection)object);
                return;
            }
            case 4: {
                this.writeObjectArrayField(string, (Object[])object);
                return;
            }
            case 6: {
                this.writeIntArrayField(string, (int[])object);
                return;
            }
            case 7: {
                this.writeLongArrayField(string, (long[])object);
                return;
            }
            case 10: {
                this.writeBooleanArrayField(string, (boolean[])object);
                return;
            }
            case 5: {
                this.writeShortArrayField(string, (short[])object);
                return;
            }
            case 8: {
                this.writeFloatArrayField(string, (float[])object);
                return;
            }
            case 9: {
                this.writeDoubleArrayField(string, (double[])object);
                return;
            }
            case 11: {
                this.writeTreeNodeField(string, (TreeNode)object);
                return;
            }
            case 12: {
                this.writeStringField(string, (String)object);
                return;
            }
            case 14: {
                this.writeStringField(string, new String((char[])object));
                return;
            }
            case 13: {
                this.writeStringField(string, ((CharSequence)object).toString());
                return;
            }
            case 15: {
                this.writeBinaryField(string, (byte[])object);
                return;
            }
            case 27: {
                this.writeBigDecimalField(string, (BigDecimal)object);
                return;
            }
            case 26: {
                this.writeBigIntegerField(string, (BigInteger)object);
                return;
            }
            case 22: 
            case 23: {
                this.writeFloatField(string, ((Float)object).floatValue());
                return;
            }
            case 24: 
            case 25: {
                this.writeDoubleField(string, (Double)object);
                return;
            }
            case 16: 
            case 17: {
                this.writeIntField(string, ((Number)object).intValue());
                return;
            }
            case 18: 
            case 19: {
                this.writeIntField(string, (Integer)object);
                return;
            }
            case 20: 
            case 21: {
                this.writeLongField(string, (Long)object);
                return;
            }
            case 28: 
            case 29: {
                this.writeBooleanField(string, (Boolean)object);
                return;
            }
            case 30: {
                this.writeStringField(string, String.valueOf(object));
                return;
            }
            case 33: {
                this.writeDateField(string, ((Calendar)object).getTime());
                return;
            }
            case 32: {
                this.writeDateField(string, (Date)object);
                return;
            }
            case 31: {
                this.writeEnumField(string, (Enum)object);
                return;
            }
            case 34: {
                this.writeStringLikeField(string, ((Class)object).getName(), n);
                return;
            }
            case 35: {
                this.writeStringLikeField(string, ((File)object).getAbsolutePath(), n);
                return;
            }
            case 36: 
            case 37: 
            case 38: {
                this.writeStringLikeField(string, object.toString(), n);
                return;
            }
            case 39: {
                this.writeStringLikeField(string, this.pathToString((Path)object), n);
                return;
            }
            case 40: {
                this.writeIterableField(string, (Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownField(string, object);
                return;
            }
        }
        if (n < 0 && (valueWriter = this._writerLocator.getValueWriter(n)) != null) {
            this._generator.writeFieldName(string);
            valueWriter.writeValue(this, this._generator, object);
            return;
        }
        this._badType(n, object);
    }

    protected void _writeValue(Object object, int n) throws IOException {
        ValueWriter valueWriter;
        switch (n) {
            case 1: {
                this.writeMapValue((Map)object);
                return;
            }
            case 2: {
                this.writeListValue((List)object);
                return;
            }
            case 3: {
                this.writeCollectionValue((Collection)object);
                return;
            }
            case 4: {
                this.writeObjectArrayValue((Object[])object);
                return;
            }
            case 6: {
                this.writeIntArrayValue((int[])object);
                return;
            }
            case 7: {
                this.writeLongArrayValue((long[])object);
                return;
            }
            case 10: {
                this.writeBooleanArrayValue((boolean[])object);
                return;
            }
            case 5: {
                this.writeShortArrayValue((short[])object);
                return;
            }
            case 8: {
                this.writeFloatArrayValue((float[])object);
                return;
            }
            case 9: {
                this.writeDoubleArrayValue((double[])object);
                return;
            }
            case 11: {
                this.writeTreeNodeValue((TreeNode)object);
                return;
            }
            case 12: {
                this.writeStringValue((String)object);
                return;
            }
            case 14: {
                this.writeStringValue(new String((char[])object));
                return;
            }
            case 13: {
                this.writeStringValue(((CharSequence)object).toString());
                return;
            }
            case 15: {
                this.writeBinaryValue((byte[])object);
                return;
            }
            case 22: 
            case 23: {
                this.writeFloatValue(((Float)object).floatValue());
                return;
            }
            case 24: 
            case 25: {
                this.writeDoubleValue((Double)object);
                return;
            }
            case 16: 
            case 17: {
                this.writeIntValue(((Number)object).intValue());
                return;
            }
            case 18: 
            case 19: {
                this.writeIntValue((Integer)object);
                return;
            }
            case 20: 
            case 21: {
                this.writeLongValue((Long)object);
                return;
            }
            case 27: {
                this.writeBigDecimalValue((BigDecimal)object);
                return;
            }
            case 26: {
                this.writeBigIntegerValue((BigInteger)object);
                return;
            }
            case 28: 
            case 29: {
                this.writeBooleanValue((Boolean)object);
                return;
            }
            case 30: {
                this.writeStringValue(String.valueOf(object));
                return;
            }
            case 33: {
                this.writeDateValue(((Calendar)object).getTime());
                return;
            }
            case 32: {
                this.writeDateValue((Date)object);
                return;
            }
            case 31: {
                this.writeEnumValue((Enum)object);
                return;
            }
            case 34: {
                this.writeStringLikeValue(((Class)object).getName(), n);
                return;
            }
            case 35: {
                this.writeStringLikeValue(((File)object).getAbsolutePath(), n);
                return;
            }
            case 36: 
            case 37: 
            case 38: {
                this.writeStringLikeValue(object.toString(), n);
                return;
            }
            case 39: {
                this.writeStringLikeValue(this.pathToString((Path)object), n);
                return;
            }
            case 40: {
                this.writeIterableValue((Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownValue(object);
                return;
            }
        }
        if (n < 0 && (valueWriter = this._writerLocator.getValueWriter(n)) != null) {
            valueWriter.writeValue(this, this._generator, object);
            return;
        }
        this._badType(n, object);
    }

    protected void writeCollectionValue(Collection<?> collection) throws IOException {
        if (collection instanceof RandomAccess) {
            this._generator.writeStartArray(collection, collection.size());
        } else {
            this._generator.writeStartArray(collection);
        }
        for (Object obj : collection) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeCollectionField(String string, Collection<?> collection) throws IOException {
        this._generator.writeFieldName(string);
        this.writeCollectionValue(collection);
    }

    protected void writeIterableValue(Iterable<?> iterable) throws IOException {
        this._generator.writeStartArray(iterable);
        for (Object obj : iterable) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeIterableField(String string, Iterable<?> iterable) throws IOException {
        this._generator.writeFieldName(string);
        this.writeIterableValue(iterable);
    }

    protected void writeListValue(List<?> list) throws IOException {
        if (list instanceof RandomAccess) {
            this._generator.writeStartArray(list, list.size());
        } else {
            this._generator.writeStartArray(list);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj == null) {
                this._generator.writeNull();
                continue;
            }
            this._writeValue(obj, this._writerLocator.findSerializationType(obj.getClass()));
        }
        this._generator.writeEndArray();
    }

    protected void writeListField(String string, List<?> list) throws IOException {
        this._generator.writeFieldName(string);
        this.writeListValue(list);
    }

    protected void writeMapValue(Map<?, ?> map) throws IOException {
        this._generator.writeStartObject(map, map.size());
        if (!map.isEmpty()) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String string = this.keyToString(entry.getKey());
                Object obj = entry.getValue();
                if (obj == null) {
                    if (!this._writeNullValues) continue;
                    this.writeNullField(string);
                    continue;
                }
                Class<?> clazz = obj.getClass();
                int n = this._writerLocator.findSerializationType(clazz);
                this.writeField(string, obj, n);
            }
        }
        this._generator.writeEndObject();
    }

    protected void writeMapField(String string, Map<?, ?> map) throws IOException {
        this._generator.writeFieldName(string);
        this.writeMapValue(map);
    }

    protected void writeObjectArrayValue(Object[] objectArray) throws IOException {
        int n = objectArray.length;
        this._generator.writeStartArray(objectArray, n);
        for (int i = 0; i < n; ++i) {
            this.writeValue(objectArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeObjectArrayField(String string, Object[] objectArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeObjectArrayValue(objectArray);
    }

    protected void writeIntArrayValue(int[] nArray) throws IOException {
        this._generator.writeArray(nArray, 0, nArray.length);
    }

    protected void writeIntArrayField(String string, int[] nArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeIntArrayValue(nArray);
    }

    protected void writeLongArrayValue(long[] lArray) throws IOException {
        this._generator.writeArray(lArray, 0, lArray.length);
    }

    protected void writeLongArrayField(String string, long[] lArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeLongArrayValue(lArray);
    }

    protected void writeBooleanArrayValue(boolean[] blArray) throws IOException {
        this._generator.writeStartArray(blArray, blArray.length);
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeBoolean(blArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeBooleanArrayField(String string, boolean[] blArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeBooleanArrayValue(blArray);
    }

    protected void writeShortArrayValue(short[] sArray) throws IOException {
        this._generator.writeStartArray(sArray, sArray.length);
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(sArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeShortArrayField(String string, short[] sArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeShortArrayValue(sArray);
    }

    protected void writeFloatArrayValue(float[] fArray) throws IOException {
        this._generator.writeStartArray(fArray, fArray.length);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(fArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeFloatArrayField(String string, float[] fArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeFloatArrayValue(fArray);
    }

    protected void writeDoubleArrayValue(double[] dArray) throws IOException {
        this._generator.writeArray(dArray, 0, dArray.length);
    }

    protected void writeDoubleArrayField(String string, double[] dArray) throws IOException {
        this._generator.writeFieldName(string);
        this.writeDoubleArrayValue(dArray);
    }

    protected void writeTreeNodeValue(TreeNode treeNode) throws IOException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No `TreeCodec` configured: can not serialize `TreeNode` values");
        }
        this._treeCodec.writeTree(this._generator, treeNode);
    }

    protected void writeTreeNodeField(String string, TreeNode treeNode) throws IOException {
        this._generator.writeFieldName(string);
        this.writeTreeNodeValue(treeNode);
    }

    protected void writeBooleanValue(boolean bl) throws IOException {
        this._generator.writeBoolean(bl);
    }

    protected void writeBooleanField(String string, boolean bl) throws IOException {
        this._generator.writeBooleanField(string, bl);
    }

    protected void writeIntValue(int n) throws IOException {
        this._generator.writeNumber(n);
    }

    protected void writeIntField(String string, int n) throws IOException {
        this._generator.writeNumberField(string, n);
    }

    protected void writeLongValue(long l) throws IOException {
        this._generator.writeNumber(l);
    }

    protected void writeBigIntegerValue(BigInteger bigInteger) throws IOException {
        this._generator.writeNumber(bigInteger);
    }

    protected void writeBigIntegerField(String string, BigInteger bigInteger) throws IOException {
        this._generator.writeFieldName(string);
        this.writeBigIntegerValue(bigInteger);
    }

    protected void writeLongField(String string, long l) throws IOException {
        this._generator.writeNumberField(string, l);
    }

    protected void writeFloatValue(float f) throws IOException {
        this._generator.writeNumber(f);
    }

    protected void writeFloatField(String string, float f) throws IOException {
        this._generator.writeNumberField(string, f);
    }

    protected void writeDoubleValue(double d) throws IOException {
        this._generator.writeNumber(d);
    }

    protected void writeDoubleField(String string, double d) throws IOException {
        this._generator.writeNumberField(string, d);
    }

    protected void writeBigDecimalValue(BigDecimal bigDecimal) throws IOException {
        this._generator.writeNumber(bigDecimal);
    }

    protected void writeBigDecimalField(String string, BigDecimal bigDecimal) throws IOException {
        this._generator.writeNumberField(string, bigDecimal);
    }

    protected void writeStringValue(String string) throws IOException {
        this._generator.writeString(string);
    }

    protected void writeStringField(String string, String string2) throws IOException {
        this._generator.writeStringField(string, string2);
    }

    protected void writeStringLikeValue(String string, int n) throws IOException {
        this._generator.writeString(string);
    }

    protected void writeStringLikeField(String string, String string2, int n) throws IOException {
        this._generator.writeStringField(string, string2);
    }

    protected void writeBinaryValue(byte[] byArray) throws IOException {
        this._generator.writeBinary(byArray);
    }

    protected void writeBinaryField(String string, byte[] byArray) throws IOException {
        this._generator.writeBinaryField(string, byArray);
    }

    protected void writeNullValue() throws IOException {
        this._generator.writeNull();
    }

    protected void writeNullField(String string) throws IOException {
        if (this._writeNullValues) {
            this._generator.writeNullField(string);
        }
    }

    protected void writeNullField(SerializedString serializedString) throws IOException {
        if (this._writeNullValues) {
            this._generator.writeFieldName(serializedString);
            this._generator.writeNull();
        }
    }

    protected void writeDateValue(Date date) throws IOException {
        if (JSON.Feature.WRITE_DATES_AS_TIMESTAMP.isEnabled(this._features)) {
            this.writeLongValue(date.getTime());
        } else {
            this.writeStringValue(this.dateToString(date));
        }
    }

    protected void writeDateField(String string, Date date) throws IOException {
        if (JSON.Feature.WRITE_DATES_AS_TIMESTAMP.isEnabled(this._features)) {
            this.writeLongField(string, date.getTime());
        } else {
            this.writeStringField(string, this.dateToString(date));
        }
    }

    protected void writeEnumValue(Enum<?> enum_) throws IOException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntValue(enum_.ordinal());
        } else {
            this.writeStringValue(enum_.toString());
        }
    }

    protected void writeEnumField(String string, Enum<?> enum_) throws IOException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntField(string, enum_.ordinal());
        } else {
            this.writeStringField(string, enum_.toString());
        }
    }

    public void writeBeanValue(BeanPropertyWriter[] beanPropertyWriterArray, Object object) throws IOException {
        this._generator.writeStartObject();
        for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
            SerializedString serializedString = beanPropertyWriter.name;
            Object object2 = beanPropertyWriter.getValueFor(object);
            if (object2 == null) {
                if (!this._writeNullValues) continue;
                this.writeNullField(serializedString);
                continue;
            }
            int n = beanPropertyWriter.typeId;
            if (n == 0) {
                n = this._writerLocator.findSerializationType(object2.getClass());
            }
            this._generator.writeFieldName(serializedString);
            this._writeValue(object2, n);
        }
        this._generator.writeEndObject();
    }

    protected void writeUnknownValue(Object object) throws IOException {
        this._checkUnknown(object);
        this.writeStringValue(object.toString());
    }

    protected void writeUnknownField(String string, Object object) throws IOException {
        this._checkUnknown(object);
        this.writeStringField(string, object.toString());
    }

    protected void _checkUnknown(Object object) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE.isEnabled(this._features)) {
            throw new JSONObjectException("Unrecognized type (" + object.getClass().getName() + "), don't know how to write (disable " + (Object)((Object)JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE) + " to avoid exception)");
        }
    }

    protected String keyToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    protected String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return date.toString();
    }

    protected String pathToString(Path path) {
        return path.toString();
    }

    private void _badType(int n, Object object) {
        if (n < 0) {
            throw new IllegalStateException(String.format("Internal error: missing BeanDefinition for id %d (class %s)", n, object.getClass().getName()));
        }
        throw new IllegalStateException(String.format("Unsupported type: %s (%s)", n, object.getClass().getName()));
    }
}

