/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.jr.private_.JsonGenerator;
import com.fasterxml.jackson.jr.private_.JsonParser;
import com.fasterxml.jackson.jr.private_.JsonToken;
import com.fasterxml.jackson.jr.private_.ObjectCodec;
import com.fasterxml.jackson.jr.private_.TreeCodec;
import com.fasterxml.jackson.jr.private_.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsEmbeddedObject;
import com.fasterxml.jackson.jr.stree.JrsMissing;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonJrsTreeCodec
extends TreeCodec {
    public static JrsMissing MISSING = JrsMissing.instance;
    public static final JacksonJrsTreeCodec SINGLETON = new JacksonJrsTreeCodec();
    protected ObjectCodec _objectCodec;

    public JacksonJrsTreeCodec() {
        this(null);
    }

    public JacksonJrsTreeCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException {
        return (T)this.nodeFrom(jsonParser);
    }

    private JrsValue nodeFrom(JsonParser jsonParser) throws IOException {
        int n = jsonParser.hasCurrentToken() ? jsonParser.getCurrentTokenId() : jsonParser.nextToken().id();
        switch (n) {
            case 9: {
                return JrsBoolean.TRUE;
            }
            case 10: {
                return JrsBoolean.FALSE;
            }
            case 7: 
            case 8: {
                return new JrsNumber(jsonParser.getNumberValue());
            }
            case 6: {
                return new JrsString(jsonParser.getText());
            }
            case 3: {
                List<JrsValue> list = this._list();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    list.add(this.nodeFrom(jsonParser));
                }
                return new JrsArray(list);
            }
            case 1: {
                Map<String, JrsValue> map = this._map();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String string = jsonParser.getCurrentName();
                    jsonParser.nextToken();
                    map.put(string, this.nodeFrom(jsonParser));
                }
                return new JrsObject(map);
            }
            case 12: {
                return new JrsEmbeddedObject(jsonParser.getEmbeddedObject());
            }
            case 11: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported token id " + n + " (" + (Object)((Object)jsonParser.getCurrentToken()) + ")");
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws IOException {
        if (treeNode == null) {
            jsonGenerator.writeNull();
        } else {
            ((JrsValue)treeNode).write(jsonGenerator, this);
        }
    }

    @Override
    public TreeNode createArrayNode() {
        return new JrsArray(this._list());
    }

    @Override
    public TreeNode createObjectNode() {
        return new JrsObject(this._map());
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        return ((JrsValue)treeNode).traverse(this._objectCodec);
    }

    public TreeNode missingNode() {
        return JrsMissing.instance;
    }

    protected List<JrsValue> _list() {
        return new ArrayList<JrsValue>();
    }

    protected Map<String, JrsValue> _map() {
        return new LinkedHashMap<String, JrsValue>();
    }
}

