/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsEmbeddedObject;
import com.fasterxml.jackson.jr.stree.JrsMissing;
import com.fasterxml.jackson.jr.stree.JrsNull;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonJrsTreeCodec
extends TreeCodec {
    public static JrsMissing MISSING = JrsMissing.instance;
    protected final ObjectCodec _objectCodec;
    protected boolean _failOnDuplicateKeys;

    public JacksonJrsTreeCodec() {
        this(null);
    }

    public JacksonJrsTreeCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public void setFailOnDuplicateKeys(boolean bl) {
        this._failOnDuplicateKeys = bl;
    }

    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException {
        return (T)this.nodeFrom(jsonParser);
    }

    private JrsValue nodeFrom(JsonParser jsonParser) throws IOException {
        int n = jsonParser.hasCurrentToken() ? jsonParser.currentTokenId() : jsonParser.nextToken().id();
        switch (n) {
            case 9: {
                return JrsBoolean.TRUE;
            }
            case 10: {
                return JrsBoolean.FALSE;
            }
            case 7: 
            case 8: {
                return new JrsNumber(jsonParser.getNumberValue());
            }
            case 6: {
                return new JrsString(jsonParser.getText());
            }
            case 3: {
                List<JrsValue> list = this._list();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    list.add(this.nodeFrom(jsonParser));
                }
                return new JrsArray(list);
            }
            case 1: {
                Map<String, JrsValue> map = this._map();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String string = jsonParser.currentName();
                    jsonParser.nextToken();
                    JrsValue jrsValue = map.put(string, this.nodeFrom(jsonParser));
                    if (!this._failOnDuplicateKeys || jrsValue == null) continue;
                    throw new JSONObjectException("Duplicate key (key '" + string + "')");
                }
                return new JrsObject(map);
            }
            case 12: {
                return new JrsEmbeddedObject(jsonParser.getEmbeddedObject());
            }
            case 11: {
                return JrsNull.instance;
            }
        }
        throw new UnsupportedOperationException("Unsupported token id " + n + " (" + jsonParser.currentToken() + ")");
    }

    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws IOException {
        if (treeNode == null) {
            jsonGenerator.writeNull();
        } else {
            ((JrsValue)treeNode).write(jsonGenerator, this);
        }
    }

    public JrsValue createArrayNode() {
        return new JrsArray(this._list());
    }

    public JrsValue createObjectNode() {
        return new JrsObject(this._map());
    }

    public JrsValue missingNode() {
        return JrsMissing.instance();
    }

    public JrsValue nullNode() {
        return JrsNull.instance();
    }

    public JsonParser treeAsTokens(TreeNode treeNode) {
        return treeNode.traverse(this._objectCodec);
    }

    public JrsBoolean booleanNode(boolean bl) {
        return bl ? JrsBoolean.TRUE : JrsBoolean.FALSE;
    }

    public JrsString stringNode(String string) {
        if (string == null) {
            string = "";
        }
        return new JrsString(string);
    }

    public JrsNumber numberNode(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        return new JrsNumber(number);
    }

    protected List<JrsValue> _list() {
        return new ArrayList<JrsValue>();
    }

    protected Map<String, JrsValue> _map() {
        return new LinkedHashMap<String, JrsValue>();
    }
}

