/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlAdapterJsonSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
SchemaAware {
    protected final XmlAdapter<?, Object> _xmlAdapter;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _serializer;

    public XmlAdapterJsonSerializer(XmlAdapter<?, ?> xmlAdapter) {
        this(xmlAdapter, null, null);
    }

    protected XmlAdapterJsonSerializer(XmlAdapter<?, Object> xmlAdapter, JavaType valueType, JsonSerializer<Object> serializer) {
        super(Object.class);
        this._xmlAdapter = xmlAdapter;
        this._valueType = valueType;
        this._serializer = serializer;
    }

    public JsonSerializer<Object> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JavaType valueType;
        JavaType type;
        TypeFactory typeFactory = prov.getConfig().getTypeFactory();
        JavaType[] rawTypes = typeFactory.findTypeParameters(type = typeFactory.constructType(this._xmlAdapter.getClass()), XmlAdapter.class);
        if (rawTypes == null || rawTypes.length < 2) {
            valueType = TypeFactory.unknownType();
        } else {
            valueType = rawTypes[0];
            JavaType otherType = rawTypes[1];
            if (otherType != null && otherType.getRawClass() == valueType.getRawClass()) {
                throw new IllegalArgumentException("Can not yet support 'identity' adapters");
            }
        }
        JsonSerializer ser = prov.findValueSerializer(valueType, property);
        return new XmlAdapterJsonSerializer(this._xmlAdapter, valueType, (JsonSerializer<Object>)ser);
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Object adapted;
        try {
            adapted = this._xmlAdapter.marshal(value);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonMappingException("Unable to marshal: " + e.getMessage(), (Throwable)e);
        }
        if (adapted == null) {
            provider.defaultSerializeNull(jgen);
        } else {
            this._checkSerializer();
            this._serializer.serialize(adapted, jgen, provider);
        }
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        this._checkSerializer();
        if (this._serializer instanceof SchemaAware) {
            return ((SchemaAware)this._serializer).getSchema(provider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    private final void _checkSerializer() {
        if (this._serializer == null) {
            throw new IllegalStateException("No serializer assigned for XmlAdapterJsonDeserializer (" + this._xmlAdapter.getClass().getName() + "): resolve() not called?");
        }
    }
}

