/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomElementJsonDeserializer
extends StdDeserializer<Element> {
    private static final long serialVersionUID = 1L;
    private final DocumentBuilder builder;

    public DomElementJsonDeserializer() {
        super(Element.class);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException();
        }
    }

    public DomElementJsonDeserializer(DocumentBuilder documentBuilder) {
        super(Element.class);
        this.builder = documentBuilder;
    }

    public Element deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Document document = this.builder.newDocument();
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        return this.fromNode(document, jsonNode);
    }

    protected Element fromNode(Document document, JsonNode jsonNode) throws IOException {
        JsonNode jsonNode2;
        Iterator iterator;
        Object object;
        String string;
        String string2 = jsonNode.get("namespace") != null ? jsonNode.get("namespace").asText() : null;
        String string3 = string = jsonNode.get("name") != null ? jsonNode.get("name").asText() : null;
        if (string == null) {
            throw new JsonMappingException("No name for DOM element was provided in the JSON object.");
        }
        Element element = document.createElementNS(string2, string);
        JsonNode jsonNode3 = jsonNode.get("attributes");
        if (jsonNode3 != null && jsonNode3 instanceof ArrayNode) {
            object = jsonNode3.elements();
            while (object.hasNext()) {
                iterator = (JsonNode)object.next();
                string2 = iterator.get("namespace") != null ? iterator.get("namespace").asText() : null;
                string = iterator.get("name") != null ? iterator.get("name").asText() : null;
                String string4 = jsonNode2 = iterator.get("$") != null ? iterator.get("$").asText() : null;
                if (string == null) continue;
                element.setAttributeNS(string2, string, (String)jsonNode2);
            }
        }
        if ((object = jsonNode.get("children")) != null && object instanceof ArrayNode) {
            iterator = object.elements();
            while (iterator.hasNext()) {
                String string5;
                jsonNode2 = (JsonNode)iterator.next();
                string = jsonNode2.get("name") != null ? jsonNode2.get("name").asText() : null;
                String string6 = string5 = jsonNode2.get("$") != null ? jsonNode2.get("$").asText() : null;
                if (string5 != null) {
                    element.appendChild(document.createTextNode(string5));
                    continue;
                }
                if (string == null) continue;
                element.appendChild(this.fromNode(document, jsonNode2));
            }
        }
        return element;
    }
}

