/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import java.io.IOException;

public class AdditionalItemsDeserializer
extends JsonDeserializer<ArraySchema.AdditionalItems> {
    public ArraySchema.AdditionalItems deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        TreeNode node = jp.readValueAsTree();
        if (node instanceof ObjectNode) {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonSchema innerSchema = (JsonSchema)mapper.treeToValue(node, JsonSchema.class);
            return new ArraySchema.SchemaAdditionalItems(innerSchema);
        }
        if (node instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)node;
            if (booleanNode.booleanValue()) {
                return null;
            }
            return new ArraySchema.NoAdditionalItems();
        }
        throw new JsonMappingException("additionalItems nodes can only be of type Boolean or Object; instead found something starting with token " + node.asToken());
    }
}

