/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.paramnames;

import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import java.lang.reflect.Parameter;

class ParameterNamesAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    ParameterNamesAnnotationIntrospector() {
    }

    public String findImplicitPropertyName(AnnotatedMember m) {
        if (m instanceof AnnotatedParameter) {
            return this.findParameterName((AnnotatedParameter)m);
        }
        return null;
    }

    private String findParameterName(AnnotatedParameter annotatedParameter) {
        Parameter[] params;
        AnnotatedWithParams owner = annotatedParameter.getOwner();
        if (owner instanceof AnnotatedConstructor) {
            params = ((AnnotatedConstructor)owner).getAnnotated().getParameters();
        } else if (owner instanceof AnnotatedMethod) {
            params = ((AnnotatedMethod)owner).getAnnotated().getParameters();
        } else {
            return null;
        }
        Parameter p = params[annotatedParameter.getIndex()];
        return p.isNamePresent() ? p.getName() : null;
    }
}

