/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.swagger;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.swagger.SwaggerAnnotationIntrospector;
import com.fasterxml.jackson.module.swagger.TypeNameResolver;
import com.fasterxml.jackson.module.swagger.model.AllowableValue;
import com.fasterxml.jackson.module.swagger.model.Model;
import com.fasterxml.jackson.module.swagger.model.ModelProperty;
import com.fasterxml.jackson.module.swagger.model.ModelRef;
import com.wordnik.swagger.annotations.ApiModel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ModelResolver {
    protected final ObjectMapper _mapper;
    protected final AnnotationIntrospector _intr;
    protected TypeNameResolver _typeNameResolver = TypeNameResolver.std;
    protected Map<JavaType, String> _resolvedTypeNames = new ConcurrentHashMap<JavaType, String>();

    public ModelResolver(ObjectMapper mapper) {
        mapper.registerModule((Module)new SimpleModule("swagger", Version.unknownVersion()){

            public void setupModule(Module.SetupContext context) {
                context.insertAnnotationIntrospector((AnnotationIntrospector)new SwaggerAnnotationIntrospector());
            }
        });
        this._mapper = mapper;
        this._intr = mapper.getSerializationConfig().getAnnotationIntrospector();
    }

    public Model resolve(Class<?> cls) {
        return this.resolve(this._mapper.constructType(cls));
    }

    public Model resolve(JavaType type) {
        JsonTypeInfo typeInfo;
        String disc;
        List nts;
        Class parent;
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        Model model = new Model();
        String name = this._typeName(type, beanDesc);
        model.setId(name);
        model.setName(name);
        model.setQualifiedType(this._typeQName(type));
        model.setDescription(this._description((Annotated)beanDesc.getClassInfo()));
        ApiModel apiModel = (ApiModel)beanDesc.getClassAnnotations().get(ApiModel.class);
        if (apiModel != null && (parent = apiModel.parent()) != Void.class) {
            model.setBaseModel(this._typeName(this._mapper.constructType((Type)parent)));
        }
        if ((nts = this._intr.findSubtypes((Annotated)beanDesc.getClassInfo())) != null) {
            ArrayList<String> subtypeNames = new ArrayList<String>();
            for (NamedType subtype : nts) {
                subtypeNames.add(this._subTypeName(subtype));
            }
            model.setSubTypes(subtypeNames);
        }
        String string = disc = apiModel == null ? "" : apiModel.discriminator();
        if (disc.isEmpty() && (typeInfo = (JsonTypeInfo)beanDesc.getClassAnnotations().get(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            model.setDiscriminator(disc);
        }
        ArrayList<ModelProperty> props = new ArrayList<ModelProperty>();
        for (BeanPropertyDefinition propDef : beanDesc.findProperties()) {
            JavaType valueType;
            String propName = propDef.getName();
            ModelProperty modelProp = new ModelProperty(propName);
            props.add(modelProp);
            PropertyMetadata md = propDef.getMetadata();
            AnnotatedMember member = propDef.getPrimaryMember();
            JavaType propType = member.getType(beanDesc.bindingsForBeanType());
            modelProp.setType(this._typeName(propType));
            modelProp.setQualifiedType(this._typeQName(propType));
            modelProp.setRequired(md.getRequired());
            if (propType.isEnumType()) {
                this._addEnumProps(propDef, propType.getRawClass(), modelProp);
                continue;
            }
            if (!propType.isContainerType() || (valueType = propType.getContentType()) == null) continue;
            modelProp.setItems(this._modelRef(valueType));
        }
        Collections.sort(props);
        LinkedHashMap<String, ModelProperty> modelProps = new LinkedHashMap<String, ModelProperty>();
        for (ModelProperty prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        model.setProperties(modelProps);
        return model;
    }

    protected ModelRef _modelRef(JavaType type) {
        ModelRef ref = new ModelRef();
        ref.setType(this._typeName(type));
        ref.setQualifiedType(this._typeQName(type));
        return ref;
    }

    protected void _addEnumProps(BeanPropertyDefinition propDef, Class<?> propClass, ModelProperty result) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        ArrayList<AllowableValue> enums = new ArrayList<AllowableValue>();
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            enums.add(new AllowableValue(n));
        }
        result.setAllowableValues(enums);
    }

    protected String _description(Annotated ann) {
        return this._intr.findPropertyDescription(ann);
    }

    protected String _typeName(JavaType type) {
        return this._typeName(type, null);
    }

    protected String _typeName(JavaType type, BeanDescription beanDesc) {
        String name = this._resolvedTypeNames.get(type);
        if (name != null) {
            return name;
        }
        name = this._findTypeName(type, beanDesc);
        this._resolvedTypeNames.put(type, name);
        return name;
    }

    protected String _findTypeName(JavaType type, BeanDescription beanDesc) {
        PropertyName rootName;
        if (type.isArrayType()) {
            return "Array[" + this._typeName(type.getContentType()) + "]";
        }
        if (type.isMapLikeType()) {
            return "Map[" + this._typeName(type.getKeyType()) + "," + this._typeName(type.getContentType()) + "]";
        }
        if (type.isContainerType()) {
            if (Set.class.isAssignableFrom(type.getRawClass())) {
                return "Set[" + this._typeName(type.getContentType()) + "]";
            }
            return "List[" + this._typeName(type.getContentType()) + "]";
        }
        if (beanDesc == null) {
            beanDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(type);
        }
        if ((rootName = this._intr.findRootName(beanDesc.getClassInfo())) != null && rootName.hasSimpleName()) {
            return rootName.getSimpleName();
        }
        return this._typeNameResolver.nameForType(type);
    }

    protected String _typeQName(JavaType type) {
        return type.getRawClass().getName();
    }

    protected String _subTypeName(NamedType type) {
        return type.getType().getName();
    }
}

