/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.compiler.STException;

public class TemplateMojo
extends AbstractMojo {
    private File inputDir;
    private File templateDir;
    private String inputSuffix;
    private File outputDir;
    private String outputSuffix;
    private String encoding;
    private char startDelimiter;
    private char endDelimiter;
    private Map<String, String> attributes;

    public void execute() throws MojoExecutionException {
        URL url;
        if (!this.inputDir.exists()) {
            throw new MojoExecutionException("Input directory '" + this.inputDir.getAbsolutePath() + "' does not exist");
        }
        File templates = this.templateDir;
        if (templates == null) {
            this.getLog().info((CharSequence)"No sepate 'templateDir' specified; will use 'inputDir' as template source'");
            templates = this.inputDir;
        }
        LinkedHashMap<File, File> files = new LinkedHashMap<File, File>();
        String outputSuffix = this.outputSuffix;
        TemplateMojo.findFiles(files, this.inputDir, TemplateMojo.trim(this.inputSuffix), this.outputDir, TemplateMojo.trim(outputSuffix));
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        this.getLog().info((CharSequence)String.format("Found %s template files to process: %s", files.size(), ((Object)files).toString()));
        try {
            url = templates.toURI().toURL();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to convert template input directory '" + templates.getAbsolutePath() + "'");
        }
        STGroupDir templateDir = new STGroupDir(url, this.encoding, this.startDelimiter, this.endDelimiter);
        for (Map.Entry fileEntry : files.entrySet()) {
            ST stringTemplate;
            File inputFile = (File)fileEntry.getKey();
            File outputFile = (File)fileEntry.getValue();
            try {
                if (inputFile.getCanonicalPath().equals(outputFile.getCanonicalPath())) {
                    throw new MojoExecutionException("Problem: trying to replace input file '" + inputFile.getCanonicalPath() + "' with output; not allowed");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("I/O problem: " + e.getMessage(), (Exception)e);
            }
            String input = TemplateMojo.readFile(inputFile, this.encoding);
            try {
                stringTemplate = new ST((STGroup)templateDir, input);
            }
            catch (STException e) {
                throw new MojoExecutionException("Problem when trying to process input template '" + inputFile.getAbsolutePath() + "': " + e.getMessage(), (Exception)((Object)e));
            }
            if (this.attributes != null) {
                for (Map.Entry<String, String> attrEntry : this.attributes.entrySet()) {
                    stringTemplate.add(attrEntry.getKey(), (Object)attrEntry.getValue());
                }
            }
            this.getLog().info((CharSequence)("Read template '" + inputFile.getAbsolutePath() + "'; will process"));
            String output = stringTemplate.render();
            TemplateMojo.writeFile(outputFile, this.encoding, output);
            this.getLog().info((CharSequence)("Wrote output file '" + outputFile.getAbsolutePath() + "'"));
        }
    }

    private static String trim(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    private static void findFiles(Map<File, File> result, File inputDir, String inputSuffix, File outputDir, String outputSuffix) {
        for (File f : inputDir.listFiles()) {
            String name = f.getName();
            if (f.isDirectory()) {
                TemplateMojo.findFiles(result, f, inputSuffix, new File(outputDir, name), outputSuffix);
                continue;
            }
            if (!name.endsWith(inputSuffix)) continue;
            name = name.substring(0, name.length() - inputSuffix.length()) + outputSuffix;
            result.put(f, new File(outputDir, name));
        }
    }

    private static final String readFile(File inputFile, String encoding) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder((int)inputFile.length());
        char[] buf = new char[1000];
        try {
            int count;
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding);
            while ((count = in.read(buf)) >= 0) {
                sb.append(buf, 0, count);
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read input file '" + inputFile.getAbsolutePath() + "': " + e.getMessage(), (Exception)e);
        }
    }

    private static final void writeFile(File ouputtFile, String encoding, String contents) throws MojoExecutionException {
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(ouputtFile), encoding);
            w.write(contents);
            w.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write output file '" + ouputtFile.getAbsolutePath() + "': " + e.getMessage(), (Exception)e);
        }
    }
}

