/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf;

import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.BytesSegment;
import com.fasterxml.util.membuf.base.ChunkyMemBufferBase;

public abstract class ChunkyBytesMemBuffer
extends ChunkyMemBufferBase<BytesSegment> {
    protected byte[] _peekedEntry;

    protected ChunkyBytesMemBuffer(SegmentAllocator<BytesSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, BytesSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected ChunkyBytesMemBuffer(ChunkyBytesMemBuffer src) {
        super(src);
        this._peekedEntry = src._peekedEntry;
    }

    @Override
    public synchronized int getEntryCount() {
        return this._peekedEntry == null ? this._entryCount : this._entryCount + 1;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this._entryCount == 0 && this._peekedEntry == null;
    }

    public abstract void appendEntry(byte[] var1);

    public abstract void appendEntry(byte[] var1, int var2, int var3);

    public abstract boolean tryAppendEntry(byte[] var1);

    public abstract boolean tryAppendEntry(byte[] var1, int var2, int var3);

    public abstract byte[] getNextEntry() throws InterruptedException;

    public abstract byte[] getNextEntryIfAvailable();

    public abstract byte[] getNextEntry(long var1) throws InterruptedException;

    public abstract int readNextEntry(byte[] var1, int var2) throws InterruptedException;

    public abstract int readNextEntryIfAvailable(byte[] var1, int var2);

    public abstract int readNextEntry(long var1, byte[] var3, int var4) throws InterruptedException;

    @Override
    public synchronized int skipNextEntry() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._entryCount < 1) {
            return -1;
        }
        if (this._peekedEntry != null) {
            int len = this._peekedEntry.length;
            this._peekedEntry = null;
            return len;
        }
        int segLen = this.getNextEntryLength();
        this._nextEntryLength = -1;
        --this._entryCount;
        this._totalPayloadLength -= (long)segLen;
        int remaining = segLen;
        String error = null;
        while (remaining > 0 && (remaining -= ((BytesSegment)this._tail).skip(remaining)) != 0) {
            error = this._freeReadSegment(error);
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return segLen;
    }

    public abstract byte[] peekNextEntry();

    @Override
    protected void _clearPeeked() {
        this._peekedEntry = null;
    }

    @Override
    protected int _peekedLength() {
        return this._peekedEntry == null ? 0 : this._peekedEntry.length;
    }
}

