/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf;

import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.ChunkyMemBufferBase;
import com.fasterxml.util.membuf.base.LongsSegment;

public abstract class ChunkyLongsMemBuffer
extends ChunkyMemBufferBase<LongsSegment> {
    protected long[] _peekedEntry;

    protected ChunkyLongsMemBuffer(SegmentAllocator<LongsSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, LongsSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected ChunkyLongsMemBuffer(ChunkyLongsMemBuffer src) {
        super(src);
        this._peekedEntry = src._peekedEntry;
    }

    @Override
    public synchronized int getEntryCount() {
        return this._peekedEntry == null ? this._entryCount : this._entryCount + 1;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this._entryCount == 0 && this._peekedEntry == null;
    }

    @Override
    public synchronized long getTotalPayloadLength() {
        return this._peekedEntry == null ? this._totalPayloadLength : (long)this._peekedEntry.length + this._totalPayloadLength;
    }

    public final void appendEntry(long[] data) {
        this.appendEntry(data, 0, data.length);
    }

    public final void appendEntry(long[] data, int dataOffset, int dataLength) {
        if (!this.tryAppendEntry(data, dataOffset, dataLength)) {
            throw new IllegalStateException("Not enough room in buffer to append entry of " + dataLength + " (can't allocate enough new segments)");
        }
    }

    public final boolean tryAppendEntry(long[] data) {
        return this.tryAppendEntry(data, 0, data.length);
    }

    public abstract boolean tryAppendEntry(long[] var1, int var2, int var3);

    @Override
    public abstract int getNextEntryLength();

    public abstract long[] getNextEntry() throws InterruptedException;

    public abstract long[] getNextEntryIfAvailable();

    public abstract long[] getNextEntry(long var1) throws InterruptedException;

    public abstract int readNextEntry(long[] var1, int var2) throws InterruptedException;

    public abstract int readNextEntryIfAvailable(long[] var1, int var2);

    public abstract int readNextEntry(long var1, long[] var3, int var4) throws InterruptedException;

    @Override
    public synchronized int skipNextEntry() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._entryCount < 1) {
            return -1;
        }
        if (this._peekedEntry != null) {
            int len = this._peekedEntry.length;
            this._peekedEntry = null;
            return len;
        }
        int segLen = this.getNextEntryLength();
        this._nextEntryLength = -1;
        --this._entryCount;
        this._totalPayloadLength -= (long)segLen;
        int remaining = segLen;
        String error = null;
        while (remaining > 0 && (remaining -= ((LongsSegment)this._tail).skip(remaining)) != 0) {
            error = this._freeReadSegment(error);
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return segLen;
    }

    public abstract long[] peekNextEntry();

    @Override
    protected void _clearPeeked() {
        this._peekedEntry = null;
    }

    @Override
    protected int _peekedLength() {
        return this._peekedEntry == null ? 0 : this._peekedEntry.length;
    }
}

