/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf;

import com.fasterxml.util.membuf.ChunkyLongsMemBuffer;
import com.fasterxml.util.membuf.MemBufferDecorator;
import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.StreamyLongsMemBuffer;
import com.fasterxml.util.membuf.base.LongsSegment;
import com.fasterxml.util.membuf.base.MemBuffersBase;
import com.fasterxml.util.membuf.impl.ByteBufferLongsSegment;
import com.fasterxml.util.membuf.impl.ChunkyLongsMemBufferImpl;
import com.fasterxml.util.membuf.impl.StreamyLongsMemBufferImpl;

public class MemBuffersForLongs
extends MemBuffersBase<LongsSegment, ChunkyLongsMemBuffer, StreamyLongsMemBuffer> {
    public MemBuffersForLongs(int segmentSize, int segmentsToRetain, int maxSegments) {
        this(ByteBufferLongsSegment.allocator(segmentSize, segmentsToRetain, maxSegments, true));
    }

    public MemBuffersForLongs(SegmentAllocator<LongsSegment> allocator) {
        super(allocator, null, null);
    }

    public MemBuffersForLongs(SegmentAllocator<LongsSegment> allocator, MemBufferDecorator<ChunkyLongsMemBuffer> chunkyDecorator, MemBufferDecorator<StreamyLongsMemBuffer> streamyDecorator) {
        super(allocator, chunkyDecorator, streamyDecorator);
    }

    public MemBuffersForLongs withAllocator(SegmentAllocator<LongsSegment> allocator) {
        return new MemBuffersForLongs(allocator, this._chunkyDecorator, this._streamyDecorator);
    }

    public MemBuffersForLongs withChunkyDecorator(MemBufferDecorator<ChunkyLongsMemBuffer> chunkyDecorator) {
        return new MemBuffersForLongs(this._segmentAllocator, chunkyDecorator, this._streamyDecorator);
    }

    public MemBuffersForLongs withStreamyDecorator(MemBufferDecorator<StreamyLongsMemBuffer> streamyDecorator) {
        return new MemBuffersForLongs(this._segmentAllocator, this._chunkyDecorator, streamyDecorator);
    }

    @Override
    protected ChunkyLongsMemBuffer _createChunkyBuffer(int minSegmentsForBuffer, int maxSegmentsForBuffer, LongsSegment initialSegments) {
        return new ChunkyLongsMemBufferImpl(this._segmentAllocator, minSegmentsForBuffer, maxSegmentsForBuffer, initialSegments);
    }

    @Override
    protected StreamyLongsMemBuffer _createStreamyBuffer(int minSegmentsForBuffer, int maxSegmentsForBuffer, LongsSegment initialSegments) {
        return new StreamyLongsMemBufferImpl(this._segmentAllocator, minSegmentsForBuffer, maxSegmentsForBuffer, initialSegments);
    }
}

