/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf;

import com.fasterxml.util.membuf.Segment;

public abstract class SegmentAllocator<T extends Segment<T>> {
    protected final int _segmentSize;
    protected final int _maxReusableSegments;
    protected final int _maxSegmentsToAllocate;
    protected int _bufferOwnedSegmentCount;
    protected int _reusableSegmentCount;

    public SegmentAllocator(int segmentSize, int minSegmentsToRetain, int maxSegments) {
        if (minSegmentsToRetain < 0 || minSegmentsToRetain > maxSegments) {
            throw new IllegalArgumentException("minSegmentsToRetain (" + minSegmentsToRetain + ") must be at least 0; can not exceed maxSegments (" + maxSegments + ")");
        }
        this._segmentSize = segmentSize;
        this._maxReusableSegments = minSegmentsToRetain;
        this._maxSegmentsToAllocate = maxSegments;
        this._bufferOwnedSegmentCount = 0;
        this._reusableSegmentCount = 0;
    }

    public final int getSegmentSize() {
        return this._segmentSize;
    }

    public final int getReusableSegmentCount() {
        return this._reusableSegmentCount;
    }

    public final int getBufferOwnedSegmentCount() {
        return this._bufferOwnedSegmentCount;
    }

    public final int getMaxSegmentCount() {
        return this._maxSegmentsToAllocate;
    }

    public abstract T allocateSegments(int var1, T var2);

    public abstract void releaseSegment(T var1);
}

