/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf;

import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.BytesSegment;
import com.fasterxml.util.membuf.base.StreamyMemBufferBase;

public abstract class StreamyBytesMemBuffer
extends StreamyMemBufferBase<BytesSegment> {
    protected StreamyBytesMemBuffer(SegmentAllocator<BytesSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, BytesSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected StreamyBytesMemBuffer(StreamyBytesMemBuffer src) {
        super(src);
    }

    public final void append(byte value) {
        if (!this.tryAppend(value)) {
            throw new IllegalStateException("Not enough room in buffer to append a single value (can't allocate enough new segments)");
        }
    }

    public final void append(byte[] data) {
        this.append(data, 0, data.length);
    }

    public final void append(byte[] data, int dataOffset, int dataLength) {
        if (!this.tryAppend(data, dataOffset, dataLength)) {
            throw new IllegalStateException("Not enough room in buffer to append entry of " + dataLength + " (can't allocate enough new segments)");
        }
    }

    public abstract boolean tryAppend(byte var1);

    public final boolean tryAppend(byte[] data) {
        return this.tryAppend(data, 0, data.length);
    }

    public abstract boolean tryAppend(byte[] var1, int var2, int var3);

    public abstract int read() throws InterruptedException;

    public abstract int read(byte[] var1, int var2, int var3) throws InterruptedException;

    public final int read(byte[] buffer) throws InterruptedException {
        return this.read(buffer, 0, buffer.length);
    }

    public abstract int readIfAvailable(byte[] var1, int var2, int var3);

    public final int readIfAvailable(byte[] buffer) {
        return this.readIfAvailable(buffer, 0, buffer.length);
    }

    public abstract int read(long var1, byte[] var3, int var4, int var5) throws InterruptedException;
}

