/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf;

import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.LongsSegment;
import com.fasterxml.util.membuf.base.StreamyMemBufferBase;

public abstract class StreamyLongsMemBuffer
extends StreamyMemBufferBase<LongsSegment> {
    protected StreamyLongsMemBuffer(SegmentAllocator<LongsSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, LongsSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected StreamyLongsMemBuffer(StreamyLongsMemBuffer src) {
        super(src);
    }

    public final void append(long value) {
        if (!this.tryAppend(value)) {
            throw new IllegalStateException("Not enough room in buffer to append a single value (can't allocate enough new segments)");
        }
    }

    public final void append(long[] data) {
        this.append(data, 0, data.length);
    }

    public final void append(long[] data, int dataOffset, int dataLength) {
        if (!this.tryAppend(data, dataOffset, dataLength)) {
            throw new IllegalStateException("Not enough room in buffer to append entry of " + dataLength + " (can't allocate enough new segments)");
        }
    }

    public abstract boolean tryAppend(long var1);

    public final boolean tryAppend(long[] data) {
        return this.tryAppend(data, 0, data.length);
    }

    public abstract boolean tryAppend(long[] var1, int var2, int var3);

    public abstract long read() throws InterruptedException;

    public abstract int read(long[] var1, int var2, int var3) throws InterruptedException;

    public final int read(long[] buffer) throws InterruptedException {
        return this.read(buffer, 0, buffer.length);
    }

    public abstract int readIfAvailable(long[] var1, int var2, int var3);

    public final int readIfAvailable(long[] buffer) {
        return this.readIfAvailable(buffer, 0, buffer.length);
    }

    public abstract int read(long var1, long[] var3, int var4, int var5) throws InterruptedException;
}

