/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.base;

import com.fasterxml.util.membuf.ChunkyMemBuffer;
import com.fasterxml.util.membuf.Segment;
import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.MemBufferBase;

public abstract class ChunkyMemBufferBase<S extends Segment<S>>
extends MemBufferBase<S>
implements ChunkyMemBuffer {
    protected int _entryCount;
    protected int _nextEntryLength = -1;

    public ChunkyMemBufferBase(SegmentAllocator<S> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, S initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
        this._entryCount = 0;
        this._totalPayloadLength = 0L;
    }

    protected ChunkyMemBufferBase(ChunkyMemBufferBase<S> src) {
        super(src);
        this._entryCount = src._entryCount;
        this._nextEntryLength = src._nextEntryLength;
    }

    @Override
    public synchronized void clear() {
        this._entryCount = 0;
        this._nextEntryLength = -1;
        this._clear();
    }
}

