/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.base;

import com.fasterxml.util.membuf.MemBuffer;
import com.fasterxml.util.membuf.Segment;
import com.fasterxml.util.membuf.SegmentAllocator;

public abstract class MemBufferBase<S extends Segment<S>>
implements MemBuffer {
    protected final SegmentAllocator<S> _segmentAllocator;
    protected final int _segmentSize;
    protected final int _maxSegmentsForReuse;
    protected final int _maxSegmentsToAllocate;
    protected S _head;
    protected S _tail;
    protected int _usedSegmentsCount;
    protected long _totalPayloadLength;
    protected S _firstFreeSegment;
    protected int _freeSegmentCount;
    private int _readBlockedCount;

    protected MemBufferBase(SegmentAllocator<S> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, S initialSegments) {
        this._segmentAllocator = allocator;
        this._segmentSize = allocator.getSegmentSize();
        this._maxSegmentsForReuse = minSegmentsToAllocate;
        this._maxSegmentsToAllocate = maxSegmentsToAllocate;
        this._firstFreeSegment = ((Segment)initialSegments).getNext();
        ((Segment)initialSegments).relink(null);
        this._tail = initialSegments;
        this._head = this._tail;
        ((Segment)this._head).initForWriting();
        ((Segment)this._head).initForReading();
        this._usedSegmentsCount = 1;
        this._freeSegmentCount = minSegmentsToAllocate - 1;
    }

    protected MemBufferBase(MemBufferBase<S> src) {
        this._segmentAllocator = src._segmentAllocator;
        this._segmentSize = src._segmentSize;
        this._maxSegmentsForReuse = src._maxSegmentsForReuse;
        this._maxSegmentsToAllocate = src._maxSegmentsToAllocate;
        this._head = src._head;
        this._tail = src._tail;
        this._usedSegmentsCount = src._usedSegmentsCount;
        this._totalPayloadLength = src._totalPayloadLength;
        this._firstFreeSegment = src._firstFreeSegment;
        this._freeSegmentCount = src._freeSegmentCount;
        this._readBlockedCount = src._readBlockedCount;
    }

    @Override
    public final synchronized void waitUntilNotEmpty() throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this.isEmpty()) {
            this.wait();
        }
    }

    @Override
    public final synchronized void waitUntilNotEmpty(long maxWaitMsecs) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this.isEmpty()) {
            this.wait(maxWaitMsecs);
        }
    }

    public SegmentAllocator<S> getAllocator() {
        return this._segmentAllocator;
    }

    @Override
    public synchronized int getSegmentCount() {
        return this._usedSegmentsCount;
    }

    @Override
    public synchronized long getTotalPayloadLength() {
        return this._totalPayloadLength + (long)this._peekedLength();
    }

    @Override
    public synchronized long getMaximumAvailableSpace() {
        if (this._head == null) {
            return -1L;
        }
        long space = ((Segment)this._head).availableForAppend();
        int canAllocate = this._maxSegmentsToAllocate - this._usedSegmentsCount;
        if (canAllocate > 0) {
            space += (long)canAllocate * (long)this._segmentSize;
        }
        return space;
    }

    @Override
    public final synchronized void close() {
        this.clear();
        this._usedSegmentsCount = 0;
        if (this._head != null) {
            ((Segment)this._head).markFree();
            this._segmentAllocator.releaseSegment(this._head);
            this._tail = null;
            this._head = null;
        }
        S seg = this._firstFreeSegment;
        this._firstFreeSegment = null;
        this._freeSegmentCount = 0;
        while (seg != null) {
            Object next = ((Segment)seg).getNext();
            this._segmentAllocator.releaseSegment(seg);
            seg = next;
        }
        this.notifyAll();
    }

    protected void _clear() {
        if (this._head == null) {
            return;
        }
        this._totalPayloadLength = 0L;
        this._clearPeeked();
        String error = null;
        while (this._tail != this._head) {
            error = this._freeReadSegment(error);
        }
        ((Segment)this._tail).clear();
        if (error != null) {
            throw new IllegalStateException(error);
        }
    }

    protected final String _freeReadSegment(String prevError) {
        S old = this._tail;
        Object next = ((Segment)old).finishReading();
        --this._usedSegmentsCount;
        this._tail = ((Segment)next).initForReading();
        if (this._usedSegmentsCount + this._freeSegmentCount < this._maxSegmentsForReuse) {
            if (this._firstFreeSegment == null) {
                if (this._freeSegmentCount != 0) {
                    if (prevError == null) {
                        prevError = "_firstFreeSegment null; count " + this._freeSegmentCount + " (should be 0)";
                    }
                    this._freeSegmentCount = 0;
                }
                this._firstFreeSegment = old;
                this._freeSegmentCount = 1;
            } else {
                this._firstFreeSegment = ((Segment)old).relink(this._firstFreeSegment);
                ++this._freeSegmentCount;
            }
        } else {
            ((Segment)old).markFree();
            this._segmentAllocator.releaseSegment(old);
        }
        return prevError;
    }

    protected final S _reuseFree() {
        S freeSeg = this._firstFreeSegment;
        if (freeSeg == null) {
            throw new IllegalStateException("Internal error: no free segments available");
        }
        this._firstFreeSegment = ((Segment)freeSeg).getNext();
        --this._freeSegmentCount;
        this._head = freeSeg;
        ++this._usedSegmentsCount;
        return freeSeg;
    }

    protected final void _waitForData() throws InterruptedException {
        ++this._readBlockedCount;
        this.wait();
    }

    protected final void _waitForData(long timeoutMsecs) throws InterruptedException {
        ++this._readBlockedCount;
        this.wait(timeoutMsecs);
    }

    protected final void _wakeBlockedReaders() {
        if (this._readBlockedCount != 0) {
            this._readBlockedCount = 0;
            this.notifyAll();
        }
    }

    protected final void _reportClosed() {
        throw new IllegalStateException("MemBuffer instance closed, can not use");
    }

    protected abstract void _clearPeeked();

    protected abstract int _peekedLength();
}

