/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.base;

import com.fasterxml.util.membuf.ChunkyMemBuffer;
import com.fasterxml.util.membuf.MemBufferDecorator;
import com.fasterxml.util.membuf.Segment;
import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.StreamyMemBuffer;

public abstract class MemBuffersBase<S extends Segment<S>, CB extends ChunkyMemBuffer, SB extends StreamyMemBuffer> {
    protected final SegmentAllocator<S> _segmentAllocator;
    protected final MemBufferDecorator<CB> _chunkyDecorator;
    protected final MemBufferDecorator<SB> _streamyDecorator;

    public MemBuffersBase(SegmentAllocator<S> allocator) {
        this(allocator, null, null);
    }

    public MemBuffersBase(SegmentAllocator<S> allocator, MemBufferDecorator<CB> chunkyDecorator, MemBufferDecorator<SB> streamyDecorator) {
        this._segmentAllocator = allocator;
        this._chunkyDecorator = chunkyDecorator;
        this._streamyDecorator = streamyDecorator;
    }

    public final SegmentAllocator<S> getAllocator() {
        return this._segmentAllocator;
    }

    public final MemBufferDecorator<CB> getChunkyDecorator() {
        return this._chunkyDecorator;
    }

    public final MemBufferDecorator<SB> getStreamyDecorator() {
        return this._streamyDecorator;
    }

    public final CB createChunkyBuffer(int minSegmentsForBuffer, int maxSegmentsForBuffer) {
        CB buf = this.tryCreateChunkyBuffer(minSegmentsForBuffer, maxSegmentsForBuffer);
        if (buf == null) {
            throw new IllegalStateException("Failed to create a MemBuffer due to segment allocation limits");
        }
        return buf;
    }

    public final CB tryCreateChunkyBuffer(int minSegmentsForBuffer, int maxSegmentsForBuffer) {
        S initialSegments = this._segmentAllocator.allocateSegments(minSegmentsForBuffer, null);
        if (initialSegments == null) {
            return null;
        }
        Object buffer = this._createChunkyBuffer(minSegmentsForBuffer, maxSegmentsForBuffer, initialSegments);
        if (this._chunkyDecorator != null) {
            buffer = (ChunkyMemBuffer)this._chunkyDecorator.decorateMemBuffer(buffer);
        }
        return buffer;
    }

    public final SB createStreamyBuffer(int minSegmentsForBuffer, int maxSegmentsForBuffer) {
        SB buf = this.tryCreateStreamyBuffer(minSegmentsForBuffer, maxSegmentsForBuffer);
        if (buf == null) {
            throw new IllegalStateException("Failed to create a MemBuffer due to segment allocation limits");
        }
        return buf;
    }

    public final SB tryCreateStreamyBuffer(int minSegmentsForBuffer, int maxSegmentsForBuffer) {
        S initialSegments = this._segmentAllocator.allocateSegments(minSegmentsForBuffer, null);
        if (initialSegments == null) {
            return null;
        }
        Object buffer = this._createStreamyBuffer(minSegmentsForBuffer, maxSegmentsForBuffer, initialSegments);
        if (this._streamyDecorator != null) {
            buffer = (StreamyMemBuffer)this._streamyDecorator.decorateMemBuffer(buffer);
        }
        return buffer;
    }

    protected abstract CB _createChunkyBuffer(int var1, int var2, S var3);

    protected abstract SB _createStreamyBuffer(int var1, int var2, S var3);
}

